/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.model.thrift;

import hector.me.prettyprint.cassandra.model.AbstractSliceQuery;
import hector.me.prettyprint.cassandra.model.HKeyRange;
import hector.me.prettyprint.cassandra.model.KeyspaceOperationCallback;
import hector.me.prettyprint.cassandra.model.OrderedRowsImpl;
import hector.me.prettyprint.cassandra.model.QueryResultImpl;
import hector.me.prettyprint.cassandra.service.KeyspaceService;
import hector.me.prettyprint.cassandra.utils.Assert;
import hector.me.prettyprint.hector.api.Keyspace;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.beans.OrderedRows;
import hector.me.prettyprint.hector.api.exceptions.HectorException;
import hector.me.prettyprint.hector.api.query.QueryResult;
import hector.me.prettyprint.hector.api.query.RangeSubSlicesQuery;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.cassandra.thrift.ColumnParent;

public final class ThriftRangeSubSlicesQuery<K, SN, N, V>
extends AbstractSliceQuery<K, N, V, OrderedRows<K, N, V>>
implements RangeSubSlicesQuery<K, SN, N, V> {
    private final Serializer<SN> sNameSerializer;
    private final HKeyRange<K> keyRange;
    private SN superColumn;

    public ThriftRangeSubSlicesQuery(Keyspace k, Serializer<K> keySerializer, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        super(k, keySerializer, nameSerializer, valueSerializer);
        Assert.notNull(sNameSerializer, "sNameSerializer cannot be null");
        this.sNameSerializer = sNameSerializer;
        this.keyRange = new HKeyRange<K>(keySerializer);
    }

    @Override
    public RangeSubSlicesQuery<K, SN, N, V> setKeys(K start, K end) {
        this.keyRange.setKeys(start, end);
        return this;
    }

    @Override
    public RangeSubSlicesQuery<K, SN, N, V> setRowCount(int rowCount) {
        this.keyRange.setRowCount(rowCount);
        return this;
    }

    @Override
    public RangeSubSlicesQuery<K, SN, N, V> setSuperColumn(SN sc) {
        Assert.notNull(sc, "sc can't be null");
        this.superColumn = sc;
        return this;
    }

    @Override
    public QueryResult<OrderedRows<K, N, V>> execute() {
        Assert.notNull(this.columnFamilyName, "columnFamilyName can't be null");
        Assert.notNull(this.superColumn, "superColumn cannot be null");
        return new QueryResultImpl<OrderedRows<K, N, V>>(this.keyspace.doExecute(new KeyspaceOperationCallback<OrderedRows<K, N, V>>(){

            @Override
            public OrderedRows<K, N, V> doInKeyspace(KeyspaceService ks) throws HectorException {
                ColumnParent columnParent = new ColumnParent(ThriftRangeSubSlicesQuery.this.columnFamilyName);
                columnParent.setSuper_column(ThriftRangeSubSlicesQuery.this.sNameSerializer.toByteBuffer(ThriftRangeSubSlicesQuery.this.superColumn));
                Map thriftRet = ThriftRangeSubSlicesQuery.this.keySerializer.fromBytesMap(ks.getRangeSlices(columnParent, ThriftRangeSubSlicesQuery.this.getPredicate(), ThriftRangeSubSlicesQuery.this.keyRange.toThrift()));
                return new OrderedRowsImpl((LinkedHashMap)thriftRet, ThriftRangeSubSlicesQuery.this.columnNameSerializer, ThriftRangeSubSlicesQuery.this.valueSerializer);
            }
        }), this);
    }

    public String toString() {
        return "RangeSuperSlicesQuery(" + this.keyRange + super.toStringInternal() + ")";
    }

    @Override
    public RangeSubSlicesQuery<K, SN, N, V> setColumnNames(N ... columnNames) {
        return (RangeSubSlicesQuery)super.setColumnNames(columnNames);
    }

    @Override
    public RangeSubSlicesQuery<K, SN, N, V> setRange(N start, N finish, boolean reversed, int count) {
        return (RangeSubSlicesQuery)super.setRange(start, finish, reversed, count);
    }

    @Override
    public RangeSubSlicesQuery<K, SN, N, V> setColumnFamily(String cf) {
        return (RangeSubSlicesQuery)super.setColumnFamily(cf);
    }
}

