/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.model.thrift;

import hector.me.prettyprint.cassandra.model.AbstractSliceQuery;
import hector.me.prettyprint.cassandra.model.HKeyRange;
import hector.me.prettyprint.cassandra.model.KeyspaceOperationCallback;
import hector.me.prettyprint.cassandra.model.OrderedCounterSuperRowsImpl;
import hector.me.prettyprint.cassandra.model.QueryResultImpl;
import hector.me.prettyprint.cassandra.serializers.LongSerializer;
import hector.me.prettyprint.cassandra.service.KeyspaceService;
import hector.me.prettyprint.cassandra.utils.Assert;
import hector.me.prettyprint.hector.api.Keyspace;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.beans.OrderedCounterSuperRows;
import hector.me.prettyprint.hector.api.exceptions.HectorException;
import hector.me.prettyprint.hector.api.query.QueryResult;
import hector.me.prettyprint.hector.api.query.RangeSuperSlicesCounterQuery;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.cassandra.thrift.ColumnParent;

public final class ThriftRangeSuperSlicesCounterQuery<K, SN, N>
extends AbstractSliceQuery<K, SN, Long, OrderedCounterSuperRows<K, SN, N>>
implements RangeSuperSlicesCounterQuery<K, SN, N> {
    private final Serializer<N> nameSerializer;
    private final HKeyRange<K> keyRange;

    public ThriftRangeSuperSlicesCounterQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer) {
        super(keyspace, keySerializer, sNameSerializer, LongSerializer.get());
        Assert.notNull(nameSerializer, "nameSerializer cannot be null");
        this.nameSerializer = nameSerializer;
        this.keyRange = new HKeyRange<K>(keySerializer);
    }

    @Override
    public RangeSuperSlicesCounterQuery<K, SN, N> setKeys(K start, K end) {
        this.keyRange.setKeys(start, end);
        return this;
    }

    @Override
    public RangeSuperSlicesCounterQuery<K, SN, N> setRowCount(int rowCount) {
        this.keyRange.setRowCount(rowCount);
        return this;
    }

    @Override
    public QueryResult<OrderedCounterSuperRows<K, SN, N>> execute() {
        Assert.notNull(this.columnFamilyName, "columnFamilyName can't be null");
        return new QueryResultImpl<OrderedCounterSuperRows<K, SN, N>>(this.keyspace.doExecute(new KeyspaceOperationCallback<OrderedCounterSuperRows<K, SN, N>>(){

            @Override
            public OrderedCounterSuperRows<K, SN, N> doInKeyspace(KeyspaceService ks) throws HectorException {
                ColumnParent columnParent = new ColumnParent(ThriftRangeSuperSlicesCounterQuery.this.columnFamilyName);
                Map thriftRet = ThriftRangeSuperSlicesCounterQuery.this.keySerializer.fromBytesMap(ks.getSuperRangeCounterSlices(columnParent, ThriftRangeSuperSlicesCounterQuery.this.getPredicate(), ThriftRangeSuperSlicesCounterQuery.this.keyRange.toThrift()));
                return new OrderedCounterSuperRowsImpl((LinkedHashMap)thriftRet, ThriftRangeSuperSlicesCounterQuery.this.keySerializer, ThriftRangeSuperSlicesCounterQuery.this.columnNameSerializer, ThriftRangeSuperSlicesCounterQuery.this.nameSerializer);
            }
        }), this);
    }

    public String toString() {
        return "RangeSuperSlicesQuery(" + this.keyRange + super.toStringInternal() + ")";
    }

    @Override
    public RangeSuperSlicesCounterQuery<K, SN, N> setColumnNames(SN ... columnNames) {
        return (RangeSuperSlicesCounterQuery)super.setColumnNames(columnNames);
    }

    @Override
    public RangeSuperSlicesCounterQuery<K, SN, N> setRange(SN start, SN finish, boolean reversed, int count) {
        return (RangeSuperSlicesCounterQuery)super.setRange(start, finish, reversed, count);
    }

    @Override
    public RangeSuperSlicesCounterQuery<K, SN, N> setColumnFamily(String cf) {
        return (RangeSuperSlicesCounterQuery)super.setColumnFamily(cf);
    }
}

