/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.model.thrift;

import hector.me.prettyprint.cassandra.model.KeyspaceOperationCallback;
import hector.me.prettyprint.cassandra.model.QueryResultImpl;
import hector.me.prettyprint.cassandra.model.thrift.AbstractThriftCountQuery;
import hector.me.prettyprint.cassandra.service.KeyspaceService;
import hector.me.prettyprint.cassandra.utils.Assert;
import hector.me.prettyprint.hector.api.Keyspace;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.exceptions.HectorException;
import hector.me.prettyprint.hector.api.query.QueryResult;
import hector.me.prettyprint.hector.api.query.SubCountQuery;
import org.apache.cassandra.thrift.ColumnParent;

public final class ThriftSubCountQuery<K, SN, N>
extends AbstractThriftCountQuery<K, N>
implements SubCountQuery<K, SN, N> {
    private final Serializer<SN> superNameSerializer;
    private SN superColumnName;

    public ThriftSubCountQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<SN> superNameExtractor, Serializer<N> nameSerializer) {
        super(keyspace, keySerializer, nameSerializer);
        Assert.notNull(superNameExtractor, "superNameExtractor is null");
        this.superNameSerializer = superNameExtractor;
    }

    @Override
    public SubCountQuery<K, SN, N> setSuperColumn(SN sc) {
        this.superColumnName = sc;
        return this;
    }

    @Override
    public QueryResult<Integer> execute() {
        Assert.notNull(this.key, "key is null");
        Assert.notNull(this.columnFamily, "columnFamily is null");
        Assert.notNull(this.superColumnName, "superColumnName is null");
        return new QueryResultImpl<Integer>(this.keyspace.doExecute(new KeyspaceOperationCallback<Integer>(){

            @Override
            public Integer doInKeyspace(KeyspaceService ks) throws HectorException {
                ColumnParent columnParent = new ColumnParent(ThriftSubCountQuery.this.columnFamily);
                columnParent.setSuper_column(ThriftSubCountQuery.this.superNameSerializer.toByteBuffer(ThriftSubCountQuery.this.superColumnName));
                Integer count = ks.getCount(ThriftSubCountQuery.this.keySerializer.toByteBuffer(ThriftSubCountQuery.this.key), columnParent, ThriftSubCountQuery.this.slicePredicate.toThrift());
                return count;
            }
        }), this);
    }

    public String toString() {
        return "SubCountQuery(" + this.columnFamily + "," + this.key + "," + this.superColumnName + ")";
    }

    @Override
    public SubCountQuery<K, SN, N> setKey(K key) {
        return (SubCountQuery)super.setKey(key);
    }

    @Override
    public SubCountQuery<K, SN, N> setColumnFamily(String cf) {
        return (SubCountQuery)super.setColumnFamily(cf);
    }

    public SubCountQuery<K, SN, N> setColumnNames(N ... columnNames) {
        return (SubCountQuery)super.setColumnNames(columnNames);
    }

    @Override
    public SubCountQuery<K, SN, N> setRange(N start, N finish, int count) {
        return (SubCountQuery)super.setRange(start, finish, count);
    }
}

