/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.model.thrift;

import hector.me.prettyprint.cassandra.model.AbstractSliceQuery;
import hector.me.prettyprint.cassandra.model.CounterSuperSliceImpl;
import hector.me.prettyprint.cassandra.model.KeyspaceOperationCallback;
import hector.me.prettyprint.cassandra.model.QueryResultImpl;
import hector.me.prettyprint.cassandra.serializers.LongSerializer;
import hector.me.prettyprint.cassandra.service.KeyspaceService;
import hector.me.prettyprint.cassandra.utils.Assert;
import hector.me.prettyprint.hector.api.Keyspace;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.beans.CounterSuperSlice;
import hector.me.prettyprint.hector.api.exceptions.HectorException;
import hector.me.prettyprint.hector.api.query.QueryResult;
import hector.me.prettyprint.hector.api.query.SuperSliceCounterQuery;
import java.util.List;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.CounterSuperColumn;

public final class ThriftSuperSliceCounterQuery<K, SN, N>
extends AbstractSliceQuery<K, SN, Long, CounterSuperSlice<SN, N>>
implements SuperSliceCounterQuery<K, SN, N> {
    private K key;
    private final Serializer<N> nameSerializer;

    public ThriftSuperSliceCounterQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer) {
        super(keyspace, keySerializer, sNameSerializer, LongSerializer.get());
        Assert.notNull(sNameSerializer, "sNameSerializer cannot be null");
        this.nameSerializer = nameSerializer;
    }

    @Override
    public SuperSliceCounterQuery<K, SN, N> setKey(K key) {
        this.key = key;
        return this;
    }

    @Override
    public QueryResult<CounterSuperSlice<SN, N>> execute() {
        return new QueryResultImpl<CounterSuperSlice<SN, N>>(this.keyspace.doExecute(new KeyspaceOperationCallback<CounterSuperSlice<SN, N>>(){

            @Override
            public CounterSuperSlice<SN, N> doInKeyspace(KeyspaceService ks) throws HectorException {
                ColumnParent columnParent = new ColumnParent(ThriftSuperSliceCounterQuery.this.columnFamilyName);
                List<CounterSuperColumn> thriftRet = ks.getCounterSuperSlice(ThriftSuperSliceCounterQuery.this.keySerializer.toByteBuffer(ThriftSuperSliceCounterQuery.this.key), columnParent, ThriftSuperSliceCounterQuery.this.getPredicate());
                return new CounterSuperSliceImpl(thriftRet, ThriftSuperSliceCounterQuery.this.columnNameSerializer, ThriftSuperSliceCounterQuery.this.nameSerializer);
            }
        }), this);
    }

    public String toString() {
        return "SuperSliceQuery(" + this.key + "," + this.toStringInternal() + ")";
    }

    @Override
    public SuperSliceCounterQuery<K, SN, N> setColumnNames(SN ... columnNames) {
        return (SuperSliceCounterQuery)super.setColumnNames(columnNames);
    }

    @Override
    public SuperSliceCounterQuery<K, SN, N> setRange(SN start, SN finish, boolean reversed, int count) {
        return (SuperSliceCounterQuery)super.setRange(start, finish, reversed, count);
    }

    @Override
    public SuperSliceCounterQuery<K, SN, N> setColumnFamily(String cf) {
        return (SuperSliceCounterQuery)super.setColumnFamily(cf);
    }
}

