/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.model.thrift;

import hector.me.prettyprint.cassandra.model.AbstractSliceQuery;
import hector.me.prettyprint.cassandra.model.KeyspaceOperationCallback;
import hector.me.prettyprint.cassandra.model.QueryResultImpl;
import hector.me.prettyprint.cassandra.model.SuperSliceImpl;
import hector.me.prettyprint.cassandra.service.KeyspaceService;
import hector.me.prettyprint.cassandra.utils.Assert;
import hector.me.prettyprint.hector.api.Keyspace;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.beans.SuperSlice;
import hector.me.prettyprint.hector.api.exceptions.HectorException;
import hector.me.prettyprint.hector.api.query.QueryResult;
import hector.me.prettyprint.hector.api.query.SuperSliceQuery;
import java.util.List;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.SuperColumn;

public final class ThriftSuperSliceQuery<K, SN, N, V>
extends AbstractSliceQuery<K, SN, V, SuperSlice<SN, N, V>>
implements SuperSliceQuery<K, SN, N, V> {
    private K key;
    private final Serializer<N> nameSerializer;

    public ThriftSuperSliceQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        super(keyspace, keySerializer, sNameSerializer, valueSerializer);
        Assert.notNull(sNameSerializer, "sNameSerializer cannot be null");
        this.nameSerializer = nameSerializer;
    }

    @Override
    public SuperSliceQuery<K, SN, N, V> setKey(K key) {
        this.key = key;
        return this;
    }

    @Override
    public QueryResult<SuperSlice<SN, N, V>> execute() {
        return new QueryResultImpl<SuperSlice<SN, N, V>>(this.keyspace.doExecute(new KeyspaceOperationCallback<SuperSlice<SN, N, V>>(){

            @Override
            public SuperSlice<SN, N, V> doInKeyspace(KeyspaceService ks) throws HectorException {
                ColumnParent columnParent = new ColumnParent(ThriftSuperSliceQuery.this.columnFamilyName);
                List<SuperColumn> thriftRet = ks.getSuperSlice(ThriftSuperSliceQuery.this.keySerializer.toByteBuffer(ThriftSuperSliceQuery.this.key), columnParent, ThriftSuperSliceQuery.this.getPredicate());
                return new SuperSliceImpl(thriftRet, ThriftSuperSliceQuery.this.columnNameSerializer, ThriftSuperSliceQuery.this.nameSerializer, ThriftSuperSliceQuery.this.valueSerializer);
            }
        }), this);
    }

    public String toString() {
        return "SuperSliceQuery(" + this.key + "," + this.toStringInternal() + ")";
    }

    @Override
    public SuperSliceQuery<K, SN, N, V> setColumnNames(SN ... columnNames) {
        return (SuperSliceQuery)super.setColumnNames(columnNames);
    }

    @Override
    public SuperSliceQuery<K, SN, N, V> setRange(SN start, SN finish, boolean reversed, int count) {
        return (SuperSliceQuery)super.setRange(start, finish, reversed, count);
    }

    @Override
    public SuperSliceQuery<K, SN, N, V> setColumnFamily(String cf) {
        return (SuperSliceQuery)super.setColumnFamily(cf);
    }
}

