/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.serializers;

import hector.me.prettyprint.cassandra.serializers.AbstractSerializer;
import hector.me.prettyprint.hector.api.Serializer;
import java.nio.ByteBuffer;

public final class BytesArraySerializer
extends AbstractSerializer<byte[]>
implements Serializer<byte[]> {
    private static final BytesArraySerializer instance = new BytesArraySerializer();

    public static BytesArraySerializer get() {
        return instance;
    }

    @Override
    public ByteBuffer toByteBuffer(byte[] obj) {
        if (obj == null) {
            return null;
        }
        return ByteBuffer.wrap(obj);
    }

    @Override
    public byte[] fromByteBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        byte[] bytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(bytes, 0, bytes.length);
        return bytes;
    }
}

