/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.serializers;

import hector.me.prettyprint.cassandra.serializers.AbstractSerializer;
import hector.me.prettyprint.cassandra.serializers.IntegerSerializer;
import java.nio.ByteBuffer;

public class FloatSerializer
extends AbstractSerializer<Float> {
    private static final FloatSerializer instance = new FloatSerializer();

    public static FloatSerializer get() {
        return instance;
    }

    @Override
    public ByteBuffer toByteBuffer(Float obj) {
        return IntegerSerializer.get().toByteBuffer(Float.floatToRawIntBits(obj.floatValue()));
    }

    @Override
    public Float fromByteBuffer(ByteBuffer bytes) {
        return Float.valueOf(Float.intBitsToFloat(IntegerSerializer.get().fromByteBuffer(bytes)));
    }
}

