/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.serializers;

import hector.me.prettyprint.cassandra.serializers.AbstractSerializer;
import hector.me.prettyprint.cassandra.serializers.BigIntegerSerializer;
import hector.me.prettyprint.cassandra.serializers.BooleanSerializer;
import hector.me.prettyprint.cassandra.serializers.ByteBufferSerializer;
import hector.me.prettyprint.cassandra.serializers.BytesArraySerializer;
import hector.me.prettyprint.cassandra.serializers.CharSerializer;
import hector.me.prettyprint.cassandra.serializers.CompositeSerializer;
import hector.me.prettyprint.cassandra.serializers.DateSerializer;
import hector.me.prettyprint.cassandra.serializers.DoubleSerializer;
import hector.me.prettyprint.cassandra.serializers.FloatSerializer;
import hector.me.prettyprint.cassandra.serializers.IntegerSerializer;
import hector.me.prettyprint.cassandra.serializers.LongSerializer;
import hector.me.prettyprint.cassandra.serializers.ObjectSerializer;
import hector.me.prettyprint.cassandra.serializers.ShortSerializer;
import hector.me.prettyprint.cassandra.serializers.StringSerializer;
import hector.me.prettyprint.cassandra.serializers.UUIDSerializer;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.beans.Composite;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.UUID;

public class SerializerTypeInferer {
    public static <T> Serializer<T> getSerializer(Object value) {
        AbstractSerializer serializer = null;
        if (value == null) {
            serializer = ByteBufferSerializer.get();
        } else if (value instanceof BigInteger) {
            serializer = BigIntegerSerializer.get();
        } else if (value instanceof Boolean) {
            serializer = BooleanSerializer.get();
        } else if (value instanceof byte[]) {
            serializer = BytesArraySerializer.get();
        } else if (value instanceof ByteBuffer) {
            serializer = ByteBufferSerializer.get();
        } else if (value instanceof Character) {
            serializer = CharSerializer.get();
        } else if (value instanceof Composite) {
            serializer = CompositeSerializer.get();
        } else if (value instanceof Date) {
            serializer = DateSerializer.get();
        } else if (value instanceof Double) {
            serializer = DoubleSerializer.get();
        } else if (value instanceof Float) {
            serializer = FloatSerializer.get();
        } else if (value instanceof Integer) {
            serializer = IntegerSerializer.get();
        } else if (value instanceof Long) {
            serializer = LongSerializer.get();
        } else if (value instanceof Short) {
            serializer = ShortSerializer.get();
        } else if (value instanceof String) {
            serializer = StringSerializer.get();
        } else if (value instanceof UUID) {
            serializer = UUIDSerializer.get();
        } else if (value instanceof Serializable) {
            serializer = ObjectSerializer.get();
        }
        return serializer;
    }

    public static <T> Serializer<T> getSerializer(Class<?> valueClass) {
        AbstractSerializer serializer = null;
        if (valueClass == BigInteger.class) {
            serializer = BigIntegerSerializer.get();
        } else if (valueClass.equals(Boolean.class) || valueClass.equals(Boolean.TYPE)) {
            serializer = BooleanSerializer.get();
        } else if (valueClass.equals(byte[].class)) {
            serializer = BytesArraySerializer.get();
        } else if (valueClass.equals(ByteBuffer.class)) {
            serializer = ByteBufferSerializer.get();
        } else if (valueClass.equals(Character.class)) {
            serializer = CharSerializer.get();
        } else if (valueClass.equals(Composite.class)) {
            serializer = CompositeSerializer.get();
        } else if (valueClass.equals(Date.class)) {
            serializer = DateSerializer.get();
        } else if (valueClass.equals(Double.class) || valueClass.equals(Double.TYPE)) {
            serializer = DoubleSerializer.get();
        } else if (valueClass.equals(Float.class) || valueClass.equals(Float.TYPE)) {
            serializer = FloatSerializer.get();
        } else if (valueClass.equals(Integer.class) || valueClass.equals(Integer.TYPE)) {
            serializer = IntegerSerializer.get();
        } else if (valueClass.equals(Long.class) || valueClass.equals(Long.TYPE)) {
            serializer = LongSerializer.get();
        } else if (valueClass.equals(Short.class) || valueClass.equals(Short.TYPE)) {
            serializer = LongSerializer.get();
        } else if (valueClass.equals(String.class)) {
            serializer = StringSerializer.get();
        } else if (valueClass.equals(UUID.class)) {
            serializer = UUIDSerializer.get();
        } else if (SerializerTypeInferer.isSerializable(valueClass)) {
            serializer = ObjectSerializer.get();
        }
        return serializer;
    }

    public static boolean isSerializable(Class<?> clazz) {
        return SerializerTypeInferer.isImplementedBy(clazz, Serializable.class);
    }

    public static boolean isImplementedBy(Class<?> clazz, Class<?> target) {
        if (null == clazz || null == target) {
            return false;
        }
        Class<?>[] interArr = clazz.getInterfaces();
        if (null == interArr) {
            return false;
        }
        for (Class<?> interfa : interArr) {
            if (!interfa.equals(target)) continue;
            return true;
        }
        return false;
    }
}

