/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.service;

import hector.me.prettyprint.hector.api.beans.ColumnSlice;
import hector.me.prettyprint.hector.api.beans.HColumn;
import hector.me.prettyprint.hector.api.query.SliceQuery;
import java.util.Iterator;

public class ColumnSliceIterator<K, N, V>
implements Iterator<HColumn<N, V>> {
    private static final int DEFAULT_COUNT = 100;
    private SliceQuery<K, N, V> query;
    private Iterator<HColumn<N, V>> iterator;
    private N start;
    private ColumnSliceFinish<N> finish;
    private boolean reversed;
    private int count = 100;
    private int columns = 0;

    public ColumnSliceIterator(SliceQuery<K, N, V> query, N start, N finish, boolean reversed) {
        this(query, start, finish, reversed, 100);
    }

    public ColumnSliceIterator(SliceQuery<K, N, V> query, N start, final N finish, boolean reversed, int count) {
        this(query, start, new ColumnSliceFinish<N>(){

            @Override
            public N function() {
                return finish;
            }
        }, reversed, count);
    }

    public ColumnSliceIterator(SliceQuery<K, N, V> query, N start, ColumnSliceFinish<N> finish, boolean reversed) {
        this(query, start, finish, reversed, 100);
    }

    public ColumnSliceIterator(SliceQuery<K, N, V> query, N start, ColumnSliceFinish<N> finish, boolean reversed, int count) {
        this.query = query;
        this.start = start;
        this.finish = finish;
        this.reversed = reversed;
        this.count = count;
        this.query.setRange(this.start, this.finish.function(), this.reversed, this.count);
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = ((ColumnSlice)this.query.execute().get()).getColumns().iterator();
        } else if (!this.iterator.hasNext() && this.columns == this.count) {
            this.query.setRange(this.start, this.finish.function(), this.reversed, this.count);
            this.iterator = ((ColumnSlice)this.query.execute().get()).getColumns().iterator();
            this.columns = 0;
            if (this.iterator.hasNext()) {
                this.next();
            }
        }
        return this.iterator.hasNext();
    }

    @Override
    public HColumn<N, V> next() {
        HColumn<N, V> column = this.iterator.next();
        this.start = column.getName();
        ++this.columns;
        return column;
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    public static interface ColumnSliceFinish<N> {
        public N function();
    }
}

