/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.service;

import hector.me.prettyprint.cassandra.service.ExceptionsTranslator;
import hector.me.prettyprint.hector.api.exceptions.HCassandraInternalException;
import hector.me.prettyprint.hector.api.exceptions.HInactivePoolException;
import hector.me.prettyprint.hector.api.exceptions.HInvalidRequestException;
import hector.me.prettyprint.hector.api.exceptions.HNotFoundException;
import hector.me.prettyprint.hector.api.exceptions.HPoolExhaustedException;
import hector.me.prettyprint.hector.api.exceptions.HPoolRecoverableException;
import hector.me.prettyprint.hector.api.exceptions.HTimedOutException;
import hector.me.prettyprint.hector.api.exceptions.HUnavailableException;
import hector.me.prettyprint.hector.api.exceptions.HectorException;
import hector.me.prettyprint.hector.api.exceptions.HectorTransportException;
import hector.me.prettyprint.hector.api.exceptions.PoolIllegalStateException;
import java.util.NoSuchElementException;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.thrift.thriftlib.TApplicationException;
import org.apache.cassandra.thrift.thriftlib.TException;
import org.apache.cassandra.thrift.thriftlib.protocol.TProtocolException;
import org.apache.cassandra.thrift.thriftlib.transport.TTransportException;

public final class ExceptionsTranslatorImpl
implements ExceptionsTranslator {
    @Override
    public HectorException translate(Throwable original) {
        if (original instanceof HectorException) {
            return (HectorException)original;
        }
        if (original instanceof TApplicationException) {
            return new HCassandraInternalException(((TApplicationException)original).getType(), original.getMessage());
        }
        if (original instanceof TTransportException) {
            return new HectorTransportException(original);
        }
        if (original instanceof TimedOutException) {
            return new HTimedOutException(original);
        }
        if (original instanceof InvalidRequestException) {
            String why = ((InvalidRequestException)original).getWhy();
            if (why != null && why.contains("bootstrap")) {
                return new HUnavailableException(original);
            }
            HInvalidRequestException e = new HInvalidRequestException(original);
            e.setWhy(why);
            return e;
        }
        if (original instanceof HPoolExhaustedException) {
            return (HPoolExhaustedException)original;
        }
        if (original instanceof HPoolRecoverableException) {
            return (HPoolRecoverableException)original;
        }
        if (original instanceof HInactivePoolException) {
            return (HInactivePoolException)original;
        }
        if (original instanceof TProtocolException) {
            return new HInvalidRequestException(original);
        }
        if (original instanceof NotFoundException) {
            return new HNotFoundException(original);
        }
        if (original instanceof UnavailableException) {
            return new HUnavailableException(original);
        }
        if (original instanceof TException) {
            return new HectorTransportException(original);
        }
        if (original instanceof NoSuchElementException) {
            return new HPoolExhaustedException(original);
        }
        if (original instanceof IllegalStateException) {
            return new PoolIllegalStateException(original);
        }
        return new HectorException(original);
    }
}

