/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.service;

import hector.me.prettyprint.cassandra.model.ConfigurableConsistencyLevel;
import hector.me.prettyprint.cassandra.model.ExecutingKeyspace;
import hector.me.prettyprint.cassandra.model.HColumnImpl;
import hector.me.prettyprint.cassandra.model.HSlicePredicate;
import hector.me.prettyprint.cassandra.model.thrift.ThriftConverter;
import hector.me.prettyprint.cassandra.serializers.ByteBufferSerializer;
import hector.me.prettyprint.cassandra.serializers.DateSerializer;
import hector.me.prettyprint.cassandra.serializers.DoubleSerializer;
import hector.me.prettyprint.cassandra.serializers.IntegerSerializer;
import hector.me.prettyprint.cassandra.serializers.LongSerializer;
import hector.me.prettyprint.cassandra.serializers.StringSerializer;
import hector.me.prettyprint.cassandra.serializers.UUIDSerializer;
import hector.me.prettyprint.cassandra.service.CassandraHost;
import hector.me.prettyprint.cassandra.service.ExceptionsTranslator;
import hector.me.prettyprint.cassandra.service.ExceptionsTranslatorImpl;
import hector.me.prettyprint.cassandra.service.Operation;
import hector.me.prettyprint.cassandra.service.OperationType;
import hector.me.prettyprint.hector.api.HColumnFamily;
import hector.me.prettyprint.hector.api.HConsistencyLevel;
import hector.me.prettyprint.hector.api.Keyspace;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.beans.HColumn;
import hector.me.prettyprint.hector.api.exceptions.HectorException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HColumnFamilyImpl<K, N>
implements HColumnFamily<K, N> {
    private final Log queryLogger = LogFactory.getLog((String)"HColumnFamilyLogger");
    private final Log log = LogFactory.getLog(HColumnFamily.class);
    private final ExecutingKeyspace keyspace;
    private final String columnFamilyName;
    private List<K> _keys;
    private HSlicePredicate<N> activeSlicePredicate;
    private HSlicePredicate<N> lastAppliedPredicate;
    private Serializer<K> keySerializer;
    private Serializer<N> columnNameSerializer;
    private ConfigurableConsistencyLevel consistencyLevelPolicy;
    private Map<N, HColumn<N, ByteBuffer>> columns;
    private ColumnParent columnParent;
    private ExceptionsTranslator exceptionsTranslator;
    private boolean hasValues;
    private Set<N> columnNames;
    private int rowIndex = 0;
    private Map<ByteBuffer, List<ColumnOrSuperColumn>> rows;
    private CassandraHost lastHostUsed;
    private long lastExecutionTime;

    public HColumnFamilyImpl(Keyspace keyspace, String columnFamilyName, Serializer<K> keySerializer, Serializer<N> columnNameSerializer) {
        this.keyspace = (ExecutingKeyspace)keyspace;
        this.columnFamilyName = columnFamilyName;
        this._keys = new ArrayList<K>();
        this.keySerializer = keySerializer;
        this.columnNameSerializer = columnNameSerializer;
        this.activeSlicePredicate = new HSlicePredicate<N>(columnNameSerializer);
        this.columnParent = new ColumnParent(columnFamilyName);
        this.exceptionsTranslator = new ExceptionsTranslatorImpl();
        this.consistencyLevelPolicy = new ConfigurableConsistencyLevel();
    }

    @Override
    public HColumnFamily<K, N> addKey(K key) {
        this._keys.add(key);
        return this;
    }

    @Override
    public HColumnFamily<K, N> addKeys(Collection<K> keys) {
        this._keys.addAll(keys);
        return this;
    }

    @Override
    public HColumnFamily<K, N> removeKeys() {
        this._keys.clear();
        return this;
    }

    @Override
    public HColumnFamily<K, N> setCount(int count) {
        this.activeSlicePredicate.setCount(count);
        return this;
    }

    @Override
    public HColumnFamily<K, N> setFinish(N name) {
        this.activeSlicePredicate.setEndOn(name);
        return this;
    }

    @Override
    public HColumnFamily<K, N> setReversed(boolean reversed) {
        this.activeSlicePredicate.setReversed(reversed);
        return this;
    }

    @Override
    public HColumnFamily<K, N> setStart(N name) {
        this.activeSlicePredicate.setStartOn(name);
        return this;
    }

    @Override
    public HColumnFamily<K, N> addColumnName(N columnName) {
        this.activeSlicePredicate.addColumnName(columnName);
        return this;
    }

    @Override
    public HColumnFamily<K, N> setColumnNames(Collection<N> columnNames) {
        this.activeSlicePredicate.setColumnNames(columnNames);
        return null;
    }

    @Override
    public HColumn<N, ?> getColumn(N name) {
        return null;
    }

    @Override
    public Collection<HColumn<N, ByteBuffer>> getColumns() {
        if (this.columns == null) {
            this.columns = new HashMap<N, HColumn<N, ByteBuffer>>();
        }
        if (!this.hasValues) {
            this.doExecuteSlice();
        }
        return this.columns.values();
    }

    @Override
    public HColumnFamily<K, N> clear() {
        for (HColumn<N, ByteBuffer> col : this.columns.values()) {
            col.clear();
        }
        this.hasValues = false;
        return this;
    }

    @Override
    public Date getDate(N name) {
        return this.extractColumnValue(name, DateSerializer.get());
    }

    @Override
    public double getDouble(N name) {
        return this.extractColumnValue(name, DoubleSerializer.get());
    }

    @Override
    public int getInt(N name) {
        return this.extractColumnValue(name, IntegerSerializer.get());
    }

    @Override
    public long getLong(N name) {
        return this.extractColumnValue(name, LongSerializer.get());
    }

    @Override
    public String getString(N name) {
        return this.extractColumnValue(name, StringSerializer.get());
    }

    @Override
    public UUID getUUID(N name) {
        return this.extractColumnValue(name, UUIDSerializer.get());
    }

    @Override
    public HColumnFamily<K, N> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more rows left on this HColumnFamily");
        }
        ++this.rowIndex;
        K key = this._keys.get(this.rowIndex);
        this.applyToRow(key, this.rows.get(this.keySerializer.toByteBuffer(key)));
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.rowIndex < this.rows.size() - 1;
    }

    @Override
    public void remove() {
        K key = this._keys.remove(this.rowIndex);
        this.rows.remove(key);
    }

    @Override
    public <V> V getValue(N name, Serializer<V> valueSerializer) {
        return this.extractColumnValue(name, valueSerializer);
    }

    @Override
    public HColumnFamily<K, N> setReadConsistencyLevel(HConsistencyLevel readLevel) {
        this.consistencyLevelPolicy.setDefaultReadConsistencyLevel(readLevel);
        return this;
    }

    @Override
    public HColumnFamily<K, N> setWriteConsistencyLevel(HConsistencyLevel writeLevel) {
        this.consistencyLevelPolicy.setDefaultWriteConsistencyLevel(writeLevel);
        return this;
    }

    @Override
    public long getExecutionTimeMicro() {
        return this.lastExecutionTime / 1000L;
    }

    @Override
    public CassandraHost getHostUsed() {
        return this.lastHostUsed;
    }

    private <V> V extractColumnValue(N columnName, Serializer<V> valueSerializer) {
        this.maybeExecuteSlice(columnName);
        return this.columns.get(columnName) != null && this.columns.get(columnName).getValue() != null ? (V)valueSerializer.fromByteBuffer(this.columns.get(columnName).getValue()) : null;
    }

    private void maybeExecuteSlice(N columnName) {
        if (this.columnNames == null) {
            this.columnNames = new HashSet<N>();
        }
        if (this.columns == null) {
            this.columns = new HashMap<N, HColumn<N, ByteBuffer>>();
        }
        if (this.columns.get(columnName) == null) {
            this.columnNames.add(columnName);
            this.activeSlicePredicate.setColumnNames((Collection<N>)this.columnNames);
            if (this._keys.size() == 1) {
                this.doExecuteSlice();
            } else {
                this.doExecuteMultigetSlice();
            }
        }
    }

    private void applyToRow(K key, List<ColumnOrSuperColumn> cosclist) {
        Iterator<ColumnOrSuperColumn> iterator = cosclist.iterator();
        while (iterator.hasNext()) {
            ColumnOrSuperColumn cosc = iterator.next();
            N colName = this.columnNameSerializer.fromByteBuffer(cosc.getColumn().name.duplicate());
            HColumn<N, ByteBuffer> column = this.columns.get(colName);
            if (column == null) {
                column = new HColumnImpl<N, ByteBuffer>(cosc.getColumn(), this.columnNameSerializer, ByteBufferSerializer.get());
            } else {
                ((HColumnImpl)column).apply(cosc.getColumn());
            }
            this.columns.put(colName, column);
            iterator.remove();
        }
    }

    private void applyResultStatus(long execTime, CassandraHost cassandraHost) {
        this.lastExecutionTime = execTime;
        this.lastHostUsed = cassandraHost;
    }

    private void doExecuteSlice() {
        this.keyspace.doExecuteOperation(new Operation<Column>(OperationType.READ){

            @Override
            public Column execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    if (HColumnFamilyImpl.this.queryLogger.isDebugEnabled()) {
                        HColumnFamilyImpl.this.queryLogger.debug((Object)String.format("---------\nColumnFamily: %s slicePredicate: %s", HColumnFamilyImpl.this.columnFamilyName, HColumnFamilyImpl.this.activeSlicePredicate.toString()));
                    }
                    Object key = HColumnFamilyImpl.this._keys.iterator().next();
                    List<ColumnOrSuperColumn> cosclist = cassandra.get_slice(HColumnFamilyImpl.this.keySerializer.toByteBuffer(key), HColumnFamilyImpl.this.columnParent, HColumnFamilyImpl.this.activeSlicePredicate.toThrift(), ThriftConverter.consistencyLevel(this.consistencyLevelPolicy.get(this.operationType)));
                    HColumnFamilyImpl.this.applyResultStatus(this.execTime, this.getCassandraHost());
                    HColumnFamilyImpl.this.applyToRow(key, cosclist);
                    if (HColumnFamilyImpl.this.queryLogger.isDebugEnabled()) {
                        HColumnFamilyImpl.this.queryLogger.debug((Object)String.format("Execution took %s microseconds on host %s\n----------", HColumnFamilyImpl.this.lastExecutionTime, HColumnFamilyImpl.this.lastHostUsed));
                    }
                }
                catch (Exception e) {
                    throw HColumnFamilyImpl.this.exceptionsTranslator.translate(e);
                }
                HColumnFamilyImpl.this.hasValues = true;
                return null;
            }
        });
    }

    private void doExecuteMultigetSlice() {
        this.keyspace.doExecuteOperation(new Operation<Column>(OperationType.READ){

            @Override
            public Column execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    if (HColumnFamilyImpl.this.queryLogger.isDebugEnabled()) {
                        HColumnFamilyImpl.this.queryLogger.debug((Object)String.format("---------\nColumnFamily multiget: %s slicePredicate: %s", HColumnFamilyImpl.this.columnFamilyName, HColumnFamilyImpl.this.activeSlicePredicate.toString()));
                    }
                    HColumnFamilyImpl.this.rows = cassandra.multiget_slice(HColumnFamilyImpl.this.keySerializer.toBytesList(HColumnFamilyImpl.this._keys), HColumnFamilyImpl.this.columnParent, HColumnFamilyImpl.this.activeSlicePredicate.toThrift(), ThriftConverter.consistencyLevel(this.consistencyLevelPolicy.get(this.operationType)));
                    HColumnFamilyImpl.this.applyResultStatus(this.execTime, this.getCassandraHost());
                    if (HColumnFamilyImpl.this.queryLogger.isDebugEnabled()) {
                        HColumnFamilyImpl.this.queryLogger.debug((Object)String.format("Execution took %s microseconds on host %s\n----------", HColumnFamilyImpl.this.lastExecutionTime, HColumnFamilyImpl.this.lastHostUsed));
                    }
                }
                catch (Exception e) {
                    throw HColumnFamilyImpl.this.exceptionsTranslator.translate(e);
                }
                HColumnFamilyImpl.this.hasValues = true;
                return null;
            }
        });
        this.applyToRow(this._keys.get(0), this.rows.get(this.keySerializer.toByteBuffer(this._keys.get(0))));
    }

    @Override
    public long getExecutionTimeNano() {
        return this.lastExecutionTime;
    }
}

