/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.service;

import hector.me.prettyprint.cassandra.connection.HConnectionManager;
import hector.me.prettyprint.cassandra.service.CassandraClientMonitor;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JmxMonitor {
    private final Log log = LogFactory.getLog(this.getClass());
    private MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
    private static JmxMonitor monitorInstance;
    private Map<String, CassandraClientMonitor> monitors = new HashMap<String, CassandraClientMonitor>();

    private JmxMonitor() {
    }

    public static JmxMonitor getInstance() {
        if (monitorInstance == null) {
            monitorInstance = new JmxMonitor();
        }
        return monitorInstance;
    }

    public void registerMonitor(String name, String monitorType, Object monitoringInterface) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        String monitorName = this.generateMonitorName(name, monitorType);
        this.log.info((Object)String.format("Registering JMX %s", monitorName));
        ObjectName oName = new ObjectName(monitorName);
        if (this.mbs.isRegistered(oName)) {
            this.log.info((Object)String.format("Monitor already registered: %s", oName));
            return;
        }
        this.mbs.registerMBean(monitoringInterface, oName);
    }

    private String generateMonitorName(String className, String monitorType) {
        StringBuilder sb = new StringBuilder();
        sb.append(className);
        sb.append(":ServiceType=");
        sb.append(this.getUniqueClassloaderIdentifier());
        if (null != monitorType && monitorType.length() > 0) {
            sb.append(",MonitorType=" + monitorType);
        }
        return sb.toString();
    }

    private String getUniqueClassloaderIdentifier() {
        String contextPath = this.getContextPath();
        if (contextPath != null) {
            return contextPath;
        }
        return "hector";
    }

    private String getContextPath() {
        ClassLoader loader = this.getClass().getClassLoader();
        if (loader == null) {
            return null;
        }
        URL url = loader.getResource("/");
        if (url != null) {
            String[] elements = url.toString().split("/");
            for (int i = elements.length - 1; i > 0; --i) {
                if (!"WEB-INF".equals(elements[i])) continue;
                return elements[i - 1];
            }
        }
        return null;
    }

    public CassandraClientMonitor getCassandraMonitor(HConnectionManager connectionManager) {
        CassandraClientMonitor cassandraClientMonitor = this.monitors.get(connectionManager.getClusterName());
        if (cassandraClientMonitor == null) {
            try {
                cassandraClientMonitor = new CassandraClientMonitor(connectionManager);
                this.registerMonitor("me.prettyprint.cassandra.service_" + connectionManager.getClusterName(), "hector", cassandraClientMonitor);
                this.monitors.put(connectionManager.getClusterName(), cassandraClientMonitor);
            }
            catch (MalformedObjectNameException e) {
                this.log.warn((Object)"Unable to register JMX monitor", (Throwable)e);
            }
            catch (InstanceAlreadyExistsException e) {
                this.log.warn((Object)"Unable to register JMX monitor", (Throwable)e);
            }
            catch (MBeanRegistrationException e) {
                this.log.warn((Object)"Unable to register JMX monitor", (Throwable)e);
            }
            catch (NotCompliantMBeanException e) {
                this.log.warn((Object)"Unable to register JMX monitor", (Throwable)e);
            }
        }
        return cassandraClientMonitor;
    }
}

