/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.service;

import hector.me.prettyprint.cassandra.connection.HConnectionManager;
import hector.me.prettyprint.cassandra.model.thrift.ThriftConverter;
import hector.me.prettyprint.cassandra.serializers.StringSerializer;
import hector.me.prettyprint.cassandra.service.BatchMutation;
import hector.me.prettyprint.cassandra.service.CassandraHost;
import hector.me.prettyprint.cassandra.service.ExceptionsTranslator;
import hector.me.prettyprint.cassandra.service.ExceptionsTranslatorImpl;
import hector.me.prettyprint.cassandra.service.FailoverPolicy;
import hector.me.prettyprint.cassandra.service.KeyspaceService;
import hector.me.prettyprint.cassandra.service.Operation;
import hector.me.prettyprint.cassandra.service.OperationType;
import hector.me.prettyprint.hector.api.ConsistencyLevelPolicy;
import hector.me.prettyprint.hector.api.HConsistencyLevel;
import hector.me.prettyprint.hector.api.exceptions.HectorException;
import hector.me.prettyprint.hector.api.exceptions.HectorTransportException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.CounterSuperColumn;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.thrift.SuperColumn;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KeyspaceServiceImpl
implements KeyspaceService {
    private static final Map<String, String> EMPTY_CREDENTIALS = Collections.emptyMap();
    private static final Log log = LogFactory.getLog(KeyspaceServiceImpl.class);
    private final String keyspaceName;
    private final ConsistencyLevelPolicy consistency;
    private final ExceptionsTranslator xtrans;
    private final HConnectionManager connectionManager;
    private CassandraHost cassandraHost;
    private final FailoverPolicy failoverPolicy;
    private final Map<String, String> credentials;

    public KeyspaceServiceImpl(String keyspaceName, ConsistencyLevelPolicy consistencyLevel, HConnectionManager connectionManager, FailoverPolicy failoverPolicy) throws HectorTransportException {
        this(keyspaceName, consistencyLevel, connectionManager, failoverPolicy, EMPTY_CREDENTIALS);
    }

    public KeyspaceServiceImpl(String keyspaceName, ConsistencyLevelPolicy consistencyLevel, HConnectionManager connectionManager, FailoverPolicy failoverPolicy, Map<String, String> credentials) throws HectorTransportException {
        this.consistency = consistencyLevel;
        this.keyspaceName = keyspaceName;
        this.connectionManager = connectionManager;
        this.failoverPolicy = failoverPolicy;
        this.credentials = Collections.unmodifiableMap(credentials);
        this.xtrans = new ExceptionsTranslatorImpl();
    }

    @Override
    public void batchMutate(final Map<ByteBuffer, Map<String, List<Mutation>>> mutationMap) throws HectorException {
        Operation<Void> op = new Operation<Void>(OperationType.WRITE, this.failoverPolicy, this.keyspaceName, this.credentials){

            @Override
            public Void execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    cassandra.batch_mutate(mutationMap, KeyspaceServiceImpl.this.getThriftCl(OperationType.WRITE));
                }
                catch (Exception e) {
                    throw KeyspaceServiceImpl.this.xtrans.translate(e);
                }
                return null;
            }
        };
        this.operateWithFailover(op);
    }

    @Override
    public void batchMutate(BatchMutation batchMutate) throws HectorException {
        this.batchMutate(batchMutate.getMutationMap());
    }

    @Override
    public int getCount(final ByteBuffer key, final ColumnParent columnParent, final SlicePredicate predicate) throws HectorException {
        Operation<Integer> op = new Operation<Integer>(OperationType.READ, this.failoverPolicy, this.keyspaceName, this.credentials){

            @Override
            public Integer execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    return cassandra.get_count(key, columnParent, predicate, KeyspaceServiceImpl.this.getThriftCl(OperationType.READ));
                }
                catch (Exception e) {
                    throw KeyspaceServiceImpl.this.xtrans.translate(e);
                }
            }
        };
        this.operateWithFailover(op);
        return (Integer)op.getResult();
    }

    private void operateWithFailover(Operation<?> op) throws HectorException {
        this.connectionManager.operateWithFailover(op);
        this.cassandraHost = op.getCassandraHost();
    }

    @Override
    public CassandraHost getCassandraHost() {
        return this.cassandraHost;
    }

    @Override
    public Map<ByteBuffer, List<Column>> getRangeSlices(final ColumnParent columnParent, final SlicePredicate predicate, final KeyRange keyRange) throws HectorException {
        Operation<Map<ByteBuffer, List<Column>>> op = new Operation<Map<ByteBuffer, List<Column>>>(OperationType.READ, this.failoverPolicy, this.keyspaceName, this.credentials){

            @Override
            public Map<ByteBuffer, List<Column>> execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    List<KeySlice> keySlices = cassandra.get_range_slices(columnParent, predicate, keyRange, KeyspaceServiceImpl.this.getThriftCl(OperationType.READ));
                    if (keySlices == null || keySlices.isEmpty()) {
                        return new LinkedHashMap<ByteBuffer, List<Column>>(0);
                    }
                    LinkedHashMap<ByteBuffer, List<Column>> ret = new LinkedHashMap<ByteBuffer, List<Column>>(keySlices.size());
                    for (KeySlice keySlice : keySlices) {
                        ret.put(ByteBuffer.wrap(keySlice.getKey()), KeyspaceServiceImpl.getColumnList(keySlice.getColumns()));
                    }
                    return ret;
                }
                catch (Exception e) {
                    throw KeyspaceServiceImpl.this.xtrans.translate(e);
                }
            }
        };
        this.operateWithFailover(op);
        return (Map)op.getResult();
    }

    @Override
    public Map<ByteBuffer, List<CounterColumn>> getRangeCounterSlices(final ColumnParent columnParent, final SlicePredicate predicate, final KeyRange keyRange) throws HectorException {
        Operation<Map<ByteBuffer, List<CounterColumn>>> op = new Operation<Map<ByteBuffer, List<CounterColumn>>>(OperationType.READ, this.failoverPolicy, this.keyspaceName, this.credentials){

            @Override
            public Map<ByteBuffer, List<CounterColumn>> execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    List<KeySlice> keySlices = cassandra.get_range_slices(columnParent, predicate, keyRange, KeyspaceServiceImpl.this.getThriftCl(OperationType.READ));
                    if (keySlices == null || keySlices.isEmpty()) {
                        return new LinkedHashMap<ByteBuffer, List<CounterColumn>>(0);
                    }
                    LinkedHashMap<ByteBuffer, List<CounterColumn>> ret = new LinkedHashMap<ByteBuffer, List<CounterColumn>>(keySlices.size());
                    for (KeySlice keySlice : keySlices) {
                        ret.put(ByteBuffer.wrap(keySlice.getKey()), KeyspaceServiceImpl.getCounterColumnList(keySlice.getColumns()));
                    }
                    return ret;
                }
                catch (Exception e) {
                    throw KeyspaceServiceImpl.this.xtrans.translate(e);
                }
            }
        };
        this.operateWithFailover(op);
        return (Map)op.getResult();
    }

    @Override
    public Map<ByteBuffer, List<SuperColumn>> getSuperRangeSlices(final ColumnParent columnParent, final SlicePredicate predicate, final KeyRange keyRange) throws HectorException {
        Operation<Map<ByteBuffer, List<SuperColumn>>> op = new Operation<Map<ByteBuffer, List<SuperColumn>>>(OperationType.READ, this.failoverPolicy, this.keyspaceName, this.credentials){

            @Override
            public Map<ByteBuffer, List<SuperColumn>> execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    List<KeySlice> keySlices = cassandra.get_range_slices(columnParent, predicate, keyRange, KeyspaceServiceImpl.this.getThriftCl(OperationType.READ));
                    if (keySlices == null || keySlices.isEmpty()) {
                        return new LinkedHashMap<ByteBuffer, List<SuperColumn>>();
                    }
                    LinkedHashMap<ByteBuffer, List<SuperColumn>> ret = new LinkedHashMap<ByteBuffer, List<SuperColumn>>(keySlices.size());
                    for (KeySlice keySlice : keySlices) {
                        ret.put(ByteBuffer.wrap(keySlice.getKey()), KeyspaceServiceImpl.getSuperColumnList(keySlice.getColumns()));
                    }
                    return ret;
                }
                catch (Exception e) {
                    throw KeyspaceServiceImpl.this.xtrans.translate(e);
                }
            }
        };
        this.operateWithFailover(op);
        return (Map)op.getResult();
    }

    @Override
    public Map<ByteBuffer, List<CounterSuperColumn>> getSuperRangeCounterSlices(final ColumnParent columnParent, final SlicePredicate predicate, final KeyRange keyRange) throws HectorException {
        Operation<Map<ByteBuffer, List<CounterSuperColumn>>> op = new Operation<Map<ByteBuffer, List<CounterSuperColumn>>>(OperationType.READ, this.failoverPolicy, this.keyspaceName, this.credentials){

            @Override
            public Map<ByteBuffer, List<CounterSuperColumn>> execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    List<KeySlice> keySlices = cassandra.get_range_slices(columnParent, predicate, keyRange, KeyspaceServiceImpl.this.getThriftCl(OperationType.READ));
                    if (keySlices == null || keySlices.isEmpty()) {
                        return new LinkedHashMap<ByteBuffer, List<CounterSuperColumn>>();
                    }
                    LinkedHashMap<ByteBuffer, List<CounterSuperColumn>> ret = new LinkedHashMap<ByteBuffer, List<CounterSuperColumn>>(keySlices.size());
                    for (KeySlice keySlice : keySlices) {
                        ret.put(ByteBuffer.wrap(keySlice.getKey()), KeyspaceServiceImpl.getCounterSuperColumnList(keySlice.getColumns()));
                    }
                    return ret;
                }
                catch (Exception e) {
                    throw KeyspaceServiceImpl.this.xtrans.translate(e);
                }
            }
        };
        this.operateWithFailover(op);
        return (Map)op.getResult();
    }

    @Override
    public List<Column> getSlice(final ByteBuffer key, final ColumnParent columnParent, final SlicePredicate predicate) throws HectorException {
        Operation<List<Column>> op = new Operation<List<Column>>(OperationType.READ, this.failoverPolicy, this.keyspaceName, this.credentials){

            @Override
            public List<Column> execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    List<ColumnOrSuperColumn> cosclist = cassandra.get_slice(key, columnParent, predicate, KeyspaceServiceImpl.this.getThriftCl(OperationType.READ));
                    if (cosclist == null) {
                        return null;
                    }
                    ArrayList<Column> result = new ArrayList<Column>(cosclist.size());
                    for (ColumnOrSuperColumn cosc : cosclist) {
                        result.add(cosc.getColumn());
                    }
                    return result;
                }
                catch (Exception e) {
                    throw KeyspaceServiceImpl.this.xtrans.translate(e);
                }
            }
        };
        this.operateWithFailover(op);
        return (List)op.getResult();
    }

    @Override
    public List<Column> getSlice(String key, ColumnParent columnParent, SlicePredicate predicate) throws HectorException {
        return this.getSlice(StringSerializer.get().toByteBuffer(key), columnParent, predicate);
    }

    @Override
    public List<CounterColumn> getCounterSlice(final ByteBuffer key, final ColumnParent columnParent, final SlicePredicate predicate) throws HectorException {
        Operation<List<CounterColumn>> op = new Operation<List<CounterColumn>>(OperationType.READ, this.failoverPolicy, this.keyspaceName, this.credentials){

            @Override
            public List<CounterColumn> execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    List<ColumnOrSuperColumn> cosclist = cassandra.get_slice(key, columnParent, predicate, KeyspaceServiceImpl.this.getThriftCl(OperationType.READ));
                    if (cosclist == null) {
                        return null;
                    }
                    ArrayList<CounterColumn> result = new ArrayList<CounterColumn>(cosclist.size());
                    for (ColumnOrSuperColumn cosc : cosclist) {
                        if (cosc.isSetCounter_column()) {
                            result.add(cosc.getCounter_column());
                            continue;
                        }
                        throw new HectorException("Regular Column is part of the set of Counter Column");
                    }
                    return result;
                }
                catch (Exception e) {
                    throw KeyspaceServiceImpl.this.xtrans.translate(e);
                }
            }
        };
        this.operateWithFailover(op);
        return (List)op.getResult();
    }

    @Override
    public List<CounterColumn> getCounterSlice(String key, ColumnParent columnParent, SlicePredicate predicate) throws HectorException {
        return this.getCounterSlice(StringSerializer.get().toByteBuffer(key), columnParent, predicate);
    }

    @Override
    public SuperColumn getSuperColumn(final ByteBuffer key, final ColumnPath columnPath) throws HectorException {
        Operation<SuperColumn> op = new Operation<SuperColumn>(OperationType.READ, this.failoverPolicy, this.keyspaceName, this.credentials){

            @Override
            public SuperColumn execute(Cassandra.Client cassandra) throws HectorException {
                ColumnOrSuperColumn cosc;
                try {
                    cosc = cassandra.get(key, columnPath, KeyspaceServiceImpl.this.getThriftCl(OperationType.READ));
                }
                catch (NotFoundException e) {
                    this.setException(KeyspaceServiceImpl.this.xtrans.translate(e));
                    return null;
                }
                catch (Exception e) {
                    throw KeyspaceServiceImpl.this.xtrans.translate(e);
                }
                return cosc == null ? null : cosc.getSuper_column();
            }
        };
        this.operateWithFailover(op);
        if (op.hasException()) {
            throw op.getException();
        }
        return (SuperColumn)op.getResult();
    }

    @Override
    public List<SuperColumn> getSuperSlice(String key, ColumnParent columnParent, SlicePredicate predicate) throws HectorException {
        return this.getSuperSlice(StringSerializer.get().toByteBuffer(key), columnParent, predicate);
    }

    @Override
    public SuperColumn getSuperColumn(final ByteBuffer key, final ColumnPath columnPath, boolean reversed, int size) throws HectorException {
        final SliceRange sliceRange = new SliceRange(ByteBuffer.wrap(new byte[0]), ByteBuffer.wrap(new byte[0]), reversed, size);
        Operation<SuperColumn> op = new Operation<SuperColumn>(OperationType.READ, this.failoverPolicy, this.keyspaceName, this.credentials){

            @Override
            public SuperColumn execute(Cassandra.Client cassandra) throws HectorException {
                ColumnParent clp = new ColumnParent(columnPath.getColumn_family());
                clp.setSuper_column(columnPath.getSuper_column());
                SlicePredicate sp = new SlicePredicate();
                sp.setSlice_range(sliceRange);
                try {
                    List<ColumnOrSuperColumn> cosc = cassandra.get_slice(key, clp, sp, KeyspaceServiceImpl.this.getThriftCl(OperationType.READ));
                    if (cosc == null || cosc.isEmpty()) {
                        return null;
                    }
                    return new SuperColumn(ByteBuffer.wrap(columnPath.getSuper_column()), KeyspaceServiceImpl.getColumnList(cosc));
                }
                catch (Exception e) {
                    throw KeyspaceServiceImpl.this.xtrans.translate(e);
                }
            }
        };
        this.operateWithFailover(op);
        return (SuperColumn)op.getResult();
    }

    @Override
    public SuperColumn getSuperColumn(String key, ColumnPath columnPath) throws HectorException {
        return this.getSuperColumn(StringSerializer.get().toByteBuffer(key), columnPath);
    }

    @Override
    public List<SuperColumn> getSuperSlice(final ByteBuffer key, final ColumnParent columnParent, final SlicePredicate predicate) throws HectorException {
        Operation<List<SuperColumn>> op = new Operation<List<SuperColumn>>(OperationType.READ, this.failoverPolicy, this.keyspaceName, this.credentials){

            @Override
            public List<SuperColumn> execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    List<ColumnOrSuperColumn> cosclist = cassandra.get_slice(key, columnParent, predicate, KeyspaceServiceImpl.this.getThriftCl(OperationType.READ));
                    if (cosclist == null) {
                        return null;
                    }
                    ArrayList<SuperColumn> result = new ArrayList<SuperColumn>(cosclist.size());
                    for (ColumnOrSuperColumn cosc : cosclist) {
                        result.add(cosc.getSuper_column());
                    }
                    return result;
                }
                catch (Exception e) {
                    throw KeyspaceServiceImpl.this.xtrans.translate(e);
                }
            }
        };
        this.operateWithFailover(op);
        return (List)op.getResult();
    }

    @Override
    public List<CounterSuperColumn> getCounterSuperSlice(String key, ColumnParent columnParent, SlicePredicate predicate) throws HectorException {
        return this.getCounterSuperSlice(StringSerializer.get().toByteBuffer(key), columnParent, predicate);
    }

    @Override
    public List<CounterSuperColumn> getCounterSuperSlice(final ByteBuffer key, final ColumnParent columnParent, final SlicePredicate predicate) throws HectorException {
        Operation<List<CounterSuperColumn>> op = new Operation<List<CounterSuperColumn>>(OperationType.READ, this.failoverPolicy, this.keyspaceName, this.credentials){

            @Override
            public List<CounterSuperColumn> execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    List<ColumnOrSuperColumn> cosclist = cassandra.get_slice(key, columnParent, predicate, KeyspaceServiceImpl.this.getThriftCl(OperationType.READ));
                    if (cosclist == null) {
                        return null;
                    }
                    ArrayList<CounterSuperColumn> result = new ArrayList<CounterSuperColumn>(cosclist.size());
                    for (ColumnOrSuperColumn cosc : cosclist) {
                        result.add(cosc.getCounter_super_column());
                    }
                    return result;
                }
                catch (Exception e) {
                    throw KeyspaceServiceImpl.this.xtrans.translate(e);
                }
            }
        };
        this.operateWithFailover(op);
        return (List)op.getResult();
    }

    @Override
    public void insert(final ByteBuffer key, final ColumnParent columnParent, final Column column) throws HectorException {
        Operation<Void> op = new Operation<Void>(OperationType.WRITE, this.failoverPolicy, this.keyspaceName, this.credentials){

            @Override
            public Void execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    cassandra.insert(key, columnParent, column, KeyspaceServiceImpl.this.getThriftCl(OperationType.WRITE));
                    return null;
                }
                catch (Exception e) {
                    throw KeyspaceServiceImpl.this.xtrans.translate(e);
                }
            }
        };
        this.operateWithFailover(op);
    }

    @Override
    public void addCounter(final ByteBuffer key, final ColumnParent columnParent, final CounterColumn counterColumn) throws HectorException {
        Operation<Void> op = new Operation<Void>(OperationType.WRITE, this.failoverPolicy, this.keyspaceName, this.credentials){

            @Override
            public Void execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    cassandra.add(key, columnParent, counterColumn, KeyspaceServiceImpl.this.getThriftCl(OperationType.WRITE));
                    return null;
                }
                catch (Exception e) {
                    throw KeyspaceServiceImpl.this.xtrans.translate(e);
                }
            }
        };
        this.operateWithFailover(op);
    }

    @Override
    public void addCounter(String key, ColumnParent columnParent, CounterColumn counterColumn) throws HectorException {
        this.addCounter(StringSerializer.get().toByteBuffer(key), columnParent, counterColumn);
    }

    @Override
    public void insert(String key, ColumnPath columnPath, ByteBuffer value) throws HectorException {
        ColumnParent columnParent = new ColumnParent(columnPath.getColumn_family());
        if (columnPath.isSetSuper_column()) {
            columnParent.setSuper_column(columnPath.getSuper_column());
        }
        Column column = new Column(ByteBuffer.wrap(columnPath.getColumn()));
        column.setValue(value);
        column.setTimestamp(this.connectionManager.createClock());
        this.insert(StringSerializer.get().toByteBuffer(key), columnParent, column);
    }

    @Override
    public void insert(String key, ColumnPath columnPath, ByteBuffer value, long timestamp) throws HectorException {
        ColumnParent columnParent = new ColumnParent(columnPath.getColumn_family());
        if (columnPath.isSetSuper_column()) {
            columnParent.setSuper_column(columnPath.getSuper_column());
        }
        Column column = new Column(ByteBuffer.wrap(columnPath.getColumn()));
        column.setValue(value);
        column.setTimestamp(timestamp);
        this.insert(StringSerializer.get().toByteBuffer(key), columnParent, column);
    }

    @Override
    public Map<ByteBuffer, List<Column>> multigetSlice(final List<ByteBuffer> keys, final ColumnParent columnParent, final SlicePredicate predicate) throws HectorException {
        Operation<Map<ByteBuffer, List<Column>>> getCount = new Operation<Map<ByteBuffer, List<Column>>>(OperationType.READ, this.failoverPolicy, this.keyspaceName, this.credentials){

            @Override
            public Map<ByteBuffer, List<Column>> execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    Map<ByteBuffer, List<ColumnOrSuperColumn>> cfmap = cassandra.multiget_slice(keys, columnParent, predicate, KeyspaceServiceImpl.this.getThriftCl(OperationType.READ));
                    HashMap<ByteBuffer, List<Column>> result = new HashMap<ByteBuffer, List<Column>>();
                    for (Map.Entry<ByteBuffer, List<ColumnOrSuperColumn>> entry : cfmap.entrySet()) {
                        result.put(entry.getKey(), KeyspaceServiceImpl.getColumnList(entry.getValue()));
                    }
                    return result;
                }
                catch (Exception e) {
                    throw KeyspaceServiceImpl.this.xtrans.translate(e);
                }
            }
        };
        this.operateWithFailover(getCount);
        return (Map)getCount.getResult();
    }

    @Override
    public Map<ByteBuffer, List<CounterColumn>> multigetCounterSlice(final List<ByteBuffer> keys, final ColumnParent columnParent, final SlicePredicate predicate) throws HectorException {
        Operation<Map<ByteBuffer, List<CounterColumn>>> getCount = new Operation<Map<ByteBuffer, List<CounterColumn>>>(OperationType.READ, this.failoverPolicy, this.keyspaceName, this.credentials){

            @Override
            public Map<ByteBuffer, List<CounterColumn>> execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    Map<ByteBuffer, List<ColumnOrSuperColumn>> cfmap = cassandra.multiget_slice(keys, columnParent, predicate, KeyspaceServiceImpl.this.getThriftCl(OperationType.READ));
                    HashMap<ByteBuffer, List<CounterColumn>> result = new HashMap<ByteBuffer, List<CounterColumn>>();
                    for (Map.Entry<ByteBuffer, List<ColumnOrSuperColumn>> entry : cfmap.entrySet()) {
                        result.put(entry.getKey(), KeyspaceServiceImpl.getCounterColumnList(entry.getValue()));
                    }
                    return result;
                }
                catch (Exception e) {
                    throw KeyspaceServiceImpl.this.xtrans.translate(e);
                }
            }
        };
        this.operateWithFailover(getCount);
        return (Map)getCount.getResult();
    }

    @Override
    public Map<ByteBuffer, SuperColumn> multigetSuperColumn(List<ByteBuffer> keys, ColumnPath columnPath) throws HectorException {
        return this.multigetSuperColumn(keys, columnPath, false, Integer.MAX_VALUE);
    }

    @Override
    public Map<ByteBuffer, SuperColumn> multigetSuperColumn(List<ByteBuffer> keys, ColumnPath columnPath, boolean reversed, int size) throws HectorException {
        ColumnParent clp = new ColumnParent(columnPath.getColumn_family());
        clp.setSuper_column(columnPath.getSuper_column());
        SliceRange sr = new SliceRange(ByteBuffer.wrap(new byte[0]), ByteBuffer.wrap(new byte[0]), reversed, size);
        SlicePredicate sp = new SlicePredicate();
        sp.setSlice_range(sr);
        Map<ByteBuffer, List<SuperColumn>> sclist = this.multigetSuperSlice(keys, clp, sp);
        if (sclist == null || sclist.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<ByteBuffer, SuperColumn> result = new HashMap<ByteBuffer, SuperColumn>(keys.size() * 2);
        for (Map.Entry<ByteBuffer, List<SuperColumn>> entry : sclist.entrySet()) {
            List<SuperColumn> sclistByKey = entry.getValue();
            if (sclistByKey.size() <= 0) continue;
            result.put(entry.getKey(), sclistByKey.get(0));
        }
        return result;
    }

    @Override
    public Map<ByteBuffer, List<SuperColumn>> multigetSuperSlice(final List<ByteBuffer> keys, final ColumnParent columnParent, final SlicePredicate predicate) throws HectorException {
        Operation<Map<ByteBuffer, List<SuperColumn>>> getCount = new Operation<Map<ByteBuffer, List<SuperColumn>>>(OperationType.READ, this.failoverPolicy, this.keyspaceName, this.credentials){

            @Override
            public Map<ByteBuffer, List<SuperColumn>> execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    Map<ByteBuffer, List<ColumnOrSuperColumn>> cfmap = cassandra.multiget_slice(keys, columnParent, predicate, KeyspaceServiceImpl.this.getThriftCl(OperationType.READ));
                    if (!columnParent.isSetSuper_column()) {
                        HashMap<ByteBuffer, List<SuperColumn>> result = new HashMap<ByteBuffer, List<SuperColumn>>();
                        for (Map.Entry<ByteBuffer, List<ColumnOrSuperColumn>> entry : cfmap.entrySet()) {
                            result.put(entry.getKey(), KeyspaceServiceImpl.getSuperColumnList(entry.getValue()));
                        }
                        return result;
                    }
                    HashMap<ByteBuffer, List<SuperColumn>> result = new HashMap<ByteBuffer, List<SuperColumn>>();
                    for (Map.Entry<ByteBuffer, List<ColumnOrSuperColumn>> entry : cfmap.entrySet()) {
                        SuperColumn spc = new SuperColumn(ByteBuffer.wrap(columnParent.getSuper_column()), KeyspaceServiceImpl.getColumnList(entry.getValue()));
                        ArrayList<SuperColumn> spclist = new ArrayList<SuperColumn>(1);
                        spclist.add(spc);
                        result.put(entry.getKey(), spclist);
                    }
                    return result;
                }
                catch (Exception e) {
                    throw KeyspaceServiceImpl.this.xtrans.translate(e);
                }
            }
        };
        this.operateWithFailover(getCount);
        return (Map)getCount.getResult();
    }

    @Override
    public Map<ByteBuffer, List<CounterSuperColumn>> multigetCounterSuperSlice(final List<ByteBuffer> keys, final ColumnParent columnParent, final SlicePredicate predicate) throws HectorException {
        Operation<Map<ByteBuffer, List<CounterSuperColumn>>> getCount = new Operation<Map<ByteBuffer, List<CounterSuperColumn>>>(OperationType.READ, this.failoverPolicy, this.keyspaceName, this.credentials){

            @Override
            public Map<ByteBuffer, List<CounterSuperColumn>> execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    Map<ByteBuffer, List<ColumnOrSuperColumn>> cfmap = cassandra.multiget_slice(keys, columnParent, predicate, KeyspaceServiceImpl.this.getThriftCl(OperationType.READ));
                    if (!columnParent.isSetSuper_column()) {
                        HashMap<ByteBuffer, List<CounterSuperColumn>> result = new HashMap<ByteBuffer, List<CounterSuperColumn>>();
                        for (Map.Entry<ByteBuffer, List<ColumnOrSuperColumn>> entry : cfmap.entrySet()) {
                            result.put(entry.getKey(), KeyspaceServiceImpl.getCounterSuperColumnList(entry.getValue()));
                        }
                        return result;
                    }
                    HashMap<ByteBuffer, List<CounterSuperColumn>> result = new HashMap<ByteBuffer, List<CounterSuperColumn>>();
                    for (Map.Entry<ByteBuffer, List<ColumnOrSuperColumn>> entry : cfmap.entrySet()) {
                        CounterSuperColumn spc = new CounterSuperColumn(ByteBuffer.wrap(columnParent.getSuper_column()), KeyspaceServiceImpl.getCounterColumnList(entry.getValue()));
                        ArrayList<CounterSuperColumn> spclist = new ArrayList<CounterSuperColumn>(1);
                        spclist.add(spc);
                        result.put(entry.getKey(), spclist);
                    }
                    return result;
                }
                catch (Exception e) {
                    throw KeyspaceServiceImpl.this.xtrans.translate(e);
                }
            }
        };
        this.operateWithFailover(getCount);
        return (Map)getCount.getResult();
    }

    @Override
    public Map<ByteBuffer, List<Column>> getIndexedSlices(final ColumnParent columnParent, final IndexClause indexClause, final SlicePredicate predicate) throws HectorException {
        Operation<Map<ByteBuffer, List<Column>>> op = new Operation<Map<ByteBuffer, List<Column>>>(OperationType.READ, this.failoverPolicy, this.keyspaceName, this.credentials){

            @Override
            public Map<ByteBuffer, List<Column>> execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    List<KeySlice> keySlices = cassandra.get_indexed_slices(columnParent, indexClause, predicate, KeyspaceServiceImpl.this.getThriftCl(OperationType.READ));
                    if (keySlices == null || keySlices.isEmpty()) {
                        return new LinkedHashMap<ByteBuffer, List<Column>>(0);
                    }
                    LinkedHashMap<ByteBuffer, List<Column>> ret = new LinkedHashMap<ByteBuffer, List<Column>>(keySlices.size());
                    for (KeySlice keySlice : keySlices) {
                        ret.put(ByteBuffer.wrap(keySlice.getKey()), KeyspaceServiceImpl.getColumnList(keySlice.getColumns()));
                    }
                    return ret;
                }
                catch (Exception e) {
                    throw KeyspaceServiceImpl.this.xtrans.translate(e);
                }
            }
        };
        this.operateWithFailover(op);
        return (Map)op.getResult();
    }

    @Override
    public void remove(ByteBuffer key, ColumnPath columnPath) {
        this.remove(key, columnPath, this.connectionManager.createClock());
    }

    @Override
    public Map<ByteBuffer, Integer> multigetCount(final List<ByteBuffer> keys, final ColumnParent columnParent, final SlicePredicate slicePredicate) throws HectorException {
        Operation<Map<ByteBuffer, Integer>> op = new Operation<Map<ByteBuffer, Integer>>(OperationType.READ, this.failoverPolicy, this.keyspaceName, this.credentials){

            @Override
            public Map<ByteBuffer, Integer> execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    return cassandra.multiget_count(keys, columnParent, slicePredicate, KeyspaceServiceImpl.this.getThriftCl(OperationType.READ));
                }
                catch (Exception e) {
                    throw KeyspaceServiceImpl.this.xtrans.translate(e);
                }
            }
        };
        this.operateWithFailover(op);
        return (Map)op.getResult();
    }

    @Override
    public void remove(final ByteBuffer key, final ColumnPath columnPath, final long timestamp) throws HectorException {
        Operation<Void> op = new Operation<Void>(OperationType.WRITE, this.failoverPolicy, this.keyspaceName, this.credentials){

            @Override
            public Void execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    cassandra.remove(key, columnPath, timestamp, KeyspaceServiceImpl.this.getThriftCl(OperationType.WRITE));
                    return null;
                }
                catch (Exception e) {
                    throw KeyspaceServiceImpl.this.xtrans.translate(e);
                }
            }
        };
        this.operateWithFailover(op);
    }

    @Override
    public void removeCounter(final ByteBuffer key, final ColumnPath columnPath) throws HectorException {
        Operation<Void> op = new Operation<Void>(OperationType.WRITE, this.failoverPolicy, this.keyspaceName, this.credentials){

            @Override
            public Void execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    cassandra.remove_counter(key, columnPath, KeyspaceServiceImpl.this.getThriftCl(OperationType.WRITE));
                    return null;
                }
                catch (Exception e) {
                    throw KeyspaceServiceImpl.this.xtrans.translate(e);
                }
            }
        };
        this.operateWithFailover(op);
    }

    @Override
    public void removeCounter(String key, ColumnPath columnPath) throws HectorException {
        this.removeCounter(StringSerializer.get().toByteBuffer(key), columnPath);
    }

    @Override
    public void remove(String key, ColumnPath columnPath) throws HectorException {
        this.remove(StringSerializer.get().toByteBuffer(key), columnPath);
    }

    @Override
    public void remove(String key, ColumnPath columnPath, long timestamp) throws HectorException {
        this.remove(StringSerializer.get().toByteBuffer(key), columnPath, timestamp);
    }

    @Override
    public String getName() {
        return this.keyspaceName;
    }

    @Override
    public Column getColumn(final ByteBuffer key, final ColumnPath columnPath) throws HectorException {
        Operation<Column> op = new Operation<Column>(OperationType.READ, this.failoverPolicy, this.keyspaceName, this.credentials){

            @Override
            public Column execute(Cassandra.Client cassandra) throws HectorException {
                ColumnOrSuperColumn cosc;
                try {
                    cosc = cassandra.get(key, columnPath, KeyspaceServiceImpl.this.getThriftCl(OperationType.READ));
                }
                catch (NotFoundException e) {
                    this.setException(KeyspaceServiceImpl.this.xtrans.translate(e));
                    return null;
                }
                catch (Exception e) {
                    throw KeyspaceServiceImpl.this.xtrans.translate(e);
                }
                return cosc == null ? null : cosc.getColumn();
            }
        };
        this.operateWithFailover(op);
        if (op.hasException()) {
            throw op.getException();
        }
        return (Column)op.getResult();
    }

    @Override
    public CounterColumn getCounter(final ByteBuffer key, final ColumnPath columnPath) throws HectorException {
        Operation<CounterColumn> op = new Operation<CounterColumn>(OperationType.READ, this.failoverPolicy, this.keyspaceName, this.credentials){

            @Override
            public CounterColumn execute(Cassandra.Client cassandra) throws HectorException {
                ColumnOrSuperColumn cosc;
                try {
                    cosc = cassandra.get(key, columnPath, KeyspaceServiceImpl.this.getThriftCl(OperationType.READ));
                }
                catch (NotFoundException e) {
                    this.setException(KeyspaceServiceImpl.this.xtrans.translate(e));
                    return null;
                }
                catch (Exception e) {
                    throw KeyspaceServiceImpl.this.xtrans.translate(e);
                }
                return cosc.getCounter_column();
            }
        };
        this.operateWithFailover(op);
        if (op.hasException()) {
            throw op.getException();
        }
        return (CounterColumn)op.getResult();
    }

    @Override
    public CounterColumn getCounter(String key, ColumnPath columnPath) throws HectorException {
        return this.getCounter(StringSerializer.get().toByteBuffer(key), columnPath);
    }

    @Override
    public Column getColumn(String key, ColumnPath columnPath) throws HectorException {
        return this.getColumn(StringSerializer.get().toByteBuffer(key), columnPath);
    }

    @Override
    public HConsistencyLevel getConsistencyLevel(OperationType operationType) {
        return this.consistency.get(operationType);
    }

    private ConsistencyLevel getThriftCl(OperationType operationType) {
        return ThriftConverter.consistencyLevel(this.consistency.get(operationType));
    }

    private static List<Column> getColumnList(List<ColumnOrSuperColumn> columns) {
        ArrayList<Column> list = new ArrayList<Column>(columns.size());
        for (ColumnOrSuperColumn col : columns) {
            list.add(col.getColumn());
        }
        return list;
    }

    private static List<CounterColumn> getCounterColumnList(List<ColumnOrSuperColumn> columns) {
        ArrayList<CounterColumn> list = new ArrayList<CounterColumn>(columns.size());
        for (ColumnOrSuperColumn col : columns) {
            list.add(col.getCounter_column());
        }
        return list;
    }

    private static List<SuperColumn> getSuperColumnList(List<ColumnOrSuperColumn> columns) {
        ArrayList<SuperColumn> list = new ArrayList<SuperColumn>(columns.size());
        for (ColumnOrSuperColumn col : columns) {
            list.add(col.getSuper_column());
        }
        return list;
    }

    private static List<CounterSuperColumn> getCounterSuperColumnList(List<ColumnOrSuperColumn> columns) {
        ArrayList<CounterSuperColumn> list = new ArrayList<CounterSuperColumn>(columns.size());
        for (ColumnOrSuperColumn col : columns) {
            list.add(col.getCounter_super_column());
        }
        return list;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("KeyspaceImpl<");
        b.append(this.keyspaceName);
        b.append(">");
        return b.toString();
    }
}

