/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.service;

import hector.me.prettyprint.cassandra.constants.CFMetaDataDefaults;
import hector.me.prettyprint.cassandra.service.ThriftColumnDef;
import hector.me.prettyprint.cassandra.utils.Assert;
import hector.me.prettyprint.hector.api.ddl.ColumnDefinition;
import hector.me.prettyprint.hector.api.ddl.ColumnFamilyDefinition;
import hector.me.prettyprint.hector.api.ddl.ColumnType;
import hector.me.prettyprint.hector.api.ddl.ComparatorType;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.commons.lang.builder.ToStringBuilder;
import org.apache.cassandra.thrift.commons.lang.builder.ToStringStyle;

public class ThriftCfDef
implements ColumnFamilyDefinition {
    private String keyspace;
    private String name;
    private ColumnType columnType;
    private ComparatorType comparatorType;
    private ComparatorType subComparatorType;
    private String comparatorTypeAlias = "";
    private String subComparatorTypeAlias = "";
    private String comment;
    private double rowCacheSize;
    private int rowCacheSavePeriodInSeconds;
    private double keyCacheSize;
    private double readRepairChance;
    private List<ColumnDefinition> columnMetadata;
    private int gcGraceSeconds;
    private String keyValidationClass;
    private String defaultValidationClass;
    private int id;
    private int maxCompactionThreshold;
    private int minCompactionThreshold;
    private double memtableOperationsInMillions;
    private int memtableThroughputInMb;
    private int memtableFlushAfterMins;
    private int keyCacheSavePeriodInSeconds;
    private boolean replicateOnWrite;
    private String compactionStrategy;
    private Map<String, String> compactionStrategyOptions;
    private Map<String, String> compressionOptions;
    private double mergeShardsChance;
    private String rowCacheProvider;
    private ByteBuffer keyAlias;
    private int rowCacheKeysToSave;

    public ThriftCfDef(CfDef d) {
        Assert.notNull(d, "CfDef is null");
        this.keyspace = d.keyspace;
        this.name = d.name;
        this.columnType = ColumnType.getFromValue(d.column_type);
        this.comparatorType = ComparatorType.getByClassName(d.comparator_type);
        this.subComparatorType = ComparatorType.getByClassName(d.subcomparator_type);
        this.comment = d.comment;
        this.rowCacheSize = d.row_cache_size;
        this.rowCacheSavePeriodInSeconds = d.row_cache_save_period_in_seconds;
        this.keyCacheSize = d.key_cache_size;
        this.keyCacheSavePeriodInSeconds = d.key_cache_save_period_in_seconds;
        this.keyValidationClass = d.key_validation_class;
        this.readRepairChance = d.read_repair_chance;
        this.columnMetadata = ThriftColumnDef.fromThriftList(d.column_metadata);
        this.gcGraceSeconds = d.gc_grace_seconds;
        this.defaultValidationClass = d.default_validation_class;
        this.id = d.id;
        this.minCompactionThreshold = d.min_compaction_threshold == 0 ? 4 : d.min_compaction_threshold;
        this.maxCompactionThreshold = d.max_compaction_threshold == 0 ? 32 : d.max_compaction_threshold;
        this.replicateOnWrite = d.replicate_on_write;
        this.compactionStrategy = d.compaction_strategy;
        this.compactionStrategyOptions = d.compaction_strategy_options;
        this.compressionOptions = d.compression_options;
        this.mergeShardsChance = d.merge_shards_chance;
        this.rowCacheProvider = d.row_cache_provider;
        this.keyAlias = d.key_alias;
        this.rowCacheKeysToSave = d.row_cache_keys_to_save;
    }

    public ThriftCfDef(ColumnFamilyDefinition columnFamilyDefinition) {
        this.keyspace = columnFamilyDefinition.getKeyspaceName();
        this.name = columnFamilyDefinition.getName();
        this.columnType = columnFamilyDefinition.getColumnType();
        this.comparatorType = columnFamilyDefinition.getComparatorType();
        this.subComparatorType = columnFamilyDefinition.getSubComparatorType();
        this.comparatorTypeAlias = columnFamilyDefinition.getComparatorTypeAlias();
        this.subComparatorTypeAlias = columnFamilyDefinition.getSubComparatorTypeAlias();
        this.comment = columnFamilyDefinition.getComment();
        this.rowCacheSize = columnFamilyDefinition.getRowCacheSize();
        this.rowCacheSavePeriodInSeconds = columnFamilyDefinition.getRowCacheSavePeriodInSeconds();
        this.keyCacheSize = columnFamilyDefinition.getKeyCacheSize();
        this.keyCacheSavePeriodInSeconds = columnFamilyDefinition.getKeyCacheSavePeriodInSeconds();
        this.keyValidationClass = columnFamilyDefinition.getKeyValidationClass();
        this.readRepairChance = columnFamilyDefinition.getReadRepairChance();
        this.columnMetadata = columnFamilyDefinition.getColumnMetadata();
        this.gcGraceSeconds = columnFamilyDefinition.getGcGraceSeconds();
        this.defaultValidationClass = columnFamilyDefinition.getDefaultValidationClass();
        this.id = columnFamilyDefinition.getId();
        this.minCompactionThreshold = columnFamilyDefinition.getMinCompactionThreshold() == 0 ? 4 : columnFamilyDefinition.getMinCompactionThreshold();
        this.maxCompactionThreshold = columnFamilyDefinition.getMaxCompactionThreshold() == 0 ? 32 : columnFamilyDefinition.getMaxCompactionThreshold();
        this.memtableFlushAfterMins = columnFamilyDefinition.getMemtableFlushAfterMins() == 0 ? 1440 : columnFamilyDefinition.getMemtableFlushAfterMins();
        this.memtableThroughputInMb = columnFamilyDefinition.getMemtableThroughputInMb() == 0 ? 500 : columnFamilyDefinition.getMemtableThroughputInMb();
        this.memtableOperationsInMillions = columnFamilyDefinition.getMemtableOperationsInMillions() == 0.0 ? CFMetaDataDefaults.DEFAULT_MEMTABLE_OPERATIONS_IN_MILLIONS : columnFamilyDefinition.getMemtableOperationsInMillions();
        this.replicateOnWrite = columnFamilyDefinition.isReplicateOnWrite();
        this.compactionStrategy = columnFamilyDefinition.getCompactionStrategy();
        this.compactionStrategyOptions = columnFamilyDefinition.getCompactionStrategyOptions();
        this.compressionOptions = columnFamilyDefinition.getCompressionOptions();
        this.mergeShardsChance = columnFamilyDefinition.getMergeShardsChance();
        this.rowCacheProvider = columnFamilyDefinition.getRowCacheProvider();
        this.keyAlias = columnFamilyDefinition.getKeyAlias();
        this.rowCacheKeysToSave = columnFamilyDefinition.getRowCacheKeysToSave();
    }

    public ThriftCfDef(String keyspace, String columnFamilyName) {
        this.keyspace = keyspace;
        this.name = columnFamilyName;
        this.columnMetadata = Collections.emptyList();
        this.columnType = ColumnType.STANDARD;
        this.comparatorType = ComparatorType.BYTESTYPE;
        this.readRepairChance = 1.0;
        this.keyCacheSize = 200000.0;
        this.keyCacheSavePeriodInSeconds = 14400;
        this.gcGraceSeconds = 864000;
        this.minCompactionThreshold = 4;
        this.maxCompactionThreshold = 32;
        this.memtableFlushAfterMins = 1440;
        this.memtableThroughputInMb = 500;
        this.memtableOperationsInMillions = CFMetaDataDefaults.DEFAULT_MEMTABLE_OPERATIONS_IN_MILLIONS;
        this.replicateOnWrite = true;
    }

    public ThriftCfDef(String keyspace, String columnFamilyName, ComparatorType comparatorType) {
        this(keyspace, columnFamilyName);
        if (comparatorType != null) {
            this.comparatorType = comparatorType;
        }
    }

    public ThriftCfDef(String keyspace, String columnFamilyName, ComparatorType comparatorType, List<ColumnDefinition> columnMetadata) {
        this(keyspace, columnFamilyName, comparatorType);
        if (columnMetadata != null) {
            this.columnMetadata = columnMetadata;
        }
    }

    public static List<ColumnFamilyDefinition> fromThriftList(List<CfDef> cfDefs) {
        if (cfDefs == null || cfDefs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ColumnFamilyDefinition> l = new ArrayList<ColumnFamilyDefinition>(cfDefs.size());
        for (CfDef d : cfDefs) {
            l.add(new ThriftCfDef(d));
        }
        return l;
    }

    @Override
    public String getKeyspaceName() {
        return this.keyspace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ColumnType getColumnType() {
        return this.columnType;
    }

    @Override
    public ComparatorType getComparatorType() {
        return this.comparatorType;
    }

    @Override
    public ComparatorType getSubComparatorType() {
        return this.subComparatorType;
    }

    @Override
    public String getComparatorTypeAlias() {
        return this.comparatorTypeAlias;
    }

    @Override
    public String getSubComparatorTypeAlias() {
        return this.subComparatorTypeAlias;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public double getRowCacheSize() {
        return this.rowCacheSize;
    }

    @Override
    public int getRowCacheSavePeriodInSeconds() {
        return this.rowCacheSavePeriodInSeconds;
    }

    @Override
    public double getKeyCacheSize() {
        return this.keyCacheSize;
    }

    @Override
    public double getReadRepairChance() {
        return this.readRepairChance;
    }

    @Override
    public List<ColumnDefinition> getColumnMetadata() {
        return this.columnMetadata;
    }

    @Override
    public int getGcGraceSeconds() {
        return this.gcGraceSeconds;
    }

    public static List<CfDef> toThriftList(List<ColumnFamilyDefinition> cfDefs) {
        if (cfDefs == null || cfDefs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CfDef> l = new ArrayList<CfDef>(cfDefs.size());
        for (ColumnFamilyDefinition d : cfDefs) {
            l.add(((ThriftCfDef)d).toThrift());
        }
        return l;
    }

    public CfDef toThrift() {
        CfDef d = new CfDef(this.keyspace, this.name);
        d.setColumn_metadata(ThriftColumnDef.toThriftList(this.columnMetadata));
        d.setColumn_type(this.columnType.getValue());
        d.setComment(this.comment);
        d.setComparator_type(this.comparatorType.getClassName() + this.comparatorTypeAlias);
        d.setDefault_validation_class(this.defaultValidationClass);
        d.setGc_grace_seconds(this.gcGraceSeconds);
        if (this.id != 0) {
            d.setId(this.id);
        }
        d.setKey_cache_size(this.keyCacheSize);
        d.setKey_cache_save_period_in_seconds(this.keyCacheSavePeriodInSeconds);
        d.setKey_validation_class(this.keyValidationClass);
        d.setMax_compaction_threshold(this.maxCompactionThreshold);
        d.setMin_compaction_threshold(this.minCompactionThreshold);
        d.setRead_repair_chance(this.readRepairChance);
        d.setRow_cache_size(this.rowCacheSize);
        d.setReplicate_on_write(this.replicateOnWrite);
        if (this.subComparatorType != null) {
            d.setSubcomparator_type(this.subComparatorType.getClassName() + this.subComparatorTypeAlias);
        }
        d.setCompaction_strategy(this.compactionStrategy);
        d.setCompaction_strategy_options(this.compactionStrategyOptions);
        d.setCompression_options(this.compressionOptions);
        d.setMerge_shards_chance(this.mergeShardsChance);
        d.setRow_cache_provider(this.rowCacheProvider);
        d.setKey_alias(this.keyAlias);
        d.setRow_cache_keys_to_save(this.rowCacheKeysToSave);
        return d;
    }

    @Override
    public String getDefaultValidationClass() {
        return this.defaultValidationClass;
    }

    @Override
    public String getKeyValidationClass() {
        return this.keyValidationClass;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getMaxCompactionThreshold() {
        return this.maxCompactionThreshold;
    }

    @Override
    public int getMinCompactionThreshold() {
        return this.minCompactionThreshold;
    }

    @Override
    public void setColumnType(ColumnType columnType) {
        this.columnType = columnType;
    }

    @Override
    public void setComparatorType(ComparatorType comparatorType) {
        this.comparatorType = comparatorType;
    }

    @Override
    public void setSubComparatorType(ComparatorType subComparatorType) {
        this.subComparatorType = subComparatorType;
    }

    @Override
    public void setComparatorTypeAlias(String alias) {
        this.comparatorTypeAlias = alias;
    }

    @Override
    public void setSubComparatorTypeAlias(String alias) {
        this.subComparatorTypeAlias = alias;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public void setRowCacheSize(double rowCacheSize) {
        this.rowCacheSize = rowCacheSize;
    }

    @Override
    public void setRowCacheSavePeriodInSeconds(int rowCacheSavePeriodInSeconds) {
        this.rowCacheSavePeriodInSeconds = rowCacheSavePeriodInSeconds;
    }

    @Override
    public void setKeyCacheSize(double keyCacheSize) {
        this.keyCacheSize = keyCacheSize;
    }

    @Override
    public void setReadRepairChance(double readRepairChance) {
        this.readRepairChance = readRepairChance;
    }

    public void setColumnMetadata(List<ColumnDefinition> columnMetadata) {
        this.columnMetadata = columnMetadata;
    }

    @Override
    public void addColumnDefinition(ColumnDefinition columnDefinition) {
        this.columnMetadata.add(columnDefinition);
    }

    @Override
    public void setGcGraceSeconds(int gcGraceSeconds) {
        this.gcGraceSeconds = gcGraceSeconds;
    }

    @Override
    public void setDefaultValidationClass(String defaultValidationClass) {
        this.defaultValidationClass = defaultValidationClass;
    }

    @Override
    public void setKeyValidationClass(String keyValidationClass) {
        this.keyValidationClass = keyValidationClass;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public void setMaxCompactionThreshold(int maxCompactionThreshold) {
        this.maxCompactionThreshold = maxCompactionThreshold;
    }

    @Override
    public void setMinCompactionThreshold(int minCompactionThreshold) {
        this.minCompactionThreshold = minCompactionThreshold;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public int getMemtableFlushAfterMins() {
        return this.memtableFlushAfterMins;
    }

    @Override
    public double getMemtableOperationsInMillions() {
        return this.memtableOperationsInMillions;
    }

    @Override
    public int getMemtableThroughputInMb() {
        return this.memtableThroughputInMb;
    }

    @Override
    public int getKeyCacheSavePeriodInSeconds() {
        return this.keyCacheSavePeriodInSeconds;
    }

    @Override
    public void setMemtableOperationsInMillions(double memtableOperationsInMillions) {
        this.memtableOperationsInMillions = memtableOperationsInMillions;
    }

    @Override
    public void setMemtableThroughputInMb(int memtableThroughputInMb) {
        this.memtableThroughputInMb = memtableThroughputInMb;
    }

    @Override
    public void setMemtableFlushAfterMins(int memtableFlushAfterMins) {
        this.memtableFlushAfterMins = memtableFlushAfterMins;
    }

    @Override
    public void setKeyCacheSavePeriodInSeconds(int keyCacheSavePeriodInSeconds) {
        this.keyCacheSavePeriodInSeconds = keyCacheSavePeriodInSeconds;
    }

    @Override
    public boolean isReplicateOnWrite() {
        return this.replicateOnWrite;
    }

    @Override
    public void setReplicateOnWrite(boolean replicateOnWrite) {
        this.replicateOnWrite = replicateOnWrite;
    }

    @Override
    public void setKeyspaceName(String keyspaceName) {
        this.keyspace = keyspaceName;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getCompactionStrategy() {
        return this.compactionStrategy;
    }

    @Override
    public void setCompactionStrategy(String strategy) {
        this.compactionStrategy = strategy;
    }

    @Override
    public Map<String, String> getCompactionStrategyOptions() {
        return this.compactionStrategyOptions;
    }

    @Override
    public void setCompactionStrategyOptions(Map<String, String> compactionStrategyOptions) {
        this.compactionStrategyOptions = compactionStrategyOptions;
    }

    @Override
    public Map<String, String> getCompressionOptions() {
        return this.compressionOptions;
    }

    @Override
    public void setCompressionOptions(Map<String, String> compressionOptions) {
        this.compressionOptions = compressionOptions;
    }

    @Override
    public double getMergeShardsChance() {
        return this.mergeShardsChance;
    }

    @Override
    public void setMergeShardsChance(double mergeShardsChance) {
        this.mergeShardsChance = mergeShardsChance;
    }

    @Override
    public String getRowCacheProvider() {
        return this.rowCacheProvider;
    }

    @Override
    public void setRowCacheProvider(String rowCacheProvider) {
        this.rowCacheProvider = rowCacheProvider;
    }

    @Override
    public ByteBuffer getKeyAlias() {
        return this.keyAlias;
    }

    @Override
    public void setKeyAlias(ByteBuffer keyAlias) {
        this.keyAlias = keyAlias;
    }

    @Override
    public int getRowCacheKeysToSave() {
        return this.rowCacheKeysToSave;
    }

    @Override
    public void setRowCacheKeysToSave(int rowCacheKeysToSave) {
        this.rowCacheKeysToSave = rowCacheKeysToSave;
    }
}

