/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.service;

import hector.me.prettyprint.cassandra.service.AbstractCluster;
import hector.me.prettyprint.cassandra.service.CassandraHostConfigurator;
import hector.me.prettyprint.cassandra.service.FailoverPolicy;
import hector.me.prettyprint.cassandra.service.Operation;
import hector.me.prettyprint.cassandra.service.OperationType;
import hector.me.prettyprint.cassandra.service.ThriftCfDef;
import hector.me.prettyprint.cassandra.service.ThriftKsDef;
import hector.me.prettyprint.hector.api.Cluster;
import hector.me.prettyprint.hector.api.ddl.ColumnFamilyDefinition;
import hector.me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import hector.me.prettyprint.hector.api.exceptions.HectorException;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.TokenRange;

public class ThriftCluster
extends AbstractCluster
implements Cluster {
    public ThriftCluster(String clusterName, CassandraHostConfigurator cassandraHostConfigurator) {
        super(clusterName, cassandraHostConfigurator);
    }

    public ThriftCluster(String clusterName, CassandraHostConfigurator cassandraHostConfigurator, Map<String, String> credentials) {
        super(clusterName, cassandraHostConfigurator, credentials);
    }

    @Override
    public List<TokenRange> describeRing(final String keyspace) throws HectorException {
        Operation<List<TokenRange>> op = new Operation<List<TokenRange>>(OperationType.META_READ, this.getCredentials()){

            @Override
            public List<TokenRange> execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    return cassandra.describe_ring(keyspace);
                }
                catch (Exception e) {
                    throw ThriftCluster.this.xtrans.translate(e);
                }
            }
        };
        this.connectionManager.operateWithFailover(op);
        return (List)op.getResult();
    }

    @Override
    public Map<String, List<String>> describeSchemaVersions() throws HectorException {
        Operation<Map<String, List<String>>> op = new Operation<Map<String, List<String>>>(OperationType.META_READ, this.getCredentials()){

            @Override
            public Map<String, List<String>> execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    return cassandra.describe_schema_versions();
                }
                catch (Exception e) {
                    throw ThriftCluster.this.xtrans.translate(e);
                }
            }
        };
        this.connectionManager.operateWithFailover(op);
        return (Map)op.getResult();
    }

    @Override
    public String updateKeyspace(KeyspaceDefinition ksdef) throws HectorException {
        return this.updateKeyspace(ksdef, false);
    }

    @Override
    public String updateKeyspace(final KeyspaceDefinition ksdef, final boolean waitForSchemaAgreement) throws HectorException {
        Operation<String> op = new Operation<String>(OperationType.META_WRITE, FailoverPolicy.FAIL_FAST, this.getCredentials()){

            @Override
            public String execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    if (waitForSchemaAgreement) {
                        AbstractCluster.waitForSchemaAgreement(cassandra);
                    }
                    String schemaId = cassandra.system_update_keyspace(ThriftCluster.this.toThriftImplementation(ksdef).toThrift());
                    if (waitForSchemaAgreement) {
                        AbstractCluster.waitForSchemaAgreement(cassandra);
                    }
                    return schemaId;
                }
                catch (Exception e) {
                    throw ThriftCluster.this.xtrans.translate(e);
                }
            }
        };
        this.connectionManager.operateWithFailover(op);
        return (String)op.getResult();
    }

    @Override
    public String addColumnFamily(ColumnFamilyDefinition cfdef) throws HectorException {
        return this.addColumnFamily(cfdef, false);
    }

    @Override
    public String addColumnFamily(final ColumnFamilyDefinition cfdef, final boolean waitForSchemaAgreement) throws HectorException {
        Operation<String> op = new Operation<String>(OperationType.META_WRITE, FailoverPolicy.FAIL_FAST, cfdef.getKeyspaceName(), this.getCredentials()){

            @Override
            public String execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    if (waitForSchemaAgreement) {
                        AbstractCluster.waitForSchemaAgreement(cassandra);
                    }
                    String schemaId = cassandra.system_add_column_family(ThriftCluster.this.toThriftImplementation(cfdef).toThrift());
                    if (waitForSchemaAgreement) {
                        AbstractCluster.waitForSchemaAgreement(cassandra);
                    }
                    return schemaId;
                }
                catch (Exception e) {
                    throw ThriftCluster.this.xtrans.translate(e);
                }
            }
        };
        this.connectionManager.operateWithFailover(op);
        return (String)op.getResult();
    }

    @Override
    public String updateColumnFamily(ColumnFamilyDefinition cfdef) throws HectorException {
        return this.updateColumnFamily(cfdef, false);
    }

    @Override
    public String updateColumnFamily(final ColumnFamilyDefinition cfdef, final boolean waitForSchemaAgreement) throws HectorException {
        Operation<String> op = new Operation<String>(OperationType.META_WRITE, FailoverPolicy.FAIL_FAST, cfdef.getKeyspaceName(), this.getCredentials()){

            @Override
            public String execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    if (waitForSchemaAgreement) {
                        AbstractCluster.waitForSchemaAgreement(cassandra);
                    }
                    String schemaId = cassandra.system_update_column_family(ThriftCluster.this.toThriftImplementation(cfdef).toThrift());
                    if (waitForSchemaAgreement) {
                        AbstractCluster.waitForSchemaAgreement(cassandra);
                    }
                    return schemaId;
                }
                catch (Exception e) {
                    throw ThriftCluster.this.xtrans.translate(e);
                }
            }
        };
        this.connectionManager.operateWithFailover(op);
        return (String)op.getResult();
    }

    @Override
    public String addKeyspace(KeyspaceDefinition ksdef) throws HectorException {
        return this.addKeyspace(ksdef, false);
    }

    @Override
    public String addKeyspace(final KeyspaceDefinition ksdef, final boolean waitForSchemaAgreement) throws HectorException {
        Operation<String> op = new Operation<String>(OperationType.META_WRITE, FailoverPolicy.FAIL_FAST, this.getCredentials()){

            @Override
            public String execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    if (waitForSchemaAgreement) {
                        AbstractCluster.waitForSchemaAgreement(cassandra);
                    }
                    String schemaId = cassandra.system_add_keyspace(ThriftCluster.this.toThriftImplementation(ksdef).toThrift());
                    if (waitForSchemaAgreement) {
                        AbstractCluster.waitForSchemaAgreement(cassandra);
                    }
                    return schemaId;
                }
                catch (Exception e) {
                    throw ThriftCluster.this.xtrans.translate(e);
                }
            }
        };
        this.connectionManager.operateWithFailover(op);
        return (String)op.getResult();
    }

    @Override
    public void onStartup() {
        if (this.getConfigurator().getRunAutoDiscoveryAtStartup()) {
            this.connectionManager.doAddNodes();
        }
    }

    private ThriftCfDef toThriftImplementation(ColumnFamilyDefinition cfdef) {
        if (cfdef instanceof ThriftCfDef) {
            return (ThriftCfDef)cfdef;
        }
        return new ThriftCfDef(cfdef);
    }

    private ThriftKsDef toThriftImplementation(KeyspaceDefinition cfdef) {
        if (cfdef instanceof ThriftKsDef) {
            return (ThriftKsDef)cfdef;
        }
        return new ThriftKsDef(cfdef);
    }
}

