/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.service;

import hector.me.prettyprint.cassandra.model.thrift.AbstractThriftClientWrapper;
import hector.me.prettyprint.cassandra.serializers.ByteBufferSerializer;
import hector.me.prettyprint.cassandra.serializers.PrefixedSerializer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.thrift.thriftlib.TException;

public class VirtualKeyspaceCassandraClient
extends AbstractThriftClientWrapper {
    ByteBuffer prefixBytes;
    PrefixedSerializer<ByteBuffer, ByteBuffer> ps;
    ByteBufferSerializer be = new ByteBufferSerializer();

    public VirtualKeyspaceCassandraClient(Cassandra.Client client, ByteBuffer prefixBytes) {
        super(client);
        this.prefixBytes = prefixBytes;
        this.ps = new PrefixedSerializer<ByteBuffer, ByteBuffer>(prefixBytes, this.be, this.be);
    }

    public KeyRange prefixKeyRange(KeyRange unprefixed) {
        KeyRange prefixed = new KeyRange();
        prefixed.count = unprefixed.count;
        prefixed.end_token = unprefixed.end_token;
        prefixed.end_key = this.ps.toByteBuffer(unprefixed.end_key);
        prefixed.start_token = unprefixed.start_token;
        prefixed.start_key = this.ps.toByteBuffer(unprefixed.start_key);
        return prefixed;
    }

    public KeyRange unprefixKeyRange(KeyRange prefixed) {
        KeyRange unprefixed = new KeyRange();
        unprefixed.count = prefixed.count;
        unprefixed.end_token = prefixed.end_token;
        unprefixed.end_key = this.ps.fromByteBuffer(prefixed.end_key);
        unprefixed.start_token = prefixed.start_token;
        unprefixed.start_key = this.ps.fromByteBuffer(prefixed.start_key);
        return unprefixed;
    }

    public KeySlice prefixKeySlice(KeySlice unprefixed) {
        KeySlice prefixed = new KeySlice();
        prefixed.key = this.ps.toByteBuffer(unprefixed.key);
        prefixed.columns = unprefixed.columns;
        return prefixed;
    }

    public KeySlice unprefixKeySlice(KeySlice prefixed) {
        KeySlice unprefixed = new KeySlice();
        unprefixed.key = this.ps.fromByteBuffer(unprefixed.key);
        unprefixed.columns = prefixed.columns;
        return unprefixed;
    }

    public List<KeySlice> prefixKeySlice(List<KeySlice> unprefixed) {
        ArrayList<KeySlice> prefixed = new ArrayList<KeySlice>();
        for (KeySlice ks : unprefixed) {
            prefixed.add(this.prefixKeySlice(ks));
        }
        return prefixed;
    }

    public List<KeySlice> unprefixKeySlice(List<KeySlice> prefixed) {
        ArrayList<KeySlice> unprefixed = new ArrayList<KeySlice>();
        for (KeySlice ks : prefixed) {
            unprefixed.add(this.unprefixKeySlice(ks));
        }
        return unprefixed;
    }

    @Override
    public void add(ByteBuffer key, ColumnParent column_parent, CounterColumn column, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        super.add(this.ps.toByteBuffer(key), column_parent, column, consistency_level);
    }

    @Override
    public void batch_mutate(Map<ByteBuffer, Map<String, List<Mutation>>> mutation_map, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        super.batch_mutate(this.ps.toBytesMap(mutation_map), consistency_level);
    }

    @Override
    public ColumnOrSuperColumn get(ByteBuffer key, ColumnPath column_path, ConsistencyLevel consistency_level) throws InvalidRequestException, NotFoundException, UnavailableException, TimedOutException, TException {
        return super.get(this.ps.toByteBuffer(key), column_path, consistency_level);
    }

    @Override
    public int get_count(ByteBuffer key, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        return super.get_count(this.ps.toByteBuffer(key), column_parent, predicate, consistency_level);
    }

    @Override
    public List<KeySlice> get_indexed_slices(ColumnParent column_parent, IndexClause index_clause, SlicePredicate column_predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        return this.unprefixKeySlice(super.get_indexed_slices(column_parent, index_clause, column_predicate, consistency_level));
    }

    @Override
    public List<KeySlice> get_range_slices(ColumnParent column_parent, SlicePredicate predicate, KeyRange range, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        return this.unprefixKeySlice(super.get_range_slices(column_parent, predicate, range, consistency_level));
    }

    @Override
    public List<ColumnOrSuperColumn> get_slice(ByteBuffer key, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        return super.get_slice(this.ps.toByteBuffer(key), column_parent, predicate, consistency_level);
    }

    @Override
    public void insert(ByteBuffer key, ColumnParent column_parent, Column column, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        super.insert(this.ps.toByteBuffer(key), column_parent, column, consistency_level);
    }

    @Override
    public Map<ByteBuffer, Integer> multiget_count(List<ByteBuffer> keys, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        return this.ps.fromBytesMap(super.multiget_count(this.ps.toBytesList(keys), column_parent, predicate, consistency_level));
    }

    @Override
    public Map<ByteBuffer, List<ColumnOrSuperColumn>> multiget_slice(List<ByteBuffer> keys, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        return this.ps.fromBytesMap(super.multiget_slice(this.ps.toBytesList(keys), column_parent, predicate, consistency_level));
    }

    @Override
    public void remove(ByteBuffer key, ColumnPath column_path, long timestamp, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        super.remove(this.ps.toByteBuffer(key), column_path, timestamp, consistency_level);
    }

    @Override
    public void remove_counter(ByteBuffer key, ColumnPath path, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        super.remove_counter(this.ps.toByteBuffer(key), path, consistency_level);
    }
}

