/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.service;

import hector.me.prettyprint.cassandra.model.ExecutionResult;
import hector.me.prettyprint.cassandra.service.CassandraHost;
import hector.me.prettyprint.cassandra.service.FailoverPolicy;
import hector.me.prettyprint.cassandra.service.Operation;
import hector.me.prettyprint.cassandra.service.VirtualKeyspaceCassandraClient;
import hector.me.prettyprint.hector.api.ConsistencyLevelPolicy;
import hector.me.prettyprint.hector.api.exceptions.HectorException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.cassandra.thrift.Cassandra;

public class VirtualKeyspaceOperation<T>
extends Operation<T> {
    Operation<T> operation;
    ByteBuffer prefixBytes;

    public VirtualKeyspaceOperation(Operation<T> operation, ByteBuffer prefixBytes) {
        super(operation.operationType, operation.failoverPolicy, operation.keyspaceName, operation.credentials);
        this.operation = operation;
        this.prefixBytes = prefixBytes;
    }

    @Override
    public void applyConnectionParams(String keyspace, ConsistencyLevelPolicy consistencyLevelPolicy, FailoverPolicy failoverPolicy, Map<String, String> credentials) {
        this.operation.applyConnectionParams(keyspace, consistencyLevelPolicy, failoverPolicy, credentials);
    }

    @Override
    public void setResult(T executionResult) {
        this.operation.setResult(executionResult);
    }

    @Override
    public T getResult() {
        return this.operation.getResult();
    }

    @Override
    public ExecutionResult<T> getExecutionResult() {
        return this.operation.getExecutionResult();
    }

    @Override
    public void executeAndSetResult(Cassandra.Client cassandra, CassandraHost cassandraHost) throws Exception {
        this.operation.executeAndSetResult(new VirtualKeyspaceCassandraClient(cassandra, this.prefixBytes), cassandraHost);
    }

    @Override
    public void setException(HectorException e) {
        this.operation.setException(e);
    }

    @Override
    public boolean hasException() {
        return this.operation.hasException();
    }

    @Override
    public HectorException getException() {
        return this.operation.getException();
    }

    @Override
    public CassandraHost getCassandraHost() {
        return this.operation.getCassandraHost();
    }

    @Override
    public T execute(Cassandra.Client cassandra) throws Exception {
        return this.operation.execute(new VirtualKeyspaceCassandraClient(cassandra, this.prefixBytes));
    }
}

