/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.service.template;

import hector.me.prettyprint.cassandra.model.HSlicePredicate;
import hector.me.prettyprint.cassandra.model.thrift.ThriftColumnFactory;
import hector.me.prettyprint.cassandra.service.ExceptionsTranslator;
import hector.me.prettyprint.cassandra.service.ExceptionsTranslatorImpl;
import hector.me.prettyprint.cassandra.service.template.AbstractTemplateUpdater;
import hector.me.prettyprint.hector.api.ColumnFactory;
import hector.me.prettyprint.hector.api.ConsistencyLevelPolicy;
import hector.me.prettyprint.hector.api.Keyspace;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.factory.HFactory;
import hector.me.prettyprint.hector.api.mutation.MutationResult;
import hector.me.prettyprint.hector.api.mutation.Mutator;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.thrift.ColumnParent;

public class AbstractColumnFamilyTemplate<K, N> {
    public static final int ALL_COLUMNS_COUNT = Integer.MAX_VALUE;
    public static final Object ALL_COLUMNS_START = null;
    public static final Object ALL_COLUMNS_END = null;
    protected Keyspace keyspace;
    protected String columnFamily;
    protected Serializer<K> keySerializer;
    protected Map<N, Serializer<?>> columnValueSerializers;
    protected ColumnParent columnParent;
    protected HSlicePredicate<N> activeSlicePredicate;
    protected ColumnFactory columnFactory;
    protected ConsistencyLevelPolicy consistencyLevelPolicy;
    protected Serializer<N> topSerializer;
    protected boolean batched;
    protected Long clock;
    protected ExceptionsTranslator exceptionsTranslator;

    public AbstractColumnFamilyTemplate(Keyspace keyspace, String columnFamily, Serializer<K> keySerializer, Serializer<N> topSerializer) {
        this.keyspace = keyspace;
        this.columnFamily = columnFamily;
        this.keySerializer = keySerializer;
        this.topSerializer = topSerializer;
        this.columnValueSerializers = new HashMap();
        this.columnParent = new ColumnParent(columnFamily);
        this.activeSlicePredicate = new HSlicePredicate<N>(topSerializer);
        this.exceptionsTranslator = new ExceptionsTranslatorImpl();
        this.columnFactory = new ThriftColumnFactory();
        this.setCount(100);
    }

    public AbstractColumnFamilyTemplate<K, N> addColumn(N columnName, Serializer<?> valueSerializer) {
        this.columnValueSerializers.put(columnName, valueSerializer);
        this.activeSlicePredicate.addColumnName(columnName);
        return this;
    }

    public Serializer<?> getValueSerializer(N columnName) {
        return this.columnValueSerializers.get(columnName);
    }

    public boolean isBatched() {
        return this.batched;
    }

    public AbstractColumnFamilyTemplate<K, N> setBatched(boolean batched) {
        this.batched = batched;
        return this;
    }

    public String getColumnFamily() {
        return this.columnFamily;
    }

    public Serializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public Serializer<N> getTopSerializer() {
        return this.topSerializer;
    }

    public MutationResult executeBatch(Mutator<K> mutator) {
        MutationResult result = mutator.execute();
        mutator.discardPendingMutations();
        return result;
    }

    public Mutator<K> createMutator() {
        return HFactory.createMutator(this.keyspace, this.keySerializer);
    }

    public long getClock() {
        return this.keyspace.createClock();
    }

    public void setClock(Long clock) {
        this.clock = clock;
    }

    public long getEffectiveClock() {
        return this.keyspace.createClock();
    }

    public void setExceptionsTranslator(ExceptionsTranslator exceptionsTranslator) {
        this.exceptionsTranslator = exceptionsTranslator;
    }

    public void setColumnFactory(ColumnFactory columnFactory) {
        this.columnFactory = columnFactory;
    }

    protected MutationResult executeIfNotBatched(Mutator<K> mutator) {
        return !this.isBatched() ? this.executeBatch(mutator) : null;
    }

    protected MutationResult executeIfNotBatched(AbstractTemplateUpdater<K, N> updater) {
        return !this.isBatched() ? this.executeBatch(updater.getCurrentMutator()) : null;
    }

    public void deleteRow(K key) {
        this.createMutator().addDeletion(key, this.columnFamily, null, this.topSerializer).execute();
    }

    public void deleteRow(Mutator<K> mutator, K key) {
        mutator.addDeletion(key, this.columnFamily, null, this.topSerializer);
        this.executeIfNotBatched(mutator);
    }

    public void deleteColumn(K key, N columnName) {
        this.createMutator().addDeletion(key, this.columnFamily, columnName, this.topSerializer).execute();
    }

    public void deleteColumn(Mutator<K> mutator, K key, N columnName) {
        mutator.addDeletion(key, this.columnFamily, columnName, this.topSerializer);
        this.executeIfNotBatched(mutator);
    }

    public void setCount(int count) {
        this.activeSlicePredicate.setCount(count);
    }
}

