/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.service.template;

import hector.me.prettyprint.cassandra.model.HSuperColumnImpl;
import hector.me.prettyprint.cassandra.serializers.BooleanSerializer;
import hector.me.prettyprint.cassandra.serializers.ByteBufferSerializer;
import hector.me.prettyprint.cassandra.serializers.BytesArraySerializer;
import hector.me.prettyprint.cassandra.serializers.DateSerializer;
import hector.me.prettyprint.cassandra.serializers.DoubleSerializer;
import hector.me.prettyprint.cassandra.serializers.IntegerSerializer;
import hector.me.prettyprint.cassandra.serializers.LongSerializer;
import hector.me.prettyprint.cassandra.serializers.StringSerializer;
import hector.me.prettyprint.cassandra.serializers.TypeInferringSerializer;
import hector.me.prettyprint.cassandra.serializers.UUIDSerializer;
import hector.me.prettyprint.cassandra.service.template.AbstractTemplateUpdater;
import hector.me.prettyprint.cassandra.service.template.SuperCfTemplate;
import hector.me.prettyprint.hector.api.ColumnFactory;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.beans.HColumn;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SuperCfUpdater<K, SN, N>
extends AbstractTemplateUpdater<K, N> {
    private static final Log log = LogFactory.getLog(SuperCfUpdater.class);
    protected SuperCfTemplate<K, SN, N> template;
    private List<SN> sColumnNames;
    private int sColPos;
    private HSuperColumnImpl<SN, N, ?> activeColumn;
    private List<HColumn> subColumns;

    public SuperCfUpdater(SuperCfTemplate<K, SN, N> sTemplate, ColumnFactory columnFactory) {
        super(sTemplate, columnFactory, sTemplate.createMutator());
        this.template = sTemplate;
    }

    public SuperCfUpdater<K, SN, N> addKey(K key) {
        if (this.keys != null && this.keys.size() > 0) {
            this.updateInternal();
        }
        super.addKey(key);
        this.sColumnNames = new ArrayList<SN>();
        this.sColPos = 0;
        return this;
    }

    public SuperCfUpdater<K, SN, N> addSuperColumn(SN sColumnName) {
        if (this.sColumnNames.size() > 0) {
            this.updateInternal();
            ++this.sColPos;
        }
        this.subColumns = new ArrayList<HColumn>();
        this.sColumnNames.add(sColumnName);
        return this;
    }

    public SN getCurrentSuperColumn() {
        return this.sColumnNames.get(this.sColPos);
    }

    void updateInternal() {
        if (!this.subColumns.isEmpty()) {
            log.debug((Object)String.format("Adding column %s for key %s and cols %s", this.getCurrentSuperColumn(), this.getCurrentKey(), this.subColumns));
            HSuperColumnImpl column = new HSuperColumnImpl(this.getCurrentSuperColumn(), this.subColumns, 0L, this.template.getTopSerializer(), this.template.getSubSerializer(), TypeInferringSerializer.get());
            this.mutator.addInsertion(this.getCurrentKey(), this.template.getColumnFamily(), column);
        }
    }

    public void deleteSuperColumn() {
        this.mutator.addSuperDelete(this.getCurrentKey(), this.template.getColumnFamily(), this.getCurrentSuperColumn(), this.template.getTopSerializer());
    }

    public void deleteSubColumn(N columnName) {
        this.mutator.addSubDelete(this.getCurrentKey(), this.template.getColumnFamily(), this.getCurrentSuperColumn(), columnName, this.template.getTopSerializer(), this.template.getSubSerializer());
    }

    public void setString(N subColumnName, String value) {
        this.subColumns.add(this.columnFactory.createColumn(subColumnName, value, this.clock, this.template.getSubSerializer(), StringSerializer.get()));
    }

    public void setUUID(N subColumnName, UUID value) {
        this.subColumns.add(this.columnFactory.createColumn(subColumnName, value, this.clock, this.template.getSubSerializer(), UUIDSerializer.get()));
    }

    public void setLong(N subColumnName, Long value) {
        this.subColumns.add(this.columnFactory.createColumn(subColumnName, value, this.clock, this.template.getSubSerializer(), LongSerializer.get()));
    }

    public void setInteger(N subColumnName, Integer value) {
        this.subColumns.add(this.columnFactory.createColumn(subColumnName, value, this.clock, this.template.getSubSerializer(), IntegerSerializer.get()));
    }

    public void setBoolean(N subColumnName, Boolean value) {
        this.subColumns.add(this.columnFactory.createColumn(subColumnName, value, this.clock, this.template.getSubSerializer(), BooleanSerializer.get()));
    }

    public void setByteArray(N subColumnName, byte[] value) {
        this.subColumns.add(this.columnFactory.createColumn(subColumnName, value, this.clock, this.template.getSubSerializer(), BytesArraySerializer.get()));
    }

    public void setByteBuffer(N subColumnName, ByteBuffer value) {
        this.subColumns.add(this.columnFactory.createColumn(subColumnName, value, this.clock, this.template.getSubSerializer(), ByteBufferSerializer.get()));
    }

    public void setDate(N subColumnName, Date value) {
        this.subColumns.add(this.columnFactory.createColumn(subColumnName, value, this.clock, this.template.getSubSerializer(), DateSerializer.get()));
    }

    public void setDouble(N subColumnName, Double value) {
        this.subColumns.add(this.columnFactory.createColumn(subColumnName, value, this.clock, this.template.getSubSerializer(), DoubleSerializer.get()));
    }

    public <V> void setValue(N subColumnName, V value, Serializer<V> serializer) {
        this.subColumns.add(this.columnFactory.createColumn(subColumnName, value, this.clock, this.template.getSubSerializer(), serializer));
    }
}

