/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.service.template;

import hector.com.google.common.collect.Iterators;
import hector.me.prettyprint.cassandra.model.ExecutingKeyspace;
import hector.me.prettyprint.cassandra.model.ExecutionResult;
import hector.me.prettyprint.cassandra.model.HSlicePredicate;
import hector.me.prettyprint.cassandra.model.thrift.ThriftConverter;
import hector.me.prettyprint.cassandra.service.Operation;
import hector.me.prettyprint.cassandra.service.OperationType;
import hector.me.prettyprint.cassandra.service.template.ColumnFamilyResult;
import hector.me.prettyprint.cassandra.service.template.ColumnFamilyResultWrapper;
import hector.me.prettyprint.cassandra.service.template.ColumnFamilyRowMapper;
import hector.me.prettyprint.cassandra.service.template.ColumnFamilyTemplate;
import hector.me.prettyprint.cassandra.service.template.IndexedSlicesPredicate;
import hector.me.prettyprint.cassandra.service.template.MappedColumnFamilyResult;
import hector.me.prettyprint.cassandra.service.template.MappedColumnFamilyResultWrapper;
import hector.me.prettyprint.hector.api.Keyspace;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.exceptions.HectorException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.KeySlice;

public class ThriftColumnFamilyTemplate<K, N>
extends ColumnFamilyTemplate<K, N> {
    public ThriftColumnFamilyTemplate(Keyspace keyspace, String columnFamily, Serializer<K> keySerializer, Serializer<N> topSerializer) {
        super(keyspace, columnFamily, keySerializer, topSerializer);
    }

    @Override
    public <T> T doExecuteSlice(K key, HSlicePredicate<N> predicate, ColumnFamilyRowMapper<K, N, T> mapper) {
        return mapper.mapRow(this.doExecuteSlice(key, predicate));
    }

    @Override
    public ColumnFamilyResult<K, N> doExecuteSlice(K key, HSlicePredicate<N> workingSlicePredicate) {
        return new ColumnFamilyResultWrapper(this.keySerializer, this.topSerializer, this.sliceInternal(key, workingSlicePredicate));
    }

    @Override
    public ColumnFamilyResult<K, N> doExecuteMultigetSlice(Iterable<K> keys, HSlicePredicate<N> workingSlicePredicate) {
        return new ColumnFamilyResultWrapper(this.keySerializer, this.topSerializer, this.multigetSliceInternal(keys, workingSlicePredicate));
    }

    @Override
    public <V> MappedColumnFamilyResult<K, N, V> doExecuteMultigetSlice(Iterable<K> keys, HSlicePredicate<N> workingSlicePredicate, ColumnFamilyRowMapper<K, N, V> mapper) {
        return new MappedColumnFamilyResultWrapper(this.keySerializer, this.topSerializer, this.multigetSliceInternal(keys, workingSlicePredicate), mapper);
    }

    @Override
    protected <V> ColumnFamilyResult<K, N> doExecuteIndexedSlices(IndexedSlicesPredicate<K, N, V> predicate) {
        return new ColumnFamilyResultWrapper(this.keySerializer, this.topSerializer, this.indexedSlicesInternal(predicate, this.activeSlicePredicate));
    }

    @Override
    protected <V> ColumnFamilyResult<K, N> doExecuteIndexedSlices(IndexedSlicesPredicate<K, N, V> predicate, HSlicePredicate<N> slicePredicate) {
        return new ColumnFamilyResultWrapper(this.keySerializer, this.topSerializer, this.indexedSlicesInternal(predicate, slicePredicate));
    }

    @Override
    protected <R, V> MappedColumnFamilyResult<K, N, R> doExecuteIndexedSlices(IndexedSlicesPredicate<K, N, V> predicate, ColumnFamilyRowMapper<K, N, R> mapper) {
        return new MappedColumnFamilyResultWrapper(this.keySerializer, this.topSerializer, this.indexedSlicesInternal(predicate, this.activeSlicePredicate), mapper);
    }

    @Override
    protected <R, V> MappedColumnFamilyResult<K, N, R> doExecuteIndexedSlices(IndexedSlicesPredicate<K, N, V> predicate, HSlicePredicate<N> slicePredicate, ColumnFamilyRowMapper<K, N, R> mapper) {
        return new MappedColumnFamilyResultWrapper(this.keySerializer, this.topSerializer, this.indexedSlicesInternal(predicate, slicePredicate), mapper);
    }

    private ExecutionResult<Map<ByteBuffer, List<ColumnOrSuperColumn>>> sliceInternal(final K key, final HSlicePredicate<N> workingSlicePredicate) {
        return ((ExecutingKeyspace)this.keyspace).doExecuteOperation(new Operation<Map<ByteBuffer, List<ColumnOrSuperColumn>>>(OperationType.READ){

            @Override
            public Map<ByteBuffer, List<ColumnOrSuperColumn>> execute(Cassandra.Client cassandra) throws HectorException {
                LinkedHashMap<ByteBuffer, List<ColumnOrSuperColumn>> cosc = new LinkedHashMap<ByteBuffer, List<ColumnOrSuperColumn>>();
                try {
                    ByteBuffer sKey = ThriftColumnFamilyTemplate.this.keySerializer.toByteBuffer(key);
                    cosc.put(sKey, cassandra.get_slice(sKey, ThriftColumnFamilyTemplate.this.columnParent, workingSlicePredicate.toThrift(), ThriftConverter.consistencyLevel(this.consistencyLevelPolicy.get(this.operationType, ThriftColumnFamilyTemplate.this.columnFamily))));
                }
                catch (Exception e) {
                    throw ThriftColumnFamilyTemplate.this.exceptionsTranslator.translate(e);
                }
                return cosc;
            }
        });
    }

    private ExecutionResult<Map<ByteBuffer, List<ColumnOrSuperColumn>>> multigetSliceInternal(final Iterable<K> keys, final HSlicePredicate<N> workingSlicePredicate) {
        return ((ExecutingKeyspace)this.keyspace).doExecuteOperation(new Operation<Map<ByteBuffer, List<ColumnOrSuperColumn>>>(OperationType.READ){

            @Override
            public Map<ByteBuffer, List<ColumnOrSuperColumn>> execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    ArrayList keyList = new ArrayList();
                    Iterators.addAll(keyList, keys.iterator());
                    return cassandra.multiget_slice(ThriftColumnFamilyTemplate.this.keySerializer.toBytesList(keyList), ThriftColumnFamilyTemplate.this.columnParent, workingSlicePredicate == null ? ThriftColumnFamilyTemplate.this.activeSlicePredicate.setColumnNames(ThriftColumnFamilyTemplate.this.columnValueSerializers.keySet()).toThrift() : workingSlicePredicate.toThrift(), ThriftConverter.consistencyLevel(this.consistencyLevelPolicy.get(this.operationType, ThriftColumnFamilyTemplate.this.columnFamily)));
                }
                catch (Exception e) {
                    throw ThriftColumnFamilyTemplate.this.exceptionsTranslator.translate(e);
                }
            }
        });
    }

    private <V> ExecutionResult<Map<ByteBuffer, List<ColumnOrSuperColumn>>> indexedSlicesInternal(final IndexedSlicesPredicate<K, N, V> predicate, final HSlicePredicate<N> workingSlicePredicate) {
        return ((ExecutingKeyspace)this.keyspace).doExecuteOperation(new Operation<Map<ByteBuffer, List<ColumnOrSuperColumn>>>(OperationType.READ){

            @Override
            public Map<ByteBuffer, List<ColumnOrSuperColumn>> execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    List<KeySlice> keySlices = cassandra.get_indexed_slices(ThriftColumnFamilyTemplate.this.columnParent, predicate.toThrift(), workingSlicePredicate.toThrift(), ThriftConverter.consistencyLevel(this.consistencyLevelPolicy.get(this.operationType, ThriftColumnFamilyTemplate.this.columnFamily)));
                    if (keySlices == null || keySlices.isEmpty()) {
                        return new LinkedHashMap<ByteBuffer, List<ColumnOrSuperColumn>>(0);
                    }
                    LinkedHashMap<ByteBuffer, List<ColumnOrSuperColumn>> ret = new LinkedHashMap<ByteBuffer, List<ColumnOrSuperColumn>>(keySlices.size());
                    for (KeySlice keySlice : keySlices) {
                        ret.put(ByteBuffer.wrap(keySlice.getKey()), keySlice.getColumns());
                    }
                    return ret;
                }
                catch (Exception e) {
                    throw ThriftColumnFamilyTemplate.this.exceptionsTranslator.translate(e);
                }
            }
        });
    }
}

