/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.hector.api.factory;

import hector.me.prettyprint.cassandra.model.ExecutingKeyspace;
import hector.me.prettyprint.cassandra.model.ExecutingVirtualKeyspace;
import hector.me.prettyprint.cassandra.model.HColumnImpl;
import hector.me.prettyprint.cassandra.model.HCounterColumnImpl;
import hector.me.prettyprint.cassandra.model.HCounterSuperColumnImpl;
import hector.me.prettyprint.cassandra.model.HSuperColumnImpl;
import hector.me.prettyprint.cassandra.model.IndexedSlicesQuery;
import hector.me.prettyprint.cassandra.model.MutatorImpl;
import hector.me.prettyprint.cassandra.model.QuorumAllConsistencyLevelPolicy;
import hector.me.prettyprint.cassandra.model.thrift.ThriftColumnQuery;
import hector.me.prettyprint.cassandra.model.thrift.ThriftCountQuery;
import hector.me.prettyprint.cassandra.model.thrift.ThriftCounterColumnQuery;
import hector.me.prettyprint.cassandra.model.thrift.ThriftMultigetSliceCounterQuery;
import hector.me.prettyprint.cassandra.model.thrift.ThriftMultigetSliceQuery;
import hector.me.prettyprint.cassandra.model.thrift.ThriftMultigetSubSliceQuery;
import hector.me.prettyprint.cassandra.model.thrift.ThriftMultigetSuperSliceCounterQuery;
import hector.me.prettyprint.cassandra.model.thrift.ThriftMultigetSuperSliceQuery;
import hector.me.prettyprint.cassandra.model.thrift.ThriftRangeSlicesCounterQuery;
import hector.me.prettyprint.cassandra.model.thrift.ThriftRangeSlicesQuery;
import hector.me.prettyprint.cassandra.model.thrift.ThriftRangeSubSlicesCounterQuery;
import hector.me.prettyprint.cassandra.model.thrift.ThriftRangeSubSlicesQuery;
import hector.me.prettyprint.cassandra.model.thrift.ThriftRangeSuperSlicesCounterQuery;
import hector.me.prettyprint.cassandra.model.thrift.ThriftRangeSuperSlicesQuery;
import hector.me.prettyprint.cassandra.model.thrift.ThriftSliceCounterQuery;
import hector.me.prettyprint.cassandra.model.thrift.ThriftSliceQuery;
import hector.me.prettyprint.cassandra.model.thrift.ThriftSubColumnQuery;
import hector.me.prettyprint.cassandra.model.thrift.ThriftSubCountQuery;
import hector.me.prettyprint.cassandra.model.thrift.ThriftSubSliceCounterQuery;
import hector.me.prettyprint.cassandra.model.thrift.ThriftSubSliceQuery;
import hector.me.prettyprint.cassandra.model.thrift.ThriftSuperColumnQuery;
import hector.me.prettyprint.cassandra.model.thrift.ThriftSuperCountQuery;
import hector.me.prettyprint.cassandra.model.thrift.ThriftSuperSliceCounterQuery;
import hector.me.prettyprint.cassandra.model.thrift.ThriftSuperSliceQuery;
import hector.me.prettyprint.cassandra.serializers.SerializerTypeInferer;
import hector.me.prettyprint.cassandra.serializers.StringSerializer;
import hector.me.prettyprint.cassandra.service.BatchSizeHint;
import hector.me.prettyprint.cassandra.service.CassandraHostConfigurator;
import hector.me.prettyprint.cassandra.service.FailoverPolicy;
import hector.me.prettyprint.cassandra.service.ThriftCfDef;
import hector.me.prettyprint.cassandra.service.ThriftCluster;
import hector.me.prettyprint.cassandra.service.ThriftKsDef;
import hector.me.prettyprint.cassandra.service.clock.MicrosecondsClockResolution;
import hector.me.prettyprint.cassandra.service.clock.MicrosecondsSyncClockResolution;
import hector.me.prettyprint.cassandra.service.clock.MillisecondsClockResolution;
import hector.me.prettyprint.cassandra.service.clock.SecondsClockResolution;
import hector.me.prettyprint.hector.api.ClockResolution;
import hector.me.prettyprint.hector.api.Cluster;
import hector.me.prettyprint.hector.api.ConsistencyLevelPolicy;
import hector.me.prettyprint.hector.api.Keyspace;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.beans.HColumn;
import hector.me.prettyprint.hector.api.beans.HCounterColumn;
import hector.me.prettyprint.hector.api.beans.HCounterSuperColumn;
import hector.me.prettyprint.hector.api.beans.HSuperColumn;
import hector.me.prettyprint.hector.api.ddl.ColumnDefinition;
import hector.me.prettyprint.hector.api.ddl.ColumnFamilyDefinition;
import hector.me.prettyprint.hector.api.ddl.ComparatorType;
import hector.me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import hector.me.prettyprint.hector.api.mutation.Mutator;
import hector.me.prettyprint.hector.api.query.ColumnQuery;
import hector.me.prettyprint.hector.api.query.CountQuery;
import hector.me.prettyprint.hector.api.query.CounterQuery;
import hector.me.prettyprint.hector.api.query.MultigetSliceCounterQuery;
import hector.me.prettyprint.hector.api.query.MultigetSliceQuery;
import hector.me.prettyprint.hector.api.query.MultigetSubSliceQuery;
import hector.me.prettyprint.hector.api.query.MultigetSuperSliceCounterQuery;
import hector.me.prettyprint.hector.api.query.MultigetSuperSliceQuery;
import hector.me.prettyprint.hector.api.query.RangeSlicesCounterQuery;
import hector.me.prettyprint.hector.api.query.RangeSlicesQuery;
import hector.me.prettyprint.hector.api.query.RangeSubSlicesCounterQuery;
import hector.me.prettyprint.hector.api.query.RangeSubSlicesQuery;
import hector.me.prettyprint.hector.api.query.RangeSuperSlicesCounterQuery;
import hector.me.prettyprint.hector.api.query.RangeSuperSlicesQuery;
import hector.me.prettyprint.hector.api.query.SliceCounterQuery;
import hector.me.prettyprint.hector.api.query.SliceQuery;
import hector.me.prettyprint.hector.api.query.SubColumnQuery;
import hector.me.prettyprint.hector.api.query.SubCountQuery;
import hector.me.prettyprint.hector.api.query.SubSliceCounterQuery;
import hector.me.prettyprint.hector.api.query.SubSliceQuery;
import hector.me.prettyprint.hector.api.query.SuperColumnQuery;
import hector.me.prettyprint.hector.api.query.SuperCountQuery;
import hector.me.prettyprint.hector.api.query.SuperSliceCounterQuery;
import hector.me.prettyprint.hector.api.query.SuperSliceQuery;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class HFactory {
    private static final Map<String, Cluster> clusters = new HashMap<String, Cluster>();
    private static final ConsistencyLevelPolicy DEFAULT_CONSISTENCY_LEVEL_POLICY = new QuorumAllConsistencyLevelPolicy();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cluster getCluster(String clusterName) {
        Map<String, Cluster> map = clusters;
        synchronized (map) {
            return clusters.get(clusterName);
        }
    }

    public static Cluster getOrCreateCluster(String clusterName, String hostIp) {
        return HFactory.getOrCreateCluster(clusterName, new CassandraHostConfigurator(hostIp));
    }

    public static Cluster getOrCreateCluster(String clusterName, CassandraHostConfigurator cassandraHostConfigurator) {
        return HFactory.createCluster(clusterName, cassandraHostConfigurator, null);
    }

    public static Cluster getOrCreateCluster(String clusterName, CassandraHostConfigurator cassandraHostConfigurator, Map<String, String> credentials) {
        return HFactory.createCluster(clusterName, cassandraHostConfigurator, credentials);
    }

    public static Cluster createCluster(String clusterName, CassandraHostConfigurator cassandraHostConfigurator) {
        return HFactory.createCluster(clusterName, cassandraHostConfigurator, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cluster createCluster(String clusterName, CassandraHostConfigurator cassandraHostConfigurator, Map<String, String> credentials) {
        Map<String, Cluster> map = clusters;
        synchronized (map) {
            Cluster cluster = clusters.get(clusterName);
            if (cluster == null) {
                cluster = new ThriftCluster(clusterName, cassandraHostConfigurator, credentials);
                clusters.put(clusterName, cluster);
                cluster.onStartup();
            }
            return cluster;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownCluster(Cluster cluster) {
        Map<String, Cluster> map = clusters;
        synchronized (map) {
            String clusterName = cluster.getName();
            if (clusters.get(clusterName) != null) {
                cluster.getConnectionManager().shutdown();
                clusters.remove(clusterName);
            }
        }
    }

    public static Keyspace createKeyspace(String keyspace, Cluster cluster) {
        return HFactory.createKeyspace(keyspace, cluster, HFactory.createDefaultConsistencyLevelPolicy(), FailoverPolicy.ON_FAIL_TRY_ALL_AVAILABLE);
    }

    public static Keyspace createKeyspace(String keyspace, Cluster cluster, ConsistencyLevelPolicy consistencyLevelPolicy) {
        return HFactory.createKeyspace(keyspace, cluster, consistencyLevelPolicy, FailoverPolicy.ON_FAIL_TRY_ALL_AVAILABLE);
    }

    public static Keyspace createKeyspace(String keyspace, Cluster cluster, ConsistencyLevelPolicy consistencyLevelPolicy, FailoverPolicy failoverPolicy) {
        return new ExecutingKeyspace(keyspace, cluster.getConnectionManager(), consistencyLevelPolicy, failoverPolicy, cluster.getCredentials());
    }

    public static Keyspace createKeyspace(String keyspace, Cluster cluster, ConsistencyLevelPolicy consistencyLevelPolicy, FailoverPolicy failoverPolicy, Map<String, String> credentials) {
        return new ExecutingKeyspace(keyspace, cluster.getConnectionManager(), consistencyLevelPolicy, failoverPolicy, credentials);
    }

    public static <E> Keyspace createVirtualKeyspace(String keyspace, E keyPrefix, Serializer<E> keyPrefixSerializer, Cluster cluster) {
        return HFactory.createVirtualKeyspace(keyspace, keyPrefix, keyPrefixSerializer, cluster, HFactory.createDefaultConsistencyLevelPolicy(), FailoverPolicy.ON_FAIL_TRY_ALL_AVAILABLE);
    }

    public static <E> Keyspace createVirtualKeyspace(String keyspace, E keyPrefix, Serializer<E> keyPrefixSerializer, Cluster cluster, ConsistencyLevelPolicy consistencyLevelPolicy) {
        return HFactory.createVirtualKeyspace(keyspace, keyPrefix, keyPrefixSerializer, cluster, consistencyLevelPolicy, FailoverPolicy.ON_FAIL_TRY_ALL_AVAILABLE);
    }

    public static <E> Keyspace createVirtualKeyspace(String keyspace, E keyPrefix, Serializer<E> keyPrefixSerializer, Cluster cluster, ConsistencyLevelPolicy consistencyLevelPolicy, FailoverPolicy failoverPolicy) {
        return new ExecutingVirtualKeyspace<E>(keyspace, keyPrefix, keyPrefixSerializer, cluster.getConnectionManager(), consistencyLevelPolicy, failoverPolicy, cluster.getCredentials());
    }

    public static <E> Keyspace createVirtualKeyspace(String keyspace, E keyPrefix, Serializer<E> keyPrefixSerializer, Cluster cluster, ConsistencyLevelPolicy consistencyLevelPolicy, FailoverPolicy failoverPolicy, Map<String, String> credentials) {
        return new ExecutingVirtualKeyspace<E>(keyspace, keyPrefix, keyPrefixSerializer, cluster.getConnectionManager(), consistencyLevelPolicy, failoverPolicy, credentials);
    }

    public static ConsistencyLevelPolicy createDefaultConsistencyLevelPolicy() {
        return DEFAULT_CONSISTENCY_LEVEL_POLICY;
    }

    public static <K, N, V> Mutator<K> createMutator(Keyspace keyspace, Serializer<K> keySerializer) {
        return new MutatorImpl<K>(keyspace, keySerializer);
    }

    public static <K, N, V> Mutator<K> createMutator(Keyspace keyspace, Serializer<K> keySerializer, BatchSizeHint sizeHint) {
        return new MutatorImpl<K>(keyspace, keySerializer, sizeHint);
    }

    public static <K, N, V> ColumnQuery<K, N, V> createColumnQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        return new ThriftColumnQuery<K, N, V>(keyspace, keySerializer, nameSerializer, valueSerializer);
    }

    public static <K, N> CounterQuery<K, N> createCounterColumnQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<N> nameSerializer) {
        return new ThriftCounterColumnQuery<K, N>(keyspace, keySerializer, nameSerializer);
    }

    public static <K, N> CountQuery<K, N> createCountQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<N> nameSerializer) {
        return new ThriftCountQuery<K, N>(keyspace, keySerializer, nameSerializer);
    }

    public static <K, SN> SuperCountQuery<K, SN> createSuperCountQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<SN> superNameSerializer) {
        return new ThriftSuperCountQuery<K, SN>(keyspace, keySerializer, superNameSerializer);
    }

    public static <K, SN, N> SubCountQuery<K, SN, N> createSubCountQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<SN> superNameSerializer, Serializer<N> nameSerializer) {
        return new ThriftSubCountQuery<K, SN, N>(keyspace, keySerializer, superNameSerializer, nameSerializer);
    }

    public static ColumnQuery<String, String, String> createStringColumnQuery(Keyspace keyspace) {
        StringSerializer se = StringSerializer.get();
        return HFactory.createColumnQuery(keyspace, se, se, se);
    }

    public static <K, SN, N, V> SuperColumnQuery<K, SN, N, V> createSuperColumnQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        return new ThriftSuperColumnQuery<K, SN, N, V>(keyspace, keySerializer, sNameSerializer, nameSerializer, valueSerializer);
    }

    public static <K, N, V> MultigetSliceQuery<K, N, V> createMultigetSliceQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        return new ThriftMultigetSliceQuery<K, N, V>(keyspace, keySerializer, nameSerializer, valueSerializer);
    }

    public static <K, N> MultigetSliceCounterQuery<K, N> createMultigetSliceCounterQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<N> nameSerializer) {
        return new ThriftMultigetSliceCounterQuery<K, N>(keyspace, keySerializer, nameSerializer);
    }

    public static <K, SN, N> SuperSliceCounterQuery<K, SN, N> createSuperSliceCounterQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer) {
        return new ThriftSuperSliceCounterQuery<K, SN, N>(keyspace, keySerializer, sNameSerializer, nameSerializer);
    }

    public static <K, SN, N, V> SubColumnQuery<K, SN, N, V> createSubColumnQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        return new ThriftSubColumnQuery<K, SN, N, V>(keyspace, keySerializer, sNameSerializer, nameSerializer, valueSerializer);
    }

    public static <K, SN, N, V> MultigetSuperSliceQuery<K, SN, N, V> createMultigetSuperSliceQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        return new ThriftMultigetSuperSliceQuery<K, SN, N, V>(keyspace, keySerializer, sNameSerializer, nameSerializer, valueSerializer);
    }

    public static <K, SN, N> MultigetSuperSliceCounterQuery<K, SN, N> createMultigetSuperSliceCounterQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer) {
        return new ThriftMultigetSuperSliceCounterQuery<K, SN, N>(keyspace, keySerializer, sNameSerializer, nameSerializer);
    }

    public static <K, SN, N, V> MultigetSubSliceQuery<K, SN, N, V> createMultigetSubSliceQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        return new ThriftMultigetSubSliceQuery<K, SN, N, V>(keyspace, keySerializer, sNameSerializer, nameSerializer, valueSerializer);
    }

    public static <K, N, V> RangeSlicesQuery<K, N, V> createRangeSlicesQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        return new ThriftRangeSlicesQuery<K, N, V>(keyspace, keySerializer, nameSerializer, valueSerializer);
    }

    public static <K, N> RangeSlicesCounterQuery<K, N> createRangeSlicesCounterQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<N> nameSerializer) {
        return new ThriftRangeSlicesCounterQuery<K, N>(keyspace, keySerializer, nameSerializer);
    }

    public static <K, SN, N, V> RangeSuperSlicesQuery<K, SN, N, V> createRangeSuperSlicesQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        return new ThriftRangeSuperSlicesQuery<K, SN, N, V>(keyspace, keySerializer, sNameSerializer, nameSerializer, valueSerializer);
    }

    public static <K, SN, N> RangeSuperSlicesCounterQuery<K, SN, N> createRangeSuperSlicesCounterQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer) {
        return new ThriftRangeSuperSlicesCounterQuery<K, SN, N>(keyspace, keySerializer, sNameSerializer, nameSerializer);
    }

    public static <K, N, V> IndexedSlicesQuery<K, N, V> createIndexedSlicesQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        return new IndexedSlicesQuery<K, N, V>(keyspace, keySerializer, nameSerializer, valueSerializer);
    }

    public static <K, SN, N, V> RangeSubSlicesQuery<K, SN, N, V> createRangeSubSlicesQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        return new ThriftRangeSubSlicesQuery<K, SN, N, V>(keyspace, keySerializer, sNameSerializer, nameSerializer, valueSerializer);
    }

    public static <K, SN, N> RangeSubSlicesCounterQuery<K, SN, N> createRangeSubSlicesCounterQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer) {
        return new ThriftRangeSubSlicesCounterQuery<K, SN, N>(keyspace, keySerializer, sNameSerializer, nameSerializer);
    }

    public static <K, N, V> SliceQuery<K, N, V> createSliceQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        return new ThriftSliceQuery<K, N, V>(keyspace, keySerializer, nameSerializer, valueSerializer);
    }

    public static <K, N> SliceCounterQuery<K, N> createCounterSliceQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<N> nameSerializer) {
        return new ThriftSliceCounterQuery<K, N>(keyspace, keySerializer, nameSerializer);
    }

    public static <K, SN, N, V> SubSliceQuery<K, SN, N, V> createSubSliceQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        return new ThriftSubSliceQuery<K, SN, N, V>(keyspace, keySerializer, sNameSerializer, nameSerializer, valueSerializer);
    }

    public static <K, SN, N> SubSliceCounterQuery<K, SN, N> createSubSliceCounterQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer) {
        return new ThriftSubSliceCounterQuery<K, SN, N>(keyspace, keySerializer, sNameSerializer, nameSerializer);
    }

    public static <K, SN, N, V> SuperSliceQuery<K, SN, N, V> createSuperSliceQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        return new ThriftSuperSliceQuery<K, SN, N, V>(keyspace, keySerializer, sNameSerializer, nameSerializer, valueSerializer);
    }

    public static <SN, N, V> HSuperColumn<SN, N, V> createSuperColumn(SN name, List<HColumn<N, V>> columns, Serializer<SN> superNameSerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        return new HSuperColumnImpl<SN, N, V>(name, columns, HFactory.createClock(), superNameSerializer, nameSerializer, valueSerializer);
    }

    public static <SN, N, V> HSuperColumn<SN, N, V> createSuperColumn(SN name, List<HColumn<N, V>> columns, long clock, Serializer<SN> superNameSerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        return new HSuperColumnImpl<SN, N, V>(name, columns, clock, superNameSerializer, nameSerializer, valueSerializer);
    }

    public static <SN, N> HCounterSuperColumn<SN, N> createCounterSuperColumn(SN name, List<HCounterColumn<N>> columns, Serializer<SN> superNameSerializer, Serializer<N> nameSerializer) {
        return new HCounterSuperColumnImpl<SN, N>(name, columns, superNameSerializer, nameSerializer);
    }

    public static <N, V> HColumn<N, V> createColumn(N name, V value, long clock, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        return new HColumnImpl<N, V>(name, value, clock, nameSerializer, valueSerializer);
    }

    public static <N, V> HColumn<N, V> createColumn(N name, V value, long clock) {
        return new HColumnImpl<N, V>(name, value, clock, SerializerTypeInferer.getSerializer(name.getClass()), SerializerTypeInferer.getSerializer(value.getClass()));
    }

    public static <N, V> HColumn<N, V> createColumn(N name, V value) {
        return HFactory.createColumn(name, value, HFactory.createClock());
    }

    public static <N, V> HColumn<N, V> createColumn(N name, V value, long clock, int ttl, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        return new HColumnImpl<N, V>(name, value, clock, ttl, nameSerializer, valueSerializer);
    }

    public static <N, V> HColumn<N, V> createColumn(N name, V value, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        return new HColumnImpl<N, V>(name, value, HFactory.createClock(), nameSerializer, valueSerializer);
    }

    public static <N, V> HColumn<N, V> createColumn(N name, V value, int ttl, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        return new HColumnImpl<N, V>(name, value, HFactory.createClock(), ttl, nameSerializer, valueSerializer);
    }

    public static HColumn<String, String> createStringColumn(String name, String value) {
        StringSerializer se = StringSerializer.get();
        return HFactory.createColumn(name, value, se, se);
    }

    public static <N> HCounterColumn<N> createCounterColumn(N name, long value, Serializer<N> nameSerializer) {
        return new HCounterColumnImpl<N>(name, value, nameSerializer);
    }

    public static HCounterColumn<String> createCounterColumn(String name, long value) {
        StringSerializer se = StringSerializer.get();
        return HFactory.createCounterColumn(name, value, se);
    }

    public static long createClock() {
        return CassandraHostConfigurator.DEF_CLOCK_RESOLUTION.createClock();
    }

    public static KeyspaceDefinition createKeyspaceDefinition(String keyspace) {
        return new ThriftKsDef(keyspace);
    }

    public static KeyspaceDefinition createKeyspaceDefinition(String keyspaceName, String strategyClass, int replicationFactor, List<ColumnFamilyDefinition> cfDefs) {
        return new ThriftKsDef(keyspaceName, strategyClass, replicationFactor, cfDefs);
    }

    public static ColumnFamilyDefinition createColumnFamilyDefinition(String keyspace, String cfName) {
        return new ThriftCfDef(keyspace, cfName);
    }

    public static ColumnFamilyDefinition createColumnFamilyDefinition(String keyspace, String cfName, ComparatorType comparatorType) {
        return new ThriftCfDef(keyspace, cfName, comparatorType);
    }

    public static ColumnFamilyDefinition createColumnFamilyDefinition(String keyspace, String cfName, ComparatorType comparatorType, List<ColumnDefinition> columnMetadata) {
        return new ThriftCfDef(keyspace, cfName, comparatorType, columnMetadata);
    }

    public static ClockResolution createClockResolution(String clockResolutionName) {
        if (clockResolutionName.equals("SECONDS")) {
            return new SecondsClockResolution();
        }
        if (clockResolutionName.equals("MILLISECONDS")) {
            return new MillisecondsClockResolution();
        }
        if (clockResolutionName.equals("MICROSECONDS")) {
            return new MicrosecondsClockResolution();
        }
        if (clockResolutionName.equals("MICROSECONDS_SYNC")) {
            return new MicrosecondsSyncClockResolution();
        }
        throw new RuntimeException(String.format("Unsupported clock resolution: %s", clockResolutionName));
    }
}

