/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift.thriftlib.server;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.thrift.thriftlib.server.TNonblockingServer;
import org.apache.cassandra.thrift.thriftlib.transport.TNonblockingServerTransport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class THsHaServer
extends TNonblockingServer {
    private static final Log LOGGER = LogFactory.getLog(THsHaServer.class);
    private ExecutorService invoker;

    public THsHaServer(Args args) {
        super(args);
        this.invoker = args.executorService == null ? THsHaServer.createInvokerPool(args) : args.executorService;
    }

    @Override
    public void serve() {
        if (!this.startListening()) {
            return;
        }
        if (!this.startSelectorThread()) {
            return;
        }
        this.setServing(true);
        this.joinSelector();
        this.gracefullyShutdownInvokerPool();
        this.setServing(false);
        this.stopListening();
    }

    protected static ExecutorService createInvokerPool(Args options) {
        int workerThreads = options.workerThreads;
        int stopTimeoutVal = options.stopTimeoutVal;
        TimeUnit stopTimeoutUnit = options.stopTimeoutUnit;
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
        ThreadPoolExecutor invoker = new ThreadPoolExecutor(workerThreads, workerThreads, stopTimeoutVal, stopTimeoutUnit, queue);
        return invoker;
    }

    protected void gracefullyShutdownInvokerPool() {
        long newnow;
        this.invoker.shutdown();
        long now = System.currentTimeMillis();
        for (long timeoutMS = 10000L; timeoutMS >= 0L; timeoutMS -= newnow - now) {
            try {
                this.invoker.awaitTermination(timeoutMS, TimeUnit.MILLISECONDS);
                break;
            }
            catch (InterruptedException ix) {
                newnow = System.currentTimeMillis();
                now = newnow;
                continue;
            }
        }
    }

    @Override
    protected boolean requestInvoke(TNonblockingServer.FrameBuffer frameBuffer) {
        try {
            Runnable invocation = this.getRunnable(frameBuffer);
            this.invoker.execute(invocation);
            return true;
        }
        catch (RejectedExecutionException rx) {
            LOGGER.warn((Object)"ExecutorService rejected execution!", (Throwable)rx);
            return false;
        }
    }

    protected Runnable getRunnable(TNonblockingServer.FrameBuffer frameBuffer) {
        return new Invocation(frameBuffer);
    }

    private class Invocation
    implements Runnable {
        private final TNonblockingServer.FrameBuffer frameBuffer;

        public Invocation(TNonblockingServer.FrameBuffer frameBuffer) {
            this.frameBuffer = frameBuffer;
        }

        @Override
        public void run() {
            this.frameBuffer.invoke();
        }
    }

    public static class Args
    extends TNonblockingServer.AbstractNonblockingServerArgs<Args> {
        private int workerThreads = 5;
        private int stopTimeoutVal = 60;
        private TimeUnit stopTimeoutUnit = TimeUnit.SECONDS;
        private ExecutorService executorService = null;

        public Args(TNonblockingServerTransport transport) {
            super(transport);
        }

        public Args workerThreads(int i) {
            this.workerThreads = i;
            return this;
        }

        public int getWorkerThreads() {
            return this.workerThreads;
        }

        public int getStopTimeoutVal() {
            return this.stopTimeoutVal;
        }

        public Args stopTimeoutVal(int stopTimeoutVal) {
            this.stopTimeoutVal = stopTimeoutVal;
            return this;
        }

        public TimeUnit getStopTimeoutUnit() {
            return this.stopTimeoutUnit;
        }

        public Args stopTimeoutUnit(TimeUnit stopTimeoutUnit) {
            this.stopTimeoutUnit = stopTimeoutUnit;
            return this;
        }

        public ExecutorService getExecutorService() {
            return this.executorService;
        }

        public Args executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }
    }
}

