/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift.thriftlib.server;

import org.apache.cassandra.thrift.thriftlib.TException;
import org.apache.cassandra.thrift.thriftlib.TProcessor;
import org.apache.cassandra.thrift.thriftlib.protocol.TProtocol;
import org.apache.cassandra.thrift.thriftlib.server.TServer;
import org.apache.cassandra.thrift.thriftlib.transport.TTransport;
import org.apache.cassandra.thrift.thriftlib.transport.TTransportException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TSimpleServer
extends TServer {
    private static final Log LOGGER = LogFactory.getLog(TSimpleServer.class);
    private boolean stopped_ = false;

    public TSimpleServer(TServer.AbstractServerArgs args) {
        super(args);
    }

    @Override
    public void serve() {
        this.stopped_ = false;
        try {
            this.serverTransport_.listen();
        }
        catch (TTransportException ttx) {
            LOGGER.warn((Object)"Error occurred during listening.", (Throwable)ttx);
            return;
        }
        this.setServing(true);
        while (!this.stopped_) {
            TTransport outputTransport;
            TTransport inputTransport;
            block11: {
                TTransport client = null;
                TProcessor processor = null;
                inputTransport = null;
                outputTransport = null;
                TProtocol inputProtocol = null;
                TProtocol outputProtocol = null;
                try {
                    client = this.serverTransport_.accept();
                    if (client != null) {
                        processor = this.processorFactory_.getProcessor(client);
                        inputTransport = this.inputTransportFactory_.getTransport(client);
                        outputTransport = this.outputTransportFactory_.getTransport(client);
                        inputProtocol = this.inputProtocolFactory_.getProtocol(inputTransport);
                        outputProtocol = this.outputProtocolFactory_.getProtocol(outputTransport);
                        while (processor.process(inputProtocol, outputProtocol)) {
                        }
                    }
                }
                catch (TTransportException tTransportException) {
                }
                catch (TException tx) {
                    if (!this.stopped_) {
                        LOGGER.warn((Object)"Thrift exception occurred during processing of message.", (Throwable)tx);
                    }
                }
                catch (Exception x) {
                    if (this.stopped_) break block11;
                    LOGGER.warn((Object)"Error occurred during processing of message.", (Throwable)x);
                }
            }
            if (inputTransport != null) {
                inputTransport.close();
            }
            if (outputTransport == null) continue;
            outputTransport.close();
        }
        this.setServing(false);
    }

    @Override
    public void stop() {
        this.stopped_ = true;
        this.serverTransport_.interrupt();
    }
}

