/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift.thriftlib.server;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.thrift.thriftlib.TException;
import org.apache.cassandra.thrift.thriftlib.TProcessor;
import org.apache.cassandra.thrift.thriftlib.protocol.TProtocol;
import org.apache.cassandra.thrift.thriftlib.server.TServer;
import org.apache.cassandra.thrift.thriftlib.transport.TServerTransport;
import org.apache.cassandra.thrift.thriftlib.transport.TTransport;
import org.apache.cassandra.thrift.thriftlib.transport.TTransportException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TThreadPoolServer
extends TServer {
    private static final Log LOGGER = LogFactory.getLog(TThreadPoolServer.class);
    private ExecutorService executorService_;
    private volatile boolean stopped_;
    private final TimeUnit stopTimeoutUnit;
    private final long stopTimeoutVal;

    public TThreadPoolServer(Args args) {
        super(args);
        SynchronousQueue<Runnable> executorQueue = new SynchronousQueue<Runnable>();
        this.stopTimeoutUnit = args.stopTimeoutUnit;
        this.stopTimeoutVal = args.stopTimeoutVal;
        this.executorService_ = new ThreadPoolExecutor(args.minWorkerThreads, args.maxWorkerThreads, 60L, TimeUnit.SECONDS, executorQueue);
    }

    @Override
    public void serve() {
        long newnow;
        try {
            this.serverTransport_.listen();
        }
        catch (TTransportException ttx) {
            LOGGER.warn((Object)"Exception occurred during listening.", (Throwable)ttx);
            return;
        }
        this.stopped_ = false;
        this.setServing(true);
        while (!this.stopped_) {
            int failureCount = 0;
            try {
                TTransport client = this.serverTransport_.accept();
                WorkerProcess wp = new WorkerProcess(client);
                this.executorService_.execute(wp);
            }
            catch (TTransportException ttx) {
                if (this.stopped_) continue;
                ++failureCount;
                LOGGER.warn((Object)"Transport error occurred during acceptance of message.", (Throwable)ttx);
            }
        }
        this.executorService_.shutdown();
        long now = System.currentTimeMillis();
        for (long timeoutMS = this.stopTimeoutUnit.toMillis(this.stopTimeoutVal); timeoutMS >= 0L; timeoutMS -= newnow - now) {
            try {
                this.executorService_.awaitTermination(timeoutMS, TimeUnit.MILLISECONDS);
                break;
            }
            catch (InterruptedException ix) {
                newnow = System.currentTimeMillis();
                now = newnow;
                continue;
            }
        }
        this.setServing(false);
    }

    @Override
    public void stop() {
        this.stopped_ = true;
        this.serverTransport_.interrupt();
    }

    private class WorkerProcess
    implements Runnable {
        private TTransport client_;

        private WorkerProcess(TTransport client) {
            this.client_ = client;
        }

        @Override
        public void run() {
            TProcessor processor = null;
            TTransport inputTransport = null;
            TTransport outputTransport = null;
            TProtocol inputProtocol = null;
            TProtocol outputProtocol = null;
            try {
                processor = TThreadPoolServer.this.processorFactory_.getProcessor(this.client_);
                inputTransport = TThreadPoolServer.this.inputTransportFactory_.getTransport(this.client_);
                outputTransport = TThreadPoolServer.this.outputTransportFactory_.getTransport(this.client_);
                inputProtocol = TThreadPoolServer.this.inputProtocolFactory_.getProtocol(inputTransport);
                outputProtocol = TThreadPoolServer.this.outputProtocolFactory_.getProtocol(outputTransport);
                while (!TThreadPoolServer.this.stopped_ && processor.process(inputProtocol, outputProtocol)) {
                }
            }
            catch (TTransportException tTransportException) {
            }
            catch (TException tx) {
                LOGGER.warn((Object)"Thrift exception occurred during processing of message.", (Throwable)tx);
            }
            catch (Exception x) {
                LOGGER.warn((Object)"Exception occurred during processing of message.", (Throwable)x);
            }
            if (inputTransport != null) {
                inputTransport.close();
            }
            if (outputTransport != null) {
                outputTransport.close();
            }
        }
    }

    public static class Args
    extends TServer.AbstractServerArgs<Args> {
        public int minWorkerThreads = 5;
        public int maxWorkerThreads = Integer.MAX_VALUE;
        public int stopTimeoutVal = 60;
        public TimeUnit stopTimeoutUnit = TimeUnit.SECONDS;

        public Args(TServerTransport transport) {
            super(transport);
        }

        public Args minWorkerThreads(int n) {
            this.minWorkerThreads = n;
            return this;
        }

        public Args maxWorkerThreads(int n) {
            this.maxWorkerThreads = n;
            return this;
        }
    }
}

