/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift.thriftlib.transport;

import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.cassandra.thrift.thriftlib.transport.TSaslTransport;
import org.apache.cassandra.thrift.thriftlib.transport.TTransport;
import org.apache.cassandra.thrift.thriftlib.transport.TTransportException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TSaslClientTransport
extends TSaslTransport {
    private static final Log LOGGER = LogFactory.getLog(TSaslClientTransport.class);
    private final String mechanism;

    public TSaslClientTransport(SaslClient saslClient, TTransport transport) {
        super(saslClient, transport);
        this.mechanism = saslClient.getMechanismName();
    }

    public TSaslClientTransport(String mechanism, String authorizationId, String protocol, String serverName, Map<String, String> props, CallbackHandler cbh, TTransport transport) throws SaslException {
        super(Sasl.createSaslClient(new String[]{mechanism}, authorizationId, protocol, serverName, props, cbh), transport);
        this.mechanism = mechanism;
    }

    @Override
    protected TSaslTransport.SaslRole getRole() {
        return TSaslTransport.SaslRole.CLIENT;
    }

    @Override
    protected void handleSaslStartMessage() throws TTransportException, SaslException {
        SaslClient saslClient = this.getSaslClient();
        byte[] initialResponse = new byte[]{};
        if (saslClient.hasInitialResponse()) {
            initialResponse = saslClient.evaluateChallenge(initialResponse);
        }
        LOGGER.debug((Object)String.format("Sending mechanism name %s and initial response of length %d", this.mechanism, initialResponse.length));
        byte[] mechanismBytes = this.mechanism.getBytes();
        this.sendSaslMessage(TSaslTransport.NegotiationStatus.START, mechanismBytes);
        this.sendSaslMessage(saslClient.isComplete() ? TSaslTransport.NegotiationStatus.COMPLETE : TSaslTransport.NegotiationStatus.OK, initialResponse);
        this.underlyingTransport.flush();
    }
}

