/*
 * Decompiled with CFR 0.152.
 */
package org.nico.noson.entity;

import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.nico.noson.entity.NoMap;

@Deprecated
public class NoHashMap<K, V>
implements NoMap<K, V> {
    private Integer defaultLength = 5;
    private Integer expand = 2;
    private Double loadFactor = 0.75;
    private V nullValue;
    private Lock lock = new ReentrantLock();
    private int size;
    private Set<Map.Entry<K, V>> recordSet;
    private Set<K> keySet;
    private NoRecord<K, V>[] tables = (NoRecord[])Array.newInstance(NoRecord.class, (int)this.defaultLength);

    public NoHashMap() {
        this.recordSet = new HashSet<Map.Entry<K, V>>();
        this.keySet = new HashSet<K>();
    }

    final int hashCode(Object obj) {
        return obj.getClass().hashCode();
    }

    final int getHash(K key) {
        int h = 0;
        h ^= this.hashCode(key);
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    public int getIndex(int hash) {
        return hash & this.tables.length - 1;
    }

    @Override
    public V put(K key, V value) {
        this.lock.lock();
        if ((double)this.size > (double)this.tables.length / this.loadFactor) {
            NoRecord[] newTables = new NoRecord[this.tables.length * this.expand];
            NoRecord<K, V>[] noRecordArray = this.tables;
            int n = noRecordArray.length;
            for (int i = 0; i < n; ++i) {
                NoRecord<K, V> record;
                for (NoRecord<K, V> th = record = noRecordArray[i]; th != null; th = th.getNext()) {
                    NoRecord<K, V> newRecord;
                    int index = th.getHash() & newTables.length - 1;
                    newTables[index] = newRecord = new NoRecord<K, V>(th.getKey(), th.getValue(), th.getHash(), newTables[index]);
                }
            }
            this.tables = newTables;
        }
        if (key == null) {
            this.nullValue = value;
        } else {
            int hash = this.getHash(key);
            int index = this.getIndex(hash);
            NoRecord record = this.tables[index];
            if (record != null) {
                NoRecord temp = record;
                boolean update = false;
                while (temp != null) {
                    if (temp.getKey().equals(key) && temp.getHash() == hash) {
                        temp.setValue(value);
                        update = true;
                        break;
                    }
                    temp = temp.next;
                }
                if (!update) {
                    NoRecord<K, V> newRecord = new NoRecord<K, V>(key, value, hash, record);
                    this.tables[index] = newRecord;
                    this.recordSet.add(this.tables[index]);
                    ++this.size;
                }
            } else {
                this.tables[index] = new NoRecord<K, V>(key, value, hash);
                this.recordSet.add(this.tables[index]);
                ++this.size;
            }
        }
        this.lock.unlock();
        return value;
    }

    @Override
    public boolean contains(K key) {
        if (key == null) {
            if (this.nullValue != null) {
                return true;
            }
        } else {
            int hash = this.getHash(key);
            int index = this.getIndex(hash);
            NoRecord record = this.tables[index];
            if (record != null) {
                NoRecord temp = record;
                while (temp != null) {
                    if (temp.getKey().equals(key) && temp.getHash() == hash) {
                        return true;
                    }
                    temp = temp.next;
                }
            }
        }
        return false;
    }

    @Override
    public V get(K key) {
        if (key == null) {
            return this.nullValue;
        }
        int hash = this.getHash(key);
        int index = this.getIndex(hash);
        NoRecord record = this.tables[index];
        if (record != null) {
            NoRecord temp = record;
            while (temp != null) {
                if (temp.getKey().equals(key) && temp.getHash() == hash) {
                    return temp.getValue();
                }
                temp = temp.next;
            }
        }
        return null;
    }

    @Override
    public void remove(K key) {
        if (key == null) {
            this.recordSet.remove(this.nullValue);
            this.nullValue = null;
        } else {
            int hash = this.getHash(key);
            int index = this.getIndex(hash);
            NoRecord record = this.tables[index];
            if (record != null) {
                NoRecord temp = record;
                while (temp != null) {
                    if (temp.getKey().equals(key) && temp.getHash() == hash) {
                        this.recordSet.remove(temp);
                        this.keySet.remove(key);
                        temp = temp.next;
                        break;
                    }
                    temp = temp.next;
                }
            }
            --this.size;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Set<Map.Entry<K, V>> recordSet() {
        return this.recordSet;
    }

    @Override
    public Set<K> keySet() {
        return this.keySet;
    }

    public String toString() {
        Iterator<Map.Entry<K, V>> i = this.recordSet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<K, V> e = i.next();
            K key = e.getKey();
            V value = e.getValue();
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    public static class NoRecord<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;
        private int hash;
        private NoRecord<K, V> next;

        public NoRecord(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public NoRecord(K key, V value, int hash) {
            this.key = key;
            this.value = value;
            this.hash = hash;
        }

        public NoRecord(K key, V value, NoRecord<K, V> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        public NoRecord(K key, V value, int hash, NoRecord<K, V> next) {
            this.key = key;
            this.value = value;
            this.hash = hash;
            this.next = next;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        public void setKey(K key) {
            this.key = key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            this.value = value;
            return value;
        }

        public NoRecord<K, V> getNext() {
            return this.next;
        }

        public void setNext(NoRecord<K, V> next) {
            this.next = next;
        }

        public int getHash() {
            return this.hash;
        }

        public void setHash(int hash) {
            this.hash = hash;
        }
    }
}

