/*
 * Decompiled with CFR 0.152.
 */
package org.nico.noson.util.type;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nico.noson.NosonConfig;
import org.nico.noson.adapter.type.AbstractTypeAdapter;
import org.nico.noson.cache.CacheManager;
import org.nico.noson.entity.NoType;
import org.nico.noson.entity.TypeBean;
import org.nico.noson.exception.NosonException;
import org.nico.noson.scanner.impl.SimpleScanner;
import org.nico.noson.scanner.plant.AbstractPlant;
import org.nico.noson.util.reflect.FieldUtils;
import org.nico.noson.util.string.FormatUtils;

public class TypeUtils {
    public static final String BOOLEAN_TRUE = "TRUE";
    public static final String BOOLEAN_FALSE = "FALSE";
    public static final Set<Class<?>> NUM_CLASS_SET = new HashSet<Class<?>>(){
        private static final long serialVersionUID = -1925389609848043520L;
        {
            this.add(Integer.TYPE);
            this.add(Short.TYPE);
            this.add(Double.TYPE);
            this.add(Long.TYPE);
            this.add(Float.TYPE);
            this.add(Byte.TYPE);
        }
    };

    public static Object typeAllotValue(String param) {
        if (param == null) {
            return param;
        }
        Object result = param;
        result = CacheManager.getValueCache().getCache(param);
        if (result != null) {
            return result;
        }
        try {
            result = NosonConfig.DEFAULT_DATE_FORMAT.parse(param);
        }
        catch (Exception e0) {
            try {
                result = Integer.parseInt(param);
            }
            catch (NumberFormatException e) {
                try {
                    result = Double.parseDouble(param);
                }
                catch (NumberFormatException e3) {
                    try {
                        result = new BigDecimal(param);
                    }
                    catch (NumberFormatException e4) {
                        result = BOOLEAN_TRUE.equalsIgnoreCase(param) || BOOLEAN_FALSE.equalsIgnoreCase(param) ? Boolean.valueOf(Boolean.parseBoolean(param)) : (param.equals("null") ? null : param);
                    }
                }
            }
        }
        result = result instanceof String ? FormatUtils.deEscape((String)result) : result;
        CacheManager.getValueCache().putCache(param, result);
        return result;
    }

    public static String typeAllotKey(String param) {
        if (param == null) {
            return param;
        }
        String result = param;
        if (CacheManager.getKeyCache().containsCache(param)) {
            return String.valueOf(CacheManager.getKeyCache().getCache(param));
        }
        result = result instanceof String ? FormatUtils.deEscape(result) : result;
        CacheManager.getKeyCache().putCache(param, result);
        return result;
    }

    public static boolean isInseparable(Class<?> clazz) {
        boolean inseparable = false;
        if (clazz.isPrimitive()) {
            inseparable = true;
        } else if (Number.class.isAssignableFrom(clazz)) {
            inseparable = true;
        } else if (clazz.isAssignableFrom(String.class)) {
            inseparable = true;
        } else if (clazz.isAssignableFrom(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            inseparable = true;
        } else if (Date.class.isAssignableFrom(clazz)) {
            inseparable = true;
        } else if (Enum.class.isAssignableFrom(clazz)) {
            inseparable = true;
        }
        return inseparable;
    }

    public static String typeWrap(Class<?> type, Object obj) {
        if (obj == null) {
            return TypeUtils.emptyWrap(type, NosonConfig.ALLOW_EMPTY_TO_NULL);
        }
        if (TypeUtils.isInseparable(obj.getClass())) {
            if (obj instanceof String) {
                return "\"" + FormatUtils.enEscape((String)obj) + "\"";
            }
            if (obj instanceof Date) {
                return "\"" + NosonConfig.DEFAULT_DATE_FORMAT.format((Date)obj) + "\"";
            }
            if (obj instanceof Enum) {
                return "\"" + obj.toString() + "\"";
            }
            return obj.toString();
        }
        return "\"" + obj.getClass().getName() + "\"";
    }

    public static String emptyWrap(Class<?> type, boolean toNull) {
        String result = null;
        if (Object.class.isAssignableFrom(type)) {
            if (!toNull) {
                if (Number.class.isAssignableFrom(type)) {
                    result = "0";
                } else if (String.class.isAssignableFrom(type)) {
                    result = "\"\"";
                }
            }
        } else if (type.isAssignableFrom(Integer.TYPE)) {
            result = "0";
        } else if (type.isAssignableFrom(Float.TYPE)) {
            result = "0.000";
        } else if (type.isAssignableFrom(Double.TYPE)) {
            result = "0.000000";
        } else if (type.isAssignableFrom(Long.TYPE)) {
            result = "0";
        } else if (type.isAssignableFrom(Short.TYPE)) {
            result = "0";
        } else if (type.isAssignableFrom(Byte.TYPE)) {
            result = "0";
        } else if (type.isAssignableFrom(Boolean.TYPE)) {
            result = "false";
        }
        return result;
    }

    public static Object getStructInstance(Class<?> clazz) throws NosonException {
        Object target = AbstractPlant.TYPE_PLANT.get(clazz);
        if (target == null) {
            if (clazz.isArray()) {
                target = new LinkedList();
            } else {
                try {
                    target = clazz.newInstance();
                }
                catch (Exception e) {
                    throw new NosonException(e.getMessage(), e);
                }
            }
        } else {
            target = ((AbstractPlant)target).get();
        }
        return target;
    }

    public static void setParamIntoObject(Object target, SimpleScanner.SimpleStruct currentStruct) throws NosonException {
        String key = currentStruct.getName();
        Object value = currentStruct.getValue();
        if (currentStruct.getClassType() != null && currentStruct.getValue() != null && currentStruct.getClassType().isArray()) {
            Collection list = (Collection)value;
            Class<?> componentType = currentStruct.getClassType().getComponentType();
            Object array = Array.newInstance(componentType, list.size());
            int index = 0;
            for (Object obj : list) {
                Array.set(array, index++, TypeUtils.convertType(componentType, obj));
            }
            value = array;
        }
        if (target instanceof Collection) {
            ((Collection)target).add(value);
        } else if (target instanceof Map) {
            ((Map)target).put(key, value);
        } else if (target.getClass().isArray()) {
            target = TypeUtils.getNewArray(target, target.getClass().getComponentType(), value);
        } else {
            Class<?> type;
            TypeBean<?> typeBean = TypeUtils.getFieldType(target.getClass(), key);
            Class<?> clazz = type = typeBean == null ? null : typeBean.getMainClass();
            if (type != null) {
                Field field = TypeUtils.getField(target.getClass(), key);
                value = TypeUtils.convertType(type, value);
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                try {
                    field.set(target, value);
                }
                catch (Exception e) {
                    throw new NosonException(e);
                }
            }
        }
    }

    public static TypeBean<?> getFieldType(Class<?> clazz, String fieldName) throws NosonException {
        Field field;
        TypeBean<?> typeBean = null;
        String fieldCacheKey = clazz.getName() + fieldName;
        typeBean = (TypeBean<?>)CacheManager.getFieldTypeCache().getCache(fieldCacheKey);
        if (typeBean == null && (field = FieldUtils.getField(fieldName, clazz)) != null) {
            typeBean = TypeUtils.getGenericityType(field);
            CacheManager.getFieldTypeCache().putCache(fieldCacheKey, typeBean);
        }
        return typeBean;
    }

    public static Field getField(Class<?> clazz, String fieldName) throws NosonException {
        Field field = null;
        String fieldCacheKey = clazz.getName() + fieldName;
        field = (Field)CacheManager.getFieldCache().getCache(fieldCacheKey);
        if (field == null) {
            field = FieldUtils.getField(fieldName, clazz);
            CacheManager.getFieldCache().putCache(fieldCacheKey, field);
        }
        return field;
    }

    public static <T> Object getNewArray(Object array, Class<T> componentType, Object value) throws ArrayIndexOutOfBoundsException, IllegalArgumentException, NosonException {
        int len = Array.getLength(array);
        Object newArray = Array.newInstance(componentType, len + 1);
        System.arraycopy(array, 0, newArray, 0, len);
        Array.set(newArray, len, TypeUtils.convertType(componentType, value));
        return newArray;
    }

    public static List<Class<?>> getGenericityTypeIterate(Class<?> clazz) {
        List<Class<?>> typeList = new ArrayList();
        if (clazz != null) {
            TypeBean<?> header = TypeUtils.getGenericityType(clazz);
            typeList = TypeUtils.getGenericityTypeIterate(header);
        }
        return typeList;
    }

    public static List<Class<?>> getGenericityTypeIterate(TypeBean<?> header) {
        ArrayList typeList = new ArrayList();
        if (NoType.class.isAssignableFrom(header.getMainClass())) {
            header = header.getGenericityBeans()[0];
        }
        typeList.add(header.getMainClass());
        TypeBean<?> currentType = header;
        block5: while (currentType != null && currentType.getGenericityBeans() != null) {
            TypeBean<?>[] typeBeans = currentType.getGenericityBeans();
            switch (typeBeans.length) {
                case 0: {
                    typeList.add(Object.class);
                    currentType = null;
                    continue block5;
                }
                case 1: {
                    currentType = typeBeans[0];
                    typeList.add(currentType.getMainClass());
                    continue block5;
                }
                case 2: {
                    currentType = typeBeans[1];
                    typeList.add(currentType.getMainClass());
                    continue block5;
                }
            }
            throw new RuntimeException("Exceeding the limit of the generic length !!");
        }
        return typeList;
    }

    public static TypeBean<?> getGenericityType(Class<?> clazz) {
        TypeBean typeBean = new TypeBean(clazz);
        if (clazz == null) {
            throw new NullPointerException("Class is null");
        }
        Type superclass = clazz.getGenericSuperclass();
        if (superclass != null && !(superclass instanceof Class)) {
            ParameterizedType parameterized = (ParameterizedType)superclass;
            if (!Modifier.isPublic(clazz.getModifiers())) {
                typeBean.setMainClass((Class)parameterized.getRawType());
            }
            Type[] types = TypeUtils.typesWrapper(clazz, parameterized.getActualTypeArguments());
            typeBean.setGenericityBeans(TypeUtils.getGenericityTypes(types));
        }
        return typeBean;
    }

    public static TypeBean<?> getGenericityType(Field field) {
        Class<?> clazz = field.getType();
        TypeBean typeBean = new TypeBean(clazz);
        try {
            Type type = field.getGenericType();
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterized = (ParameterizedType)field.getGenericType();
                if (!Modifier.isPublic(clazz.getModifiers())) {
                    typeBean.setMainClass((Class)parameterized.getRawType());
                }
                Type[] types = TypeUtils.typesWrapper(clazz, parameterized.getActualTypeArguments());
                typeBean.setGenericityBeans(TypeUtils.getGenericityTypes(types));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return typeBean;
    }

    public static Type[] typesWrapper(Class<?> clazz, Type[] types) {
        int len = 1;
        if (Map.class.isAssignableFrom(clazz)) {
            len = 2;
        } else if (Collection.class.isAssignableFrom(clazz)) {
            len = 1;
        }
        if (types == null) {
            types = new Type[]{String.class, Object.class};
        } else if (types.length != len) {
            Type[] newTypes = new Type[len];
            for (int index = 0; index < newTypes.length; ++index) {
                newTypes[index] = index < types.length ? types[index] : Object.class;
            }
            types = newTypes;
        }
        return types;
    }

    public static TypeBean<?>[] getGenericityTypes(Type[] types) {
        if (types.length == 0) {
            throw new ArrayIndexOutOfBoundsException(0);
        }
        TypeBean[] typeBeans = new TypeBean[types.length];
        int index = 0;
        for (Type type : types) {
            TypeBean typeBean = null;
            if (type instanceof ParameterizedType) {
                Class targetClass = (Class)((ParameterizedType)type).getRawType();
                typeBean = new TypeBean(targetClass);
                typeBean.setGenericityBeans(TypeUtils.getGenericityTypes(TypeUtils.typesWrapper(targetClass, ((ParameterizedType)type).getActualTypeArguments())));
            } else {
                typeBean = new TypeBean((Class)type);
            }
            typeBeans[index++] = typeBean;
        }
        return typeBeans;
    }

    public static Object convertType(Class<?> clazz, Object target) throws NosonException {
        if (target == null && clazz == null) {
            return null;
        }
        if (target == null && clazz != null) {
            return TypeUtils.emptyWrap(clazz, NosonConfig.ALLOW_EMPTY_TO_NULL);
        }
        Class<Object> key = clazz;
        if (Enum.class.isAssignableFrom(clazz)) {
            key = Enum.class;
        }
        AbstractTypeAdapter typeAdapter = null;
        typeAdapter = AbstractTypeAdapter.TYPE_ADAPTER_MAP.get(key);
        if (null != typeAdapter) {
            return typeAdapter.typeAdapter(clazz, target);
        }
        return target;
    }
}

