/*
 * Decompiled with CFR 0.152.
 */
package com.github.zkclient;

import com.github.zkclient.exception.ZkInterruptedException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class ZkClientUtils {
    public static final ZkVersion zkVersion;
    public static final String OVERWRITE_HOSTNAME_SYSTEM_PROPERTY = "zkclient.hostname.overwritten";

    public static RuntimeException convertToRuntimeException(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        ZkClientUtils.retainInterruptFlag(e);
        return new RuntimeException(e);
    }

    public static void retainInterruptFlag(Throwable catchedException) {
        if (catchedException instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static void rethrowInterruptedException(Throwable e) throws InterruptedException {
        if (e instanceof InterruptedException) {
            throw (InterruptedException)e;
        }
        if (e instanceof ZkInterruptedException) {
            throw (ZkInterruptedException)e;
        }
    }

    public static String leadingZeros(long number, int numberOfLeadingZeros) {
        return String.format("%0" + numberOfLeadingZeros + "d", number);
    }

    public static boolean isPortFree(int port) {
        try {
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress("localhost", port), 200);
            socket.close();
            return false;
        }
        catch (SocketTimeoutException e) {
            return true;
        }
        catch (ConnectException e) {
            return true;
        }
        catch (SocketException e) {
            if (e.getMessage().equals("Connection reset by peer")) {
                return true;
            }
            throw new RuntimeException(e);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getLocalhostName() {
        String property = System.getProperty(OVERWRITE_HOSTNAME_SYSTEM_PROPERTY);
        if (property != null && property.trim().length() > 0) {
            return property;
        }
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("unable to retrieve localhost name");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        ZkVersion version = null;
        try {
            Class.forName("org.apache.zookeeper.OpResult");
            version = ZkVersion.V34;
        }
        catch (ClassNotFoundException e) {
            version = ZkVersion.V33;
        }
        finally {
            zkVersion = version;
        }
    }

    public static enum ZkVersion {
        V33,
        V34;

    }
}

