/*
 * Decompiled with CFR 0.152.
 */
package org.hazlewood.connor.bottema.emailaddress;

import java.util.EnumSet;
import org.hazlewood.connor.bottema.emailaddress.Dragons;
import org.hazlewood.connor.bottema.emailaddress.EmailAddressCriteria;

public final class EmailAddressValidator {
    private EmailAddressValidator() {
    }

    public static boolean isValid(String email) {
        return EmailAddressValidator.isValid(email, EmailAddressCriteria.DEFAULT);
    }

    public static boolean isValidStrict(String email) {
        return EmailAddressValidator.isValid(email, EmailAddressCriteria.RFC_COMPLIANT);
    }

    public static boolean isValid(String email, EnumSet<EmailAddressCriteria> criteria) {
        return EmailAddressValidator.isValidMailbox(email, Dragons.fromCriteria(criteria));
    }

    private static boolean isValidMailbox(String email, Dragons dragons) {
        return email != null && dragons.MAILBOX_PATTERN.matcher(email).matches();
    }
}

