/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.utils.qrcode.QrcodeUtils;
import com.github.binarywang.wxpay.bean.request.WxEntPayQueryRequest;
import com.github.binarywang.wxpay.bean.request.WxEntPayRequest;
import com.github.binarywang.wxpay.bean.request.WxPayAuthcode2OpenidRequest;
import com.github.binarywang.wxpay.bean.request.WxPayDefaultRequest;
import com.github.binarywang.wxpay.bean.request.WxPayDownloadBillRequest;
import com.github.binarywang.wxpay.bean.request.WxPayMicropayRequest;
import com.github.binarywang.wxpay.bean.request.WxPayOrderCloseRequest;
import com.github.binarywang.wxpay.bean.request.WxPayOrderQueryRequest;
import com.github.binarywang.wxpay.bean.request.WxPayOrderReverseRequest;
import com.github.binarywang.wxpay.bean.request.WxPayRedpackQueryRequest;
import com.github.binarywang.wxpay.bean.request.WxPayRefundQueryRequest;
import com.github.binarywang.wxpay.bean.request.WxPayRefundRequest;
import com.github.binarywang.wxpay.bean.request.WxPayReportRequest;
import com.github.binarywang.wxpay.bean.request.WxPaySendRedpackRequest;
import com.github.binarywang.wxpay.bean.request.WxPayShorturlRequest;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.bean.result.WxEntPayQueryResult;
import com.github.binarywang.wxpay.bean.result.WxEntPayResult;
import com.github.binarywang.wxpay.bean.result.WxPayAuthcode2OpenidResult;
import com.github.binarywang.wxpay.bean.result.WxPayBaseResult;
import com.github.binarywang.wxpay.bean.result.WxPayBillBaseResult;
import com.github.binarywang.wxpay.bean.result.WxPayBillResult;
import com.github.binarywang.wxpay.bean.result.WxPayCommonResult;
import com.github.binarywang.wxpay.bean.result.WxPayMicropayResult;
import com.github.binarywang.wxpay.bean.result.WxPayOrderCloseResult;
import com.github.binarywang.wxpay.bean.result.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.bean.result.WxPayOrderQueryResult;
import com.github.binarywang.wxpay.bean.result.WxPayOrderReverseResult;
import com.github.binarywang.wxpay.bean.result.WxPayRedpackQueryResult;
import com.github.binarywang.wxpay.bean.result.WxPayRefundQueryResult;
import com.github.binarywang.wxpay.bean.result.WxPayRefundResult;
import com.github.binarywang.wxpay.bean.result.WxPaySandboxSignKeyResult;
import com.github.binarywang.wxpay.bean.result.WxPaySendRedpackResult;
import com.github.binarywang.wxpay.bean.result.WxPayShorturlResult;
import com.github.binarywang.wxpay.bean.result.WxPayUnifiedOrderResult;
import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.util.SignUtils;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.net.ssl.SSLContext;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import jodd.http.net.SSLSocketHttpConnectionProvider;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxPayServiceImpl
implements WxPayService {
    private static final String PAY_BASE_URL = "https://api.mch.weixin.qq.com";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private WxPayConfig config;

    @Override
    public WxPayConfig getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(WxPayConfig config) {
        this.config = config;
    }

    private String getPayBaseUrl() {
        if (this.getConfig().useSandbox()) {
            return "https://api.mch.weixin.qq.com/sandboxnew";
        }
        return PAY_BASE_URL;
    }

    @Override
    public WxPayRefundResult refund(WxPayRefundRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/secapi/pay/refund";
        String responseContent = this.postWithKey(url, request.toXML());
        WxPayRefundResult result = WxPayBaseResult.fromXML(responseContent, WxPayRefundResult.class);
        result.checkResult(this);
        return result;
    }

    @Override
    public WxPayRefundQueryResult refundQuery(String transactionId, String outTradeNo, String outRefundNo, String refundId) throws WxPayException {
        WxPayRefundQueryRequest request = new WxPayRefundQueryRequest();
        request.setOutTradeNo(StringUtils.trimToNull((String)outTradeNo));
        request.setTransactionId(StringUtils.trimToNull((String)transactionId));
        request.setOutRefundNo(StringUtils.trimToNull((String)outRefundNo));
        request.setRefundId(StringUtils.trimToNull((String)refundId));
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/refundquery";
        String responseContent = this.post(url, request.toXML(), true);
        WxPayRefundQueryResult result = WxPayBaseResult.fromXML(responseContent, WxPayRefundQueryResult.class);
        result.composeRefundRecords();
        result.checkResult(this);
        return result;
    }

    @Override
    public WxPayOrderNotifyResult getOrderNotifyResult(String xmlData) throws WxPayException {
        try {
            this.log.debug("\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\u53c2\u6570\u8be6\u7ec6\uff1a{}", (Object)xmlData);
            WxPayOrderNotifyResult result = WxPayOrderNotifyResult.fromXML(xmlData);
            this.log.debug("\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\u7ed3\u679c\u5bf9\u8c61\uff1a{}", (Object)result);
            result.checkResult(this);
            return result;
        }
        catch (WxPayException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new WxPayException("\u53d1\u751f\u5f02\u5e38\uff0c" + e.getMessage());
        }
    }

    @Override
    public WxPaySendRedpackResult sendRedpack(WxPaySendRedpackRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/mmpaymkttransfers/sendredpack";
        if (request.getAmtType() != null) {
            url = this.getPayBaseUrl() + "/mmpaymkttransfers/sendgroupredpack";
        }
        String responseContent = this.postWithKey(url, request.toXML());
        WxPaySendRedpackResult result = WxPayBaseResult.fromXML(responseContent, WxPaySendRedpackResult.class);
        return result;
    }

    @Override
    public WxPayRedpackQueryResult queryRedpack(String mchBillNo) throws WxPayException {
        WxPayRedpackQueryRequest request = new WxPayRedpackQueryRequest();
        request.setMchBillNo(mchBillNo);
        request.setBillType("MCHT");
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/mmpaymkttransfers/gethbinfo";
        String responseContent = this.postWithKey(url, request.toXML());
        WxPayRedpackQueryResult result = WxPayBaseResult.fromXML(responseContent, WxPayRedpackQueryResult.class);
        result.checkResult(this);
        return result;
    }

    @Override
    public WxPayOrderQueryResult queryOrder(String transactionId, String outTradeNo) throws WxPayException {
        WxPayOrderQueryRequest request = new WxPayOrderQueryRequest();
        request.setOutTradeNo(StringUtils.trimToNull((String)outTradeNo));
        request.setTransactionId(StringUtils.trimToNull((String)transactionId));
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/orderquery";
        String responseContent = this.post(url, request.toXML(), true);
        if (StringUtils.isBlank((CharSequence)responseContent)) {
            throw new WxPayException("\u65e0\u54cd\u5e94\u7ed3\u679c");
        }
        WxPayOrderQueryResult result = WxPayBaseResult.fromXML(responseContent, WxPayOrderQueryResult.class);
        result.composeCoupons();
        result.checkResult(this);
        return result;
    }

    @Override
    public WxPayOrderCloseResult closeOrder(String outTradeNo) throws WxPayException {
        if (StringUtils.isBlank((CharSequence)outTradeNo)) {
            throw new IllegalArgumentException("out_trade_no\u4e0d\u80fd\u4e3a\u7a7a");
        }
        WxPayOrderCloseRequest request = new WxPayOrderCloseRequest();
        request.setOutTradeNo(StringUtils.trimToNull((String)outTradeNo));
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/closeorder";
        String responseContent = this.post(url, request.toXML(), true);
        WxPayOrderCloseResult result = WxPayBaseResult.fromXML(responseContent, WxPayOrderCloseResult.class);
        result.checkResult(this);
        return result;
    }

    @Override
    public WxPayUnifiedOrderResult unifiedOrder(WxPayUnifiedOrderRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/unifiedorder";
        String responseContent = this.post(url, request.toXML(), true);
        WxPayUnifiedOrderResult result = WxPayBaseResult.fromXML(responseContent, WxPayUnifiedOrderResult.class);
        result.checkResult(this);
        return result;
    }

    @Override
    public Map<String, String> getPayInfo(WxPayUnifiedOrderRequest request) throws WxPayException {
        WxPayUnifiedOrderResult unifiedOrderResult = this.unifiedOrder(request);
        String prepayId = unifiedOrderResult.getPrepayId();
        if (StringUtils.isBlank((CharSequence)prepayId)) {
            throw new RuntimeException(String.format("\u65e0\u6cd5\u83b7\u53d6prepay id\uff0c\u9519\u8bef\u4ee3\u7801\uff1a '%s'\uff0c\u4fe1\u606f\uff1a%s\u3002", unifiedOrderResult.getErrCode(), unifiedOrderResult.getErrCodeDes()));
        }
        HashMap<String, String> payInfo = new HashMap<String, String>();
        if ("NATIVE".equals(request.getTradeType())) {
            payInfo.put("codeUrl", unifiedOrderResult.getCodeURL());
        } else if ("APP".equals(request.getTradeType())) {
            String appId = this.getConfig().getAppId();
            HashMap<String, String> configMap = new HashMap<String, String>();
            String partnerid = this.getConfig().getMchId();
            configMap.put("prepayid", prepayId);
            configMap.put("partnerid", partnerid);
            configMap.put("package", "Sign=WXPay");
            configMap.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
            configMap.put("noncestr", String.valueOf(System.currentTimeMillis()));
            configMap.put("appid", appId);
            payInfo.put("sign", SignUtils.createSign(configMap, this.getConfig().getMchKey()));
            payInfo.put("prepayId", prepayId);
            payInfo.put("partnerId", partnerid);
            payInfo.put("appId", appId);
            payInfo.put("packageValue", "Sign=WXPay");
            payInfo.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
            payInfo.put("nonceStr", String.valueOf(System.currentTimeMillis()));
        } else if ("JSAPI".equals(request.getTradeType())) {
            payInfo.put("appId", unifiedOrderResult.getAppid());
            payInfo.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
            payInfo.put("nonceStr", String.valueOf(System.currentTimeMillis()));
            payInfo.put("package", "prepay_id=" + prepayId);
            payInfo.put("signType", "MD5");
            payInfo.put("paySign", SignUtils.createSign(payInfo, this.getConfig().getMchKey()));
        }
        return payInfo;
    }

    @Override
    public WxEntPayResult entPay(WxEntPayRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/mmpaymkttransfers/promotion/transfers";
        String responseContent = this.postWithKey(url, request.toXML());
        WxEntPayResult result = WxPayBaseResult.fromXML(responseContent, WxEntPayResult.class);
        result.checkResult(this);
        return result;
    }

    @Override
    public WxEntPayQueryResult queryEntPay(String partnerTradeNo) throws WxPayException {
        WxEntPayQueryRequest request = new WxEntPayQueryRequest();
        request.setPartnerTradeNo(partnerTradeNo);
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/mmpaymkttransfers/gettransferinfo";
        String responseContent = this.postWithKey(url, request.toXML());
        WxEntPayQueryResult result = WxPayBaseResult.fromXML(responseContent, WxEntPayQueryResult.class);
        result.checkResult(this);
        return result;
    }

    @Override
    public byte[] createScanPayQrcodeMode1(String productId, File logoFile, Integer sideLength) {
        String content = this.createScanPayQrcodeMode1(productId);
        return this.createQrcode(content, logoFile, sideLength);
    }

    @Override
    public String createScanPayQrcodeMode1(String productId) {
        StringBuilder codeUrl = new StringBuilder("weixin://wxpay/bizpayurl?");
        HashMap params = Maps.newHashMap();
        params.put("appid", this.getConfig().getAppId());
        params.put("mch_id", this.getConfig().getMchId());
        params.put("product_id", productId);
        params.put("time_stamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("nonce_str", String.valueOf(System.currentTimeMillis()));
        String sign = SignUtils.createSign(params, this.getConfig().getMchKey());
        params.put("sign", sign);
        for (String key : params.keySet()) {
            codeUrl.append(key + "=" + (String)params.get(key) + "&");
        }
        String content = codeUrl.toString().substring(0, codeUrl.length() - 1);
        this.log.debug("\u626b\u7801\u652f\u4ed8\u6a21\u5f0f\u4e00\u751f\u6210\u4e8c\u7ef4\u7801\u7684URL:{}", (Object)content);
        return content;
    }

    @Override
    public byte[] createScanPayQrcodeMode2(String codeUrl, File logoFile, Integer sideLength) {
        return this.createQrcode(codeUrl, logoFile, sideLength);
    }

    private byte[] createQrcode(String content, File logoFile, Integer sideLength) {
        if (sideLength == null || sideLength < 1) {
            return QrcodeUtils.createQrcode((String)content, (File)logoFile);
        }
        return QrcodeUtils.createQrcode((String)content, (int)sideLength, (File)logoFile);
    }

    @Override
    public void report(WxPayReportRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/payitil/report";
        String responseContent = this.post(url, request.toXML(), true);
        WxPayCommonResult result = WxPayBaseResult.fromXML(responseContent, WxPayCommonResult.class);
        result.checkResult(this);
    }

    @Override
    public WxPayBillResult downloadBill(String billDate, String billType, String tarType, String deviceInfo) throws WxPayException {
        WxPayDownloadBillRequest request = new WxPayDownloadBillRequest();
        request.setBillType(billType);
        request.setBillDate(billDate);
        request.setTarType(tarType);
        request.setDeviceInfo(deviceInfo);
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/downloadbill";
        String responseContent = this.post(url, request.toXML(), true);
        if (responseContent.startsWith("<")) {
            WxPayCommonResult result = WxPayBaseResult.fromXML(responseContent, WxPayCommonResult.class);
            result.checkResult(this);
            return null;
        }
        WxPayBillResult wxPayBillResult = this.billInformationDeal(responseContent);
        return wxPayBillResult;
    }

    private WxPayBillResult billInformationDeal(String responseContent) {
        WxPayBillResult wxPayBillResult = new WxPayBillResult();
        String listStr = "";
        String objStr = "";
        if (responseContent.contains("\u603b\u4ea4\u6613\u5355\u6570")) {
            listStr = responseContent.substring(0, responseContent.indexOf("\u603b\u4ea4\u6613\u5355\u6570"));
            objStr = responseContent.substring(responseContent.indexOf("\u603b\u4ea4\u6613\u5355\u6570"));
        }
        LinkedList<WxPayBillBaseResult> wxPayBillBaseResultLst = new LinkedList<WxPayBillBaseResult>();
        String newStr = listStr.replaceAll(",", " ");
        String[] tempStr = newStr.split("`");
        String[] t = tempStr[0].split(" ");
        int j = tempStr.length / t.length;
        int k = 1;
        for (int i = 0; i < j; ++i) {
            WxPayBillBaseResult wxPayBillBaseResult = new WxPayBillBaseResult();
            wxPayBillBaseResult.setTradeTime(tempStr[k]);
            wxPayBillBaseResult.setAppId(tempStr[k + 1]);
            wxPayBillBaseResult.setMchId(tempStr[k + 2]);
            wxPayBillBaseResult.setSubMchId(tempStr[k + 3]);
            wxPayBillBaseResult.setDeviceInfo(tempStr[k + 4]);
            wxPayBillBaseResult.setTransationId(tempStr[k + 5]);
            wxPayBillBaseResult.setOutTradeNo(tempStr[k + 6]);
            wxPayBillBaseResult.setOpenId(tempStr[k + 7]);
            wxPayBillBaseResult.setTradeType(tempStr[k + 8]);
            wxPayBillBaseResult.setTradeState(tempStr[k + 9]);
            wxPayBillBaseResult.setBankType(tempStr[k + 10]);
            wxPayBillBaseResult.setFeeType(tempStr[k + 11]);
            wxPayBillBaseResult.setTotalFee(tempStr[k + 12]);
            wxPayBillBaseResult.setCouponFee(tempStr[k + 13]);
            wxPayBillBaseResult.setRefundId(tempStr[k + 14]);
            wxPayBillBaseResult.setOutRefundNo(tempStr[k + 15]);
            wxPayBillBaseResult.setSettlementRefundFee(tempStr[k + 16]);
            wxPayBillBaseResult.setCouponRefundFee(tempStr[k + 17]);
            wxPayBillBaseResult.setRefundChannel(tempStr[k + 18]);
            wxPayBillBaseResult.setRefundState(tempStr[k + 19]);
            wxPayBillBaseResult.setBody(tempStr[k + 20]);
            wxPayBillBaseResult.setAttach(tempStr[k + 21]);
            wxPayBillBaseResult.setPoundage(tempStr[k + 22]);
            wxPayBillBaseResult.setPoundageRate(tempStr[k + 23]);
            wxPayBillBaseResultLst.add(wxPayBillBaseResult);
            k += t.length;
        }
        String totalStr = objStr.replaceAll(",", " ");
        String[] totalTempStr = totalStr.split("`");
        wxPayBillResult.setTotalRecord(totalTempStr[1]);
        wxPayBillResult.setTotalFee(totalTempStr[2]);
        wxPayBillResult.setTotalRefundFee(totalTempStr[3]);
        wxPayBillResult.setTotalCouponFee(totalTempStr[4]);
        wxPayBillResult.setTotalPoundageFee(totalTempStr[5]);
        return wxPayBillResult;
    }

    @Override
    public WxPayMicropayResult micropay(WxPayMicropayRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/micropay";
        String responseContent = this.post(url, request.toXML(), true);
        WxPayMicropayResult result = WxPayBaseResult.fromXML(responseContent, WxPayMicropayResult.class);
        result.checkResult(this);
        return result;
    }

    @Override
    public WxPayOrderReverseResult reverseOrder(WxPayOrderReverseRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/secapi/pay/reverse";
        String responseContent = this.postWithKey(url, request.toXML());
        WxPayOrderReverseResult result = WxPayBaseResult.fromXML(responseContent, WxPayOrderReverseResult.class);
        result.checkResult(this);
        return result;
    }

    @Override
    public String shorturl(WxPayShorturlRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/tools/shorturl";
        String responseContent = this.post(url, request.toXML(), true);
        WxPayShorturlResult result = WxPayBaseResult.fromXML(responseContent, WxPayShorturlResult.class);
        result.checkResult(this);
        return result.getShortUrl();
    }

    @Override
    public String shorturl(String longUrl) throws WxPayException {
        return this.shorturl(new WxPayShorturlRequest(longUrl));
    }

    @Override
    public String authcode2Openid(WxPayAuthcode2OpenidRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/tools/authcodetoopenid";
        String responseContent = this.post(url, request.toXML(), true);
        WxPayAuthcode2OpenidResult result = WxPayBaseResult.fromXML(responseContent, WxPayAuthcode2OpenidResult.class);
        result.checkResult(this);
        return result.getOpenid();
    }

    @Override
    public String authcode2Openid(String authCode) throws WxPayException {
        return this.authcode2Openid(new WxPayAuthcode2OpenidRequest(authCode));
    }

    @Override
    public String getSandboxSignKey() throws WxPayException {
        WxPayDefaultRequest request = new WxPayDefaultRequest();
        request.checkAndSign(this.getConfig());
        String url = "https://api.mch.weixin.qq.com/sandboxnew/pay/getsignkey";
        String responseContent = this.post(url, request.toXML(), false);
        WxPaySandboxSignKeyResult result = WxPayBaseResult.fromXML(responseContent, WxPaySandboxSignKeyResult.class);
        result.checkResult(this);
        return result.getSandboxSignKey();
    }

    private String post(String url, String xmlParam, boolean needTransferEncoding) {
        String requestString = xmlParam;
        try {
            requestString = new String(xmlParam.getBytes("UTF-8"), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        HttpRequest request = (HttpRequest)HttpRequest.post((String)url).body(requestString);
        String responseString = this.getResponseString(request.send());
        this.log.info("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e\u3011\uff1a{}", new Object[]{url, xmlParam, responseString});
        return responseString;
    }

    private String postWithKey(String url, String requestStr) throws WxPayException {
        try {
            SSLContext sslContext = this.getConfig().getSslContext();
            if (null == sslContext) {
                sslContext = this.getConfig().initSSLContext();
            }
            HttpRequest request = (HttpRequest)HttpRequest.post((String)url).withConnectionProvider((HttpConnectionProvider)new SSLSocketHttpConnectionProvider(sslContext)).bodyText(requestStr);
            String responseString = this.getResponseString(request.send());
            this.log.info("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e\u3011\uff1a{}", new Object[]{url, requestStr, responseString});
            return responseString;
        }
        catch (Exception e) {
            this.log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{url, requestStr, e.getMessage()});
            throw new WxPayException(e.getMessage());
        }
    }

    private String getResponseString(HttpResponse response) {
        this.log.debug("\u3010\u5fae\u4fe1\u670d\u52a1\u5668\u54cd\u5e94\u5934\u4fe1\u606f\u3011\uff1a\n{}", (Object)response.toString(false));
        String responseString = response.bodyText();
        if (StringUtils.isBlank((CharSequence)response.charset())) {
            try {
                responseString = new String(response.bodyText().getBytes("ISO-8859-1"), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return responseString;
    }
}

