/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo;

import com.github.fakemongo.Fongo;
import com.github.fakemongo.FongoException;
import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBObject;
import com.mongodb.BulkUpdateRequestBuilder;
import com.mongodb.BulkWriteOperation;
import com.mongodb.BulkWriteRequestBuilder;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.FongoDB;
import com.mongodb.FongoDBCollection;
import com.mongodb.MongoClient;
import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.WriteResult;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.BulkWriteUpsert;
import com.mongodb.bulk.DeleteRequest;
import com.mongodb.bulk.InsertRequest;
import com.mongodb.bulk.UpdateRequest;
import com.mongodb.bulk.WriteRequest;
import com.mongodb.connection.BulkWriteBatchCombiner;
import com.mongodb.connection.ClusterId;
import com.mongodb.connection.Connection;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.QueryResult;
import com.mongodb.connection.ServerId;
import com.mongodb.connection.ServerVersion;
import com.mongodb.internal.connection.IndexMap;
import com.mongodb.internal.validator.CollectibleDocumentFieldNameValidator;
import com.mongodb.internal.validator.UpdateFieldNameValidator;
import com.mongodb.operation.FongoBsonArrayWrapper;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonReader;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.FieldNameValidator;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FongoConnection
implements Connection {
    private static final Logger LOG = LoggerFactory.getLogger(FongoConnection.class);
    private final Fongo fongo;
    private final ConnectionDescription connectionDescription;

    public FongoConnection(final Fongo fongo) {
        this.fongo = fongo;
        this.connectionDescription = new ConnectionDescription(new ServerId(new ClusterId(), fongo.getServerAddress())){

            public ServerVersion getServerVersion() {
                return fongo.getServerVersion();
            }
        };
    }

    public Connection retain() {
        LOG.debug("retain()");
        return this;
    }

    public ConnectionDescription getDescription() {
        return this.connectionDescription;
    }

    public WriteConcernResult insert(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<InsertRequest> inserts) {
        LOG.info("insert() namespace:{} inserts:{}", (Object)namespace, inserts);
        DBCollection collection = this.dbCollection(namespace);
        for (InsertRequest insert : inserts) {
            DBObject parse = FongoDBCollection.dbObject(insert.getDocument());
            collection.insert(parse, writeConcern);
            LOG.debug("insert() namespace:{} insert:{}, parse:{}", new Object[]{namespace, insert.getDocument(), parse.getClass()});
        }
        if (writeConcern.isAcknowledged()) {
            return WriteConcernResult.acknowledged((int)inserts.size(), (boolean)false, null);
        }
        return WriteConcernResult.unacknowledged();
    }

    public WriteConcernResult update(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<UpdateRequest> updates) {
        LOG.info("update() namespace:{} updates:{}", (Object)namespace, updates);
        DBCollection collection = this.dbCollection(namespace);
        boolean isUpdateOfExisting = false;
        BsonValue upsertedId = null;
        int count = 0;
        for (UpdateRequest update : updates) {
            Object validator = update.getType() == WriteRequest.Type.REPLACE ? new CollectibleDocumentFieldNameValidator() : new UpdateFieldNameValidator();
            for (String updateName : update.getUpdate().keySet()) {
                if (validator.validate(updateName)) continue;
                throw new IllegalArgumentException("Invalid BSON field name " + updateName);
            }
            WriteResult writeResult = collection.update(FongoDBCollection.dbObject(update.getFilter()), FongoDBCollection.dbObject(update.getUpdate()), update.isUpsert(), update.isMulti());
            if (writeResult.isUpdateOfExisting()) {
                isUpdateOfExisting = true;
                count += writeResult.getN();
                continue;
            }
            ++count;
        }
        if (writeConcern.isAcknowledged()) {
            return WriteConcernResult.acknowledged((int)count, (boolean)isUpdateOfExisting, upsertedId);
        }
        return WriteConcernResult.unacknowledged();
    }

    public WriteConcernResult delete(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<DeleteRequest> deletes) {
        LOG.info("delete() namespace:{} deletes:{}", (Object)namespace, deletes);
        DBCollection collection = this.dbCollection(namespace);
        int count = 0;
        for (DeleteRequest delete : deletes) {
            DBObject parse = FongoDBCollection.dbObject(delete.getFilter());
            if (delete.isMulti()) {
                WriteResult writeResult = collection.remove(parse, writeConcern);
                count += writeResult.getN();
                continue;
            }
            DBObject dbObject = collection.findAndRemove(parse);
            if (dbObject == null) continue;
            ++count;
        }
        if (writeConcern.isAcknowledged()) {
            return WriteConcernResult.acknowledged((int)count, (count != 0 ? 1 : 0) != 0, null);
        }
        return WriteConcernResult.unacknowledged();
    }

    public BulkWriteResult insertCommand(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<InsertRequest> inserts) {
        LOG.info("insertCommand() namespace:{} inserts:{}", (Object)namespace, inserts);
        DBCollection collection = this.dbCollection(namespace);
        ArrayList<BulkWriteUpsert> list = new ArrayList<BulkWriteUpsert>();
        int i = 0;
        for (InsertRequest insert : inserts) {
            DBObject parse = FongoDBCollection.dbObject(insert.getDocument());
            WriteResult writeResult = collection.insert(parse, writeConcern);
            if (writeResult.getUpsertedId() != null) {
                list.add(new BulkWriteUpsert(i, (BsonValue)new BsonObjectId((ObjectId)writeResult.getUpsertedId())));
            }
            ++i;
            LOG.debug("insertCommand() namespace:{} insert:{}, parse:{}", new Object[]{namespace, insert.getDocument(), parse.getClass()});
        }
        if (writeConcern.isAcknowledged()) {
            return BulkWriteResult.acknowledged((WriteRequest.Type)WriteRequest.Type.INSERT, (int)inserts.size(), (Integer)(writeConcern.isAcknowledged() ? Integer.valueOf(inserts.size()) : null), list);
        }
        return BulkWriteResult.unacknowledged();
    }

    public BulkWriteResult updateCommand(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<UpdateRequest> updates) {
        LOG.info("updateCommand() namespace:{} updates:{}", (Object)namespace, updates);
        DBCollection collection = this.dbCollection(namespace);
        BulkWriteOperation bulkWriteOperation = collection.initializeOrderedBulkOperation();
        BulkWriteBatchCombiner bulkWriteBatchCombiner = new BulkWriteBatchCombiner(this.fongo.getServerAddress(), ordered, writeConcern);
        IndexMap indexMap = IndexMap.create();
        for (UpdateRequest update : updates) {
            Object validator = update.getType() == WriteRequest.Type.REPLACE || update.getType() == WriteRequest.Type.INSERT ? new CollectibleDocumentFieldNameValidator() : new UpdateFieldNameValidator();
            for (String updateName : update.getUpdate().keySet()) {
                if (validator.validate(updateName)) continue;
                throw new IllegalArgumentException("Invalid BSON field name " + updateName);
            }
            switch (update.getType()) {
                case REPLACE: {
                    bulkWriteOperation.find(FongoDBCollection.dbObject(update.getFilter())).replaceOne(FongoDBCollection.dbObject(update.getUpdate()));
                    break;
                }
                case INSERT: {
                    bulkWriteOperation.insert(FongoDBCollection.dbObject(update.getUpdate()));
                    break;
                }
                case UPDATE: {
                    if (update.isUpsert()) {
                        BulkUpdateRequestBuilder upsert = bulkWriteOperation.find(FongoDBCollection.dbObject(update.getFilter())).upsert();
                        if (update.isMulti()) {
                            upsert.update(FongoDBCollection.dbObject(update.getUpdate()));
                            break;
                        }
                        upsert.updateOne(FongoDBCollection.dbObject(update.getUpdate()));
                        break;
                    }
                    BulkWriteRequestBuilder bulkWriteRequestBuilder = bulkWriteOperation.find(FongoDBCollection.dbObject(update.getFilter()));
                    if (update.isMulti()) {
                        bulkWriteRequestBuilder.update(FongoDBCollection.dbObject(update.getUpdate()));
                        break;
                    }
                    bulkWriteRequestBuilder.updateOne(FongoDBCollection.dbObject(update.getUpdate()));
                    break;
                }
                case DELETE: {
                    bulkWriteOperation.find(FongoDBCollection.dbObject(update.getFilter())).removeOne();
                }
            }
            com.mongodb.BulkWriteResult bulkWriteResult = bulkWriteOperation.execute(writeConcern);
            indexMap = indexMap.add(1, 0);
            bulkWriteBatchCombiner.addResult(this.bulkWriteResult(bulkWriteResult), indexMap);
        }
        return bulkWriteBatchCombiner.getResult();
    }

    public BulkWriteResult deleteCommand(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<DeleteRequest> deletes) {
        LOG.info("deleteCommand() namespace:{} deletes:{}", (Object)namespace, deletes);
        DBCollection collection = this.dbCollection(namespace);
        int count = 0;
        for (DeleteRequest delete : deletes) {
            DBObject parse = FongoDBCollection.dbObject(delete.getFilter());
            if (delete.isMulti()) {
                WriteResult writeResult = collection.remove(parse, writeConcern);
                count += writeResult.getN();
                continue;
            }
            DBObject dbObject = collection.findAndRemove(parse);
            if (dbObject == null) continue;
            ++count;
        }
        if (writeConcern.isAcknowledged()) {
            return BulkWriteResult.acknowledged((WriteRequest.Type)WriteRequest.Type.DELETE, (int)count, (Integer)(writeConcern.isAcknowledged() ? Integer.valueOf(deletes.size()) : null), Collections.emptyList());
        }
        return BulkWriteResult.unacknowledged();
    }

    public <T> T command(String database, BsonDocument command, boolean slaveOk, FieldNameValidator fieldNameValidator, Decoder<T> commandResultDecoder) {
        DB db = this.fongo.getDB(database);
        LOG.info("command() database:{}, command:{}", (Object)database, (Object)command);
        if (command.containsKey((Object)"count")) {
            DBCollection dbCollection = db.getCollection(command.get((Object)"count").asString().getValue());
            DBObject query = FongoDBCollection.dbObject(command, "query");
            long limit = command.containsKey((Object)"limit") ? command.getInt64((Object)"limit").longValue() : -1L;
            long skip = command.containsKey((Object)"skip") ? command.getInt64((Object)"skip").longValue() : 0L;
            return (T)new BsonDocument("n", (BsonValue)new BsonInt64(dbCollection.getCount(query, null, limit, skip)));
        }
        if (command.containsKey((Object)"findandmodify")) {
            DBCollection dbCollection = db.getCollection(command.get((Object)"findandmodify").asString().getValue());
            DBObject query = FongoDBCollection.dbObject(command, "query");
            DBObject update = FongoDBCollection.dbObject(command, "update");
            DBObject fields = FongoDBCollection.dbObject(command, "fields");
            DBObject sort = FongoDBCollection.dbObject(command, "sort");
            boolean returnNew = BsonBoolean.TRUE.equals((Object)command.getBoolean((Object)"new", BsonBoolean.FALSE));
            boolean upsert = BsonBoolean.TRUE.equals((Object)command.getBoolean((Object)"upsert", BsonBoolean.FALSE));
            boolean remove = BsonBoolean.TRUE.equals((Object)command.getBoolean((Object)"remove", BsonBoolean.FALSE));
            if (update != null) {
                FieldNameValidator validatorUpdate = fieldNameValidator.getValidatorForField("update");
                for (String updateName : update.keySet()) {
                    if (validatorUpdate.validate(updateName)) continue;
                    throw new IllegalArgumentException("Invalid BSON field name " + updateName);
                }
            }
            DBObject andModify = dbCollection.findAndModify(query, fields, sort, remove, update, returnNew, upsert);
            return this.reencode(commandResultDecoder, "value", andModify);
        }
        if (command.containsKey((Object)"distinct")) {
            DBCollection dbCollection = db.getCollection(command.get((Object)"distinct").asString().getValue());
            DBObject query = FongoDBCollection.dbObject(command, "query");
            List distincts = dbCollection.distinct(command.getString((Object)"key").getValue(), query);
            return (T)new BsonDocument("values", FongoBsonArrayWrapper.bsonArrayWrapper(distincts));
        }
        if (command.containsKey((Object)"aggregate")) {
            DBCollection dbCollection = db.getCollection(command.get((Object)"aggregate").asString().getValue());
            AggregationOutput aggregate = dbCollection.aggregate(FongoDBCollection.dbObjects(command, "pipeline"));
            boolean v3 = command.containsKey((Object)"cursor");
            String resultField = v3 ? "cursor" : "result";
            Iterable results = aggregate.results();
            if (!v3) {
                return this.reencode(commandResultDecoder, resultField, results);
            }
            Codec documentCodec = MongoClient.getDefaultCodecRegistry().get(Document.class);
            ArrayList<Document> each = new ArrayList<Document>();
            for (DBObject result : results) {
                Document decode = (Document)documentCodec.decode((BsonReader)new BsonDocumentReader(FongoDBCollection.bsonDocument(result)), FongoDBCollection.decoderContext());
                each.add(decode);
            }
            return (T)new BsonDocument("cursor", (BsonValue)new BsonDocument("id", (BsonValue)new BsonInt64(0L)).append("ns", (BsonValue)new BsonString(dbCollection.getFullName())).append("firstBatch", FongoBsonArrayWrapper.bsonArrayWrapper(each)));
        }
        if (command.containsKey((Object)"renameCollection")) {
            ((FongoDB)db).renameCollection(command.getString((Object)"renameCollection").getValue(), command.getString((Object)"to").getValue(), command.getBoolean((Object)"dropTarget", BsonBoolean.FALSE).getValue());
            return (T)new BsonDocument("ok", (BsonValue)BsonBoolean.TRUE);
        }
        if (command.containsKey((Object)"createIndexes")) {
            DBCollection dbCollection = db.getCollection(command.get((Object)"createIndexes").asString().getValue());
            List indexes = command.getArray((Object)"indexes").getValues();
            for (BsonValue indexBson : indexes) {
                BsonDocument bsonDocument = indexBson.asDocument();
                DBObject keys = FongoDBCollection.dbObject(bsonDocument.getDocument((Object)"key"));
                String name = bsonDocument.getString((Object)"name").getValue();
                boolean unique = bsonDocument.getBoolean((Object)"unique", BsonBoolean.FALSE).getValue();
                dbCollection.createIndex(keys, name, unique);
            }
            return (T)new BsonDocument("ok", (BsonValue)BsonBoolean.TRUE);
        }
        if (command.containsKey((Object)"drop")) {
            DBCollection dbCollection = db.getCollection(command.get((Object)"drop").asString().getValue());
            dbCollection.drop();
            return (T)new BsonDocument("ok", (BsonValue)BsonBoolean.TRUE);
        }
        if (command.containsKey((Object)"listIndexes")) {
            DBCollection dbCollection = db.getCollection(command.get((Object)"listIndexes").asString().getValue());
            BasicDBObject cmd = new BasicDBObject();
            cmd.put((Object)"ns", (Object)dbCollection.getFullName());
            DBCursor cur = dbCollection.getDB().getCollection("system.indexes").find((DBObject)cmd);
            return (T)new BsonDocument("cursor", (BsonValue)new BsonDocument("id", (BsonValue)new BsonInt64(0L)).append("ns", (BsonValue)new BsonString(dbCollection.getFullName())).append("firstBatch", FongoBsonArrayWrapper.bsonArrayWrapper(cur.toArray())));
        }
        if (command.containsKey((Object)"listCollections")) {
            ArrayList<Document> result = new ArrayList<Document>();
            for (String name : db.getCollectionNames()) {
                result.add(new Document("name", (Object)name).append("options", (Object)new Document()));
            }
            return (T)new BsonDocument("cursor", (BsonValue)new BsonDocument("id", (BsonValue)new BsonInt64(0L)).append("ns", (BsonValue)new BsonString(db.getName() + ".dontkown")).append("firstBatch", FongoBsonArrayWrapper.bsonArrayWrapper(result)));
        }
        LOG.warn("Command not implemented: {}", (Object)command);
        throw new FongoException("Not implemented for command : " + JSON.serialize((Object)FongoDBCollection.dbObject(command)));
    }

    private <T> T reencode(Decoder<T> commandResultDecoder, String resultField, Iterable<DBObject> results) {
        return (T)commandResultDecoder.decode((BsonReader)new BsonDocumentReader(new BsonDocument(resultField, (BsonValue)new BsonArray(FongoDBCollection.bsonDocuments(results)))), FongoDBCollection.decoderContext());
    }

    private <T> T reencode(Decoder<T> commandResultDecoder, String resultField, DBObject result) {
        Object value = result == null ? new BsonNull() : FongoDBCollection.bsonDocument(result);
        return (T)commandResultDecoder.decode((BsonReader)new BsonDocumentReader(new BsonDocument(resultField, (BsonValue)value)), FongoDBCollection.decoderContext());
    }

    public <T> QueryResult<T> query(MongoNamespace namespace, BsonDocument queryDocument, BsonDocument fields, int numberToReturn, int skip, boolean slaveOk, boolean tailableCursor, boolean awaitData, boolean noCursorTimeout, boolean partial, boolean oplogReplay, Decoder<T> resultDecoder) {
        LOG.info("query() namespace:{} queryDocument:{}, fields:{}", new Object[]{namespace, queryDocument, fields});
        DBCollection collection = this.dbCollection(namespace);
        List objects = collection.find(FongoDBCollection.dbObject(queryDocument), FongoDBCollection.dbObject(fields)).limit(numberToReturn).skip(skip).toArray();
        return new QueryResult(namespace, FongoDBCollection.decode(objects, resultDecoder), 1L, this.fongo.getServerAddress());
    }

    public <T> QueryResult<T> getMore(MongoNamespace namespace, long cursorId, int numberToReturn, Decoder<T> resultDecoder) {
        LOG.info("getMore() namespace:{} cursorId:{}", (Object)namespace, (Object)cursorId);
        return new QueryResult(namespace, Collections.emptyList(), 0L, this.fongo.getServerAddress());
    }

    public void killCursor(List<Long> cursors) {
        LOG.info("killCursor() cursors:{}", cursors);
    }

    public int getCount() {
        LOG.info("getCount()");
        return 0;
    }

    public void release() {
        LOG.info("release()");
    }

    private DBCollection dbCollection(MongoNamespace namespace) {
        return this.fongo.getDB(namespace.getDatabaseName()).getCollection(namespace.getCollectionName());
    }

    private BulkWriteResult bulkWriteResult(com.mongodb.BulkWriteResult bulkWriteResult) {
        if (!bulkWriteResult.isAcknowledged()) {
            return BulkWriteResult.unacknowledged();
        }
        return BulkWriteResult.acknowledged((int)bulkWriteResult.getInsertedCount(), (int)(bulkWriteResult.getMatchedCount() - bulkWriteResult.getUpserts().size()), (int)bulkWriteResult.getRemovedCount(), (Integer)bulkWriteResult.getModifiedCount(), FongoDBCollection.translateBulkWriteUpsertsToNew(bulkWriteResult.getUpserts(), null));
    }
}

