/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.impl.aggregation;

import com.github.fakemongo.impl.Util;
import com.github.fakemongo.impl.aggregation.PipelineKeyword;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.FongoDB;
import com.mongodb.MongoException;
import com.mongodb.annotations.ThreadSafe;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class Project
extends PipelineKeyword {
    private static final Logger LOG = LoggerFactory.getLogger(Project.class);
    public static final Project INSTANCE = new Project();

    private Project() {
    }

    @Override
    public DBCollection apply(DBCollection coll, DBObject object) {
        LOG.debug("project() : {}", (Object)object);
        DBObject project = (DBObject)object.get(this.getKeyword());
        DBObject projectResult = Util.clone(project);
        HashMap<String, ProjectedAbstract> projectedFields = new HashMap<String, ProjectedAbstract>();
        for (Map.Entry<String, Object> entry : Util.entrySet(project)) {
            if (entry.getValue() == null) continue;
            ProjectedAbstract.createMapping(coll, projectResult, projectedFields, entry.getKey(), entry.getValue(), "", ProjectedRename.newInstance(entry.getKey(), coll, null));
        }
        LOG.debug("project() of {} renamed {}", (Object)projectResult, projectedFields);
        List objects = coll.find(null, projectResult).toArray();
        ArrayList<DBObject> objectsResults = new ArrayList<DBObject>(objects.size());
        for (DBObject result : objects) {
            BasicDBObject renamed = new BasicDBObject("_id", result.get("_id"));
            for (Map.Entry entry : projectedFields.entrySet()) {
                if (!Util.containsField(result, (String)entry.getKey())) continue;
                ((ProjectedAbstract)entry.getValue()).unapply((DBObject)renamed, result, (String)entry.getKey());
            }
            for (ProjectedAbstract projected : projectedFields.values()) {
                projected.unapply((DBObject)renamed, result, null);
            }
            objectsResults.add((DBObject)renamed);
        }
        coll = this.dropAndInsert(coll, objectsResults);
        LOG.debug("project() : {}, result : {}", (Object)object, (Object)objects);
        return coll;
    }

    @Override
    public String getKeyword() {
        return "$project";
    }

    static class ProjectedDateMillisecond
    extends ProjectedDate<ProjectedDateMillisecond> {
        public static final String KEYWORD = "$millisecond";

        public ProjectedDateMillisecond(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, 14, 0, destName, coll, object);
        }
    }

    static class ProjectedDateSecond
    extends ProjectedDate<ProjectedDateSecond> {
        public static final String KEYWORD = "$second";

        public ProjectedDateSecond(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, 13, 0, destName, coll, object);
        }
    }

    static class ProjectedDateMinute
    extends ProjectedDate<ProjectedDateMinute> {
        public static final String KEYWORD = "$minute";

        public ProjectedDateMinute(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, 12, 0, destName, coll, object);
        }
    }

    static class ProjectedDateHour
    extends ProjectedDate<ProjectedDateHour> {
        public static final String KEYWORD = "$hour";

        public ProjectedDateHour(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, 11, 0, destName, coll, object);
        }
    }

    static class ProjectedDateWeek
    extends ProjectedDate<ProjectedDateWeek> {
        public static final String KEYWORD = "$week";

        public ProjectedDateWeek(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, 3, -1, destName, coll, object);
        }
    }

    static class ProjectedDateMonth
    extends ProjectedDate<ProjectedDateMonth> {
        public static final String KEYWORD = "$month";

        public ProjectedDateMonth(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, 2, 1, destName, coll, object);
        }
    }

    static class ProjectedDateYear
    extends ProjectedDate<ProjectedDateYear> {
        public static final String KEYWORD = "$year";

        public ProjectedDateYear(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, 1, 0, destName, coll, object);
        }
    }

    static class ProjectedDateDayOfWeek
    extends ProjectedDate<ProjectedDateDayOfWeek> {
        public static final String KEYWORD = "$dayOfWeek";

        public ProjectedDateDayOfWeek(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, 7, 0, destName, coll, object);
        }
    }

    static class ProjectedDateDayOfMonth
    extends ProjectedDate<ProjectedDateDayOfMonth> {
        public static final String KEYWORD = "$dayOfMonth";

        public ProjectedDateDayOfMonth(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, 5, 0, destName, coll, object);
        }
    }

    static class ProjectedDateDayOfYear
    extends ProjectedDate<ProjectedDateDayOfYear> {
        public static final String KEYWORD = "$dayOfYear";

        public ProjectedDateDayOfYear(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, 6, 0, destName, coll, object);
        }
    }

    static abstract class ProjectedDate<T extends ProjectedDate>
    extends ProjectedAbstract<T> {
        private final String field;
        private final int fromCalendar;
        private final int modifier;

        public ProjectedDate(String keyword, int fromCalendar, int modifier, String destName, DBCollection coll, DBObject object) {
            super(keyword, destName, object);
            Object value = object.get(keyword);
            this.fromCalendar = fromCalendar;
            this.modifier = modifier;
            if (!(value instanceof String)) {
                ProjectedDate.errorResult(coll, 16020, "the " + keyword + " operator requires a field name");
            }
            this.field = (String)value;
        }

        @Override
        void doWork(DBCollection coll, DBObject projectResult, Map<String, ProjectedAbstract> projectedFields, String key, Object value, String namespace) {
            ProjectedDate.createMapping(coll, projectResult, projectedFields, this.field, this.field, namespace, this);
        }

        @Override
        public void unapply(DBObject result, DBObject object, String key) {
            Object value = ProjectedDate.extractValue(object, this.field);
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.ENGLISH);
            calendar.setTimeInMillis(((Date)value).getTime());
            int extracted = calendar.get(this.fromCalendar) + this.modifier;
            result.put(this.destName, (Object)extracted);
        }
    }

    static class ProjectedToDivide
    extends ProjectedAbstract<ProjectedToDivide> {
        public static final String KEYWORD = "$divide";
        private final double result;

        public ProjectedToDivide(String destName, DBCollection coll, DBObject object) {
            this(KEYWORD, destName, coll, object);
        }

        ProjectedToDivide(String keyword, String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, destName, object);
            Object value = object.get(keyword);
            if (!(value instanceof List) || ((List)value).size() != 2) {
                ProjectedToDivide.errorResult(coll, 16020, "the " + keyword + " operator requires an array of 2 operands");
            }
            List values = (List)value;
            double modulus = ((Number)values.get(0)).doubleValue();
            double expectedValue = ((Number)values.get(1)).doubleValue();
            this.result = expectedValue % modulus;
        }

        @Override
        void doWork(DBCollection coll, DBObject projectResult, Map<String, ProjectedAbstract> projectedFields, String key, Object value, String namespace) {
            ProjectedToDivide.createMapping(coll, projectResult, projectedFields, this.destName, this.destName, namespace, this);
        }

        @Override
        public void unapply(DBObject result, DBObject object, String key) {
            result.put(this.destName, (Object)this.result);
        }
    }

    static class ProjectedToUpper
    extends ProjectedToLower {
        public static final String KEYWORD = "$toUpper";

        public ProjectedToUpper(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, destName, coll, object);
        }

        @Override
        protected String transformValue(String value) {
            return value.toUpperCase();
        }
    }

    static class ProjectedToLower
    extends ProjectedAbstract<ProjectedToLower> {
        public static final String KEYWORD = "$toLower";
        private final String field;

        public ProjectedToLower(String destName, DBCollection coll, DBObject object) {
            this(KEYWORD, destName, coll, object);
        }

        ProjectedToLower(String keyword, String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, destName, object);
            Object value = object.get(keyword);
            if (value instanceof List) {
                List values = (List)value;
                if (values.size() != 1) {
                    ProjectedToLower.errorResult(coll, 16020, "the " + keyword + " operator requires 1 operand(s)");
                }
                this.field = (String)values.get(0);
            } else {
                this.field = value.toString();
            }
        }

        @Override
        void doWork(DBCollection coll, DBObject projectResult, Map<String, ProjectedAbstract> projectedFields, String key, Object value, String namespace) {
            ProjectedToLower.createMapping(coll, projectResult, projectedFields, this.field, this.field, namespace, this);
        }

        @Override
        public void unapply(DBObject result, DBObject object, String key) {
            Object value = ProjectedToLower.extractValue(object, this.field);
            value = value == null ? "" : this.transformValue(value.toString());
            result.put(this.destName, value);
        }

        String transformValue(String value) {
            return value.toLowerCase();
        }
    }

    static class ProjectedStrcasecmp
    extends ProjectedCmp {
        public static final String KEYWORD = "$strcasecmp";

        public ProjectedStrcasecmp(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, destName, coll, object);
        }

        @Override
        protected int compare(String value1, String value2) {
            return value1.compareToIgnoreCase(value2);
        }
    }

    static class ProjectedCmp
    extends ProjectedAbstract<ProjectedCmp> {
        public static final String KEYWORD = "$cmp";
        private final String field1;
        private final String field2;

        public ProjectedCmp(String destName, DBCollection coll, DBObject object) {
            this(KEYWORD, destName, coll, object);
        }

        public ProjectedCmp(String keyword, String destName, DBCollection coll, DBObject object) {
            super(keyword, destName, object);
            Object value = object.get(keyword);
            if (!(value instanceof List) || ((List)value).size() != 2) {
                ProjectedCmp.errorResult(coll, 16020, "the " + keyword + " operator requires an array of 2 operands");
            }
            List values = (List)value;
            this.field1 = (String)values.get(0);
            this.field2 = (String)values.get(1);
        }

        @Override
        void doWork(DBCollection coll, DBObject projectResult, Map<String, ProjectedAbstract> projectedFields, String key, Object value, String namespace) {
            ProjectedCmp.createMapping(coll, projectResult, projectedFields, this.field1, this.field1, namespace, this);
            ProjectedCmp.createMapping(coll, projectResult, projectedFields, this.field2, this.field2, namespace, this);
        }

        @Override
        public void unapply(DBObject result, DBObject object, String key) {
            String secondValue;
            String value = ProjectedCmp.extractValue(object, this.field1).toString();
            int strcmp = this.compare(value, secondValue = ProjectedCmp.extractValue(object, this.field2).toString());
            result.put(this.destName, (Object)(strcmp < 0 ? -1 : (strcmp > 1 ? 1 : 0)));
        }

        int compare(String value1, String value2) {
            return value1.compareTo(value2);
        }
    }

    static class ProjectedSubstr
    extends ProjectedAbstract<ProjectedSubstr> {
        public static final String KEYWORD = "$substr";
        private final String field;
        private final int start;
        private final int end;

        public ProjectedSubstr(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, destName, object);
            Object value = object.get(this.keyword);
            if (!(value instanceof List) || ((List)value).size() != 3) {
                ProjectedSubstr.errorResult(coll, 16020, "the $substr operator requires an array of 3 operands");
            }
            List values = (List)value;
            this.field = (String)values.get(0);
            this.start = ((Number)values.get(1)).intValue();
            this.end = ((Number)values.get(2)).intValue();
        }

        @Override
        void doWork(DBCollection coll, DBObject projectResult, Map<String, ProjectedAbstract> projectedFields, String key, Object value, String namespace) {
            ProjectedSubstr.createMapping(coll, projectResult, projectedFields, this.destName, this.destName, namespace, this);
        }

        @Override
        public void unapply(DBObject result, DBObject object, String key) {
            String value;
            Object exracted = ProjectedSubstr.extractValue(object, this.field);
            String string = value = exracted == null ? null : String.valueOf(exracted);
            value = value == null ? "" : (this.start >= value.length() ? "" : value.substring(this.start, Math.min(this.end, value.length())));
            result.put(this.destName, (Object)value);
        }
    }

    static class ProjectedConcat
    extends ProjectedAbstract<ProjectedConcat> {
        public static final String KEYWORD = "$concat";
        private List<Object> toConcat = null;

        public ProjectedConcat(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, destName, object);
            Object value = object.get(this.keyword);
            if (!(value instanceof List) || ((List)value).size() == 0) {
                ProjectedConcat.errorResult(coll, 16020, "the $concat operator requires an array of operands");
            }
            this.toConcat = (List)value;
        }

        @Override
        void doWork(DBCollection coll, DBObject projectResult, Map<String, ProjectedAbstract> projectedFields, String key, Object value, String namespace) {
            for (Object field : this.toConcat) {
                if (field instanceof String) {
                    ProjectedConcat.createMapping(coll, projectResult, projectedFields, (String)field, (String)field, namespace, this);
                    continue;
                }
                if (!(field instanceof DBObject)) continue;
            }
        }

        @Override
        public void unapply(DBObject result, DBObject object, String key) {
            StringBuilder sb = new StringBuilder();
            for (Object info : this.toConcat) {
                Object value = ProjectedConcat.extractValue(object, info);
                if (value == null) {
                    result.put(this.destName, null);
                    return;
                }
                String str = value.toString();
                sb.append(str);
            }
            result.put(this.destName, (Object)sb.toString());
        }
    }

    static class ProjectedIfNull
    extends ProjectedAbstract<ProjectedIfNull> {
        public static final String KEYWORD = "$ifNull";
        private final String field;
        private final String valueIfNull;

        public ProjectedIfNull(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, destName, object);
            Object value = object.get(this.keyword);
            if (!(value instanceof List) || ((List)value).size() != 2) {
                ProjectedIfNull.errorResult(coll, 16020, "the $ifNull operator requires an array of 2 operands");
            }
            List values = (List)value;
            this.field = (String)values.get(0);
            this.valueIfNull = (String)values.get(1);
        }

        @Override
        void doWork(DBCollection coll, DBObject projectResult, Map<String, ProjectedAbstract> projectedFields, String key, Object value, String namespace) {
            ProjectedIfNull.createMapping(coll, projectResult, projectedFields, this.field, this.field, namespace, this);
            ProjectedIfNull.createMapping(coll, projectResult, projectedFields, this.valueIfNull, this.valueIfNull, namespace, this);
        }

        @Override
        public void unapply(DBObject result, DBObject object, String key) {
            Object value = ProjectedIfNull.extractValue(object, this.field);
            if (value == null) {
                value = ProjectedIfNull.extractValue(object, this.valueIfNull);
            }
            result.put(this.destName, value);
        }
    }

    static class ProjectedRename
    extends ProjectedAbstract<ProjectedRename> {
        public static final String KEYWORD = "$___fongo$internal$";

        private ProjectedRename(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, destName, object);
        }

        public static ProjectedRename newInstance(String destName, DBCollection coll, DBObject object) {
            return new ProjectedRename(destName, coll, object);
        }

        @Override
        public void unapply(DBObject result, DBObject object, String key) {
            if (key != null) {
                Object value = Util.extractField(object, key);
                Util.putValue(result, this.destName, value);
            }
        }

        @Override
        void doWork(DBCollection coll, DBObject projectResult, Map<String, ProjectedAbstract> projectedFields, String key, Object value, String namespace) {
        }
    }

    static abstract class ProjectedAbstract<T extends ProjectedAbstract> {
        static final Map<String, Class<? extends ProjectedAbstract>> projectedAbstractMap = new HashMap<String, Class<? extends ProjectedAbstract>>();
        final String keyword;
        final String destName;
        final List<String> infos = new ArrayList<String>();

        private ProjectedAbstract(String keyword, String destName, DBObject object) {
            this.keyword = keyword;
            this.destName = destName;
        }

        public T addInfo(String info) {
            this.infos.add(info);
            return (T)this;
        }

        public abstract void unapply(DBObject var1, DBObject var2, String var3);

        abstract void doWork(DBCollection var1, DBObject var2, Map<String, ProjectedAbstract> var3, String var4, Object var5, String var6);

        public final void apply(DBCollection coll, DBObject projectResult, Map<String, ProjectedAbstract> projectedFields, String key, DBObject value, String namespace) {
            this.doWork(coll, projectResult, projectedFields, key, value.get(this.keyword), namespace);
        }

        public static void createMapping(DBCollection coll, DBObject projectResult, Map<String, ProjectedAbstract> projectedFields, String key, Object kvalue, String namespace, ProjectedAbstract projected) {
            if (kvalue instanceof String) {
                String value = kvalue.toString();
                if (value.startsWith("$")) {
                    String fieldName = kvalue.toString().substring(1);
                    projectedFields.put(fieldName, (ProjectedAbstract)projected.addInfo(namespace + key));
                    projectResult.removeField(key);
                    if (fieldName.contains(".")) {
                        projectResult.put(fieldName.substring(0, fieldName.indexOf(46)), (Object)1);
                    } else {
                        projectResult.put(fieldName, (Object)1);
                    }
                } else {
                    projectedFields.put(value, (ProjectedAbstract)projected.addInfo(value));
                }
            } else if (kvalue instanceof DBObject) {
                DBObject value = (DBObject)kvalue;
                ProjectedAbstract projectedAbstract = ProjectedAbstract.getProjected(value, coll, key);
                if (projectedAbstract != null) {
                    projectedAbstract.apply(coll, projectResult, projectedFields, key, value, namespace);
                    projectResult.removeField(key);
                } else {
                    projectResult.removeField(key);
                    for (Map.Entry<String, Object> subentry : Util.entrySet(value)) {
                        ProjectedAbstract.createMapping(coll, projectResult, projectedFields, subentry.getKey(), subentry.getValue(), namespace + key + ".", ProjectedRename.newInstance(namespace + key + "." + subentry.getKey(), coll, null));
                    }
                }
            } else {
                projectedFields.put(key, (ProjectedAbstract)projected.addInfo(key));
            }
        }

        private static ProjectedAbstract getProjected(DBObject value, DBCollection coll, String destName) {
            for (Map.Entry<String, Class<? extends ProjectedAbstract>> entry : projectedAbstractMap.entrySet()) {
                if (!value.containsField(entry.getKey())) continue;
                try {
                    return entry.getValue().getConstructor(String.class, DBCollection.class, DBObject.class).newInstance(destName, coll, value);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof MongoException) {
                        throw (MongoException)e.getTargetException();
                    }
                    throw new RuntimeException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }

        static void errorResult(DBCollection coll, int code, String err) {
            ((FongoDB)coll.getDB()).notOkErrorResult(code, err).throwOnError();
        }

        static <T> T extractValue(DBObject object, Object fieldOrValue) {
            if (fieldOrValue instanceof String && fieldOrValue.toString().startsWith("$")) {
                return Util.extractField(object, fieldOrValue.toString().substring(1));
            }
            return (T)fieldOrValue;
        }

        static {
            projectedAbstractMap.put("$strcasecmp", ProjectedStrcasecmp.class);
            projectedAbstractMap.put("$cmp", ProjectedCmp.class);
            projectedAbstractMap.put("$substr", ProjectedSubstr.class);
            projectedAbstractMap.put("$ifNull", ProjectedIfNull.class);
            projectedAbstractMap.put("$concat", ProjectedConcat.class);
            projectedAbstractMap.put("$toLower", ProjectedToLower.class);
            projectedAbstractMap.put("$toUpper", ProjectedToUpper.class);
            projectedAbstractMap.put("$divide", ProjectedToDivide.class);
            projectedAbstractMap.put("$dayOfYear", ProjectedDateDayOfYear.class);
            projectedAbstractMap.put("$dayOfMonth", ProjectedDateDayOfMonth.class);
            projectedAbstractMap.put("$dayOfWeek", ProjectedDateDayOfWeek.class);
            projectedAbstractMap.put("$year", ProjectedDateYear.class);
            projectedAbstractMap.put("$month", ProjectedDateMonth.class);
            projectedAbstractMap.put("$week", ProjectedDateWeek.class);
            projectedAbstractMap.put("$hour", ProjectedDateHour.class);
            projectedAbstractMap.put("$minute", ProjectedDateMinute.class);
            projectedAbstractMap.put("$second", ProjectedDateSecond.class);
            projectedAbstractMap.put("$millisecond", ProjectedDateMillisecond.class);
        }
    }
}

