/*
 * Decompiled with CFR 0.152.
 */
package com.github.fommil.jni;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class JniLoader {
    private static final Logger log = Logger.getLogger(JniLoader.class.getName());
    public static final String JNI_EXTRACT_DIR_PROP = "com.github.fommil.jni.dir";
    private static final Set<String> loaded = new HashSet<String>();

    public static synchronized void load(String ... paths) {
        if (paths == null || paths.length == 0) {
            throw new ExceptionInInitializerError("invalid parameters");
        }
        for (String path : paths) {
            String key = new File(path).getName();
            if (!loaded.contains(key)) continue;
            log.info("already loaded " + path);
            return;
        }
        String[] javaLibPath = System.getProperty("java.library.path").split(File.pathSeparator);
        for (String path : paths) {
            log.config("JNI LIB = " + path);
            for (String libPath : javaLibPath) {
                File file = new File(libPath, path).getAbsoluteFile();
                log.finest("checking " + file);
                if (!file.exists() || !file.isFile() || !JniLoader.liberalLoad(file, path)) continue;
                return;
            }
            File extracted = JniLoader.extract(path);
            if (extracted == null || !JniLoader.liberalLoad(extracted, path)) continue;
            return;
        }
        throw new ExceptionInInitializerError("unable to load from " + Arrays.toString(paths));
    }

    private static boolean liberalLoad(File file, String name) {
        try {
            log.finest("attempting to load " + file);
            System.load(file.getAbsolutePath());
            log.info("successfully loaded " + file);
            loaded.add(name);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            log.log(Level.FINE, "skipping load of " + file, e);
            String tmpdir = System.getProperty("java.io.tmpdir");
            if (tmpdir != null && tmpdir.trim().length() > 2 && file.getAbsolutePath().startsWith(tmpdir)) {
                log.log(Level.FINE, "deleting " + file);
                try {
                    file.delete();
                }
                catch (Exception e2) {
                    log.info("failed to delete " + file);
                }
            }
            return false;
        }
        catch (SecurityException e) {
            log.log(Level.INFO, "skipping load of " + file, e);
            return false;
        }
        catch (Throwable e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private static File extract(String path) {
        try {
            long start = System.currentTimeMillis();
            URL url = JniLoader.class.getResource("/" + path);
            if (url == null) {
                return null;
            }
            log.fine("attempting to extract " + url);
            InputStream in = JniLoader.class.getResourceAsStream("/" + path);
            try {
                File file;
                block12: {
                    File file2 = JniLoader.file(path);
                    JniLoader.deleteOnExit(file2);
                    log.config("extracting " + url + " to " + file2.getAbsoluteFile());
                    ReadableByteChannel src = Channels.newChannel(in);
                    FileChannel dest = new FileOutputStream(file2).getChannel();
                    try {
                        dest.transferFrom(src, 0L, Long.MAX_VALUE);
                        long end = System.currentTimeMillis();
                        log.fine("extracted " + path + " in " + (end - start) + " millis");
                        file = file2;
                        if (Collections.singletonList(dest).get(0) == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (Collections.singletonList(dest).get(0) != null) {
                            dest.close();
                        }
                        throw throwable;
                    }
                    dest.close();
                }
                return file;
            }
            finally {
                if (Collections.singletonList(in).get(0) != null) {
                    in.close();
                }
            }
        }
        catch (Throwable e) {
            if (e instanceof SecurityException || e instanceof IOException) {
                log.log(Level.CONFIG, "skipping extraction of " + path, e);
                return null;
            }
            throw new ExceptionInInitializerError(e);
        }
    }

    private static File file(String path) throws IOException {
        String name = new File(path).getName();
        String dir = System.getProperty(JNI_EXTRACT_DIR_PROP);
        if (dir == null) {
            return File.createTempFile("jniloader", name);
        }
        File file = new File(dir, name);
        if (file.exists() && !file.isFile()) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " is not a file.");
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        return file;
    }

    private static void deleteOnExit(File file) {
        try {
            file.deleteOnExit();
        }
        catch (Exception e1) {
            log.log(Level.INFO, file.getAbsolutePath() + " delete denied, retrying - might be Java bug #6997203.");
            try {
                System.gc();
                Thread.yield();
                file.deleteOnExit();
            }
            catch (Exception e2) {
                log.log(Level.WARNING, file.getAbsolutePath() + " delete denied a second time.", e2);
            }
        }
    }

    private JniLoader() {
    }
}

