/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.opencc4j.util;

import com.github.houbb.opencc4j.core.Segment;
import com.github.houbb.opencc4j.core.ZhConvert;
import com.github.houbb.opencc4j.core.impl.CharSegment;
import com.github.houbb.opencc4j.core.impl.HuabanSegment;
import com.github.houbb.opencc4j.core.impl.ToSimpleZhConvert;
import com.github.houbb.opencc4j.core.impl.ToTraditonZhConvert;
import com.github.houbb.paradise.common.util.CollectionUtil;
import com.github.houbb.paradise.common.util.StringUtil;
import java.util.List;

public final class ZhConverterUtil {
    private ZhConverterUtil() {
    }

    public static String convertToSimple(String original) {
        return ZhConverterUtil.convertToSimple(original, true);
    }

    public static String convertToTraditional(String original) {
        return ZhConverterUtil.convertToTraditional(original, true);
    }

    public static String convertToSimple(String original, boolean huabanSegment) {
        ToSimpleZhConvert zhConvert = new ToSimpleZhConvert();
        Segment segment = ZhConverterUtil.getSegment(huabanSegment);
        return ZhConverterUtil.convert(original, segment, zhConvert);
    }

    public static String convertToTraditional(String original, boolean huabanSegment) {
        ToTraditonZhConvert zhConvert = new ToTraditonZhConvert();
        Segment segment = ZhConverterUtil.getSegment(huabanSegment);
        return ZhConverterUtil.convert(original, segment, zhConvert);
    }

    private static Segment getSegment(boolean huabanSegment) {
        if (huabanSegment) {
            return new HuabanSegment();
        }
        return new CharSegment();
    }

    private static String convert(String original, Segment segment, ZhConvert zhConvert) {
        if (StringUtil.isEmpty((String)original)) {
            return original;
        }
        List<String> stringList = segment.seg(original);
        if (CollectionUtil.isEmpty(stringList)) {
            return original;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringList) {
            String result = zhConvert.convert(string);
            stringBuilder.append(result);
        }
        return stringBuilder.toString();
    }
}

