/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.paradise.common.util;

import com.github.houbb.paradise.common.util.ClassUtil;
import com.github.houbb.paradise.common.util.CollectionUtil;
import com.github.houbb.paradise.common.util.MapUtil;
import com.github.houbb.paradise.common.util.StringUtil;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class ObjectUtil {
    private ObjectUtil() {
    }

    public static Boolean isSameType(Object one, Object two) {
        Class<?> clazzOne = one.getClass();
        if (clazzOne.isInstance(two)) {
            return true;
        }
        return false;
    }

    public static Boolean isNotSameType(Object one, Object two) {
        return ObjectUtil.isSameType(one, two) == false;
    }

    public static Boolean isNull(Object object) {
        if (null == object) {
            return true;
        }
        return false;
    }

    public static Boolean isNotNull(Object object) {
        return ObjectUtil.isNull(object) == false;
    }

    public static Boolean isEmpty(Object object) {
        if (ObjectUtil.isNull(object).booleanValue()) {
            return true;
        }
        if (object instanceof String) {
            String string = (String)object;
            return StringUtil.isEmpty(string);
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            return CollectionUtil.isEmpty(collection);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return MapUtil.isEmpty(map);
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object) == 0;
        }
        return false;
    }

    public static Boolean isNotEmpty(Object object) {
        return ObjectUtil.isEmpty(object) == false;
    }

    public static boolean isEquals(Object except, Object real) {
        if (ObjectUtil.isNotSameType(except, real).booleanValue()) {
            return false;
        }
        if (ClassUtil.isPrimitive(except).booleanValue() && ClassUtil.isPrimitive(real).booleanValue() && except != real) {
            return false;
        }
        if (ClassUtil.isArray(except).booleanValue() && ClassUtil.isArray(real).booleanValue()) {
            Object[] exceptArray = (Object[])except;
            Object[] realArray = (Object[])real;
            return Arrays.equals(exceptArray, realArray);
        }
        if (ClassUtil.isMap(except).booleanValue() && ClassUtil.isMap(real).booleanValue()) {
            Map exceptMap = (Map)except;
            Map realMap = (Map)real;
            return exceptMap.equals(realMap);
        }
        return except.equals(real);
    }

    public static Boolean isNotEquals(Object except, Object real) {
        return !ObjectUtil.isEquals(except, real);
    }
}

