/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.paradise.common.util.path;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ArchiveUtils {
    public static void unzipFileTo(String file, String dest) throws IOException {
        File target = new File(file);
        if (!target.exists()) {
            throw new IllegalArgumentException("Archive doesnt exist");
        }
        FileInputStream fin = new FileInputStream(target);
        int BUFFER = 2048;
        byte[] data = new byte[BUFFER];
        if (file.endsWith(".zip") || file.endsWith(".jar")) {
            ZipInputStream zis = new ZipInputStream(fin);
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                int len;
                String fileName = ze.getName();
                File newFile = new File(dest + File.separator + fileName);
                if (ze.isDirectory()) {
                    newFile.mkdirs();
                    zis.closeEntry();
                    ze = zis.getNextEntry();
                    continue;
                }
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(data)) > 0) {
                    fos.write(data, 0, len);
                }
                fos.flush();
                fos.close();
                zis.closeEntry();
                ze = zis.getNextEntry();
            }
            zis.close();
        }
    }
}

