/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.paradise.common.util.reflection;

import com.github.houbb.paradise.common.util.ArgUtil;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;

public class ReflectionUtil {
    public static List<Field> getAllFieldsList(Class<?> cls) {
        ArgUtil.notNull(cls, "cls can't not be null!");
        LinkedList<Field> allFields = new LinkedList<Field>();
        for (Class<?> currentClass = cls; currentClass != null; currentClass = currentClass.getSuperclass()) {
            for (Field field : currentClass.getDeclaredFields()) {
                allFields.add(field);
            }
        }
        return allFields;
    }

    public static Class getListType(Field field) {
        ParameterizedType listGenericType = (ParameterizedType)field.getGenericType();
        Type[] listActualTypeArguments = listGenericType.getActualTypeArguments();
        return (Class)listActualTypeArguments[0];
    }
}

