# 响应码设计草案

错误码怎么设计无所谓，只需要适合自己的业务。简单明了清晰，便于问题的排查即可。

## 初步设计

- 预留位

留作更复杂的系统拓展。

- 系统码

分布式系统。每一个子系统都应该有一个唯一标识。单系统可默认为 001 之类。

- 内部/外部

00 内部

01 外部

- 01

不同的层级。比如：web/facade/biz/service/dal/util

- 001

业务分类。

登录/注册/找回密码等这样的业务

- 0001

具体业务的错误。

```
XX_001_01_01_001_0001

预留位_子系统码_内部/外部_哪一层_业务分类_具体的错误(16位)
```










# 错误枚举名称


## 命名规范

为了直观看出是哪一类错误，请以如下约定命名:

使用英文大写。以下划线分割。如：
用户未找到异常

```
USER_NOT_FOUND_EXCEPTION
```

下列分类放在最后一位。
一般鼓励使用全拼，不过有些单词使用的较多，也都约定俗成是可以简化的。

## 常见分类

- 错误

使用 ERR or ERROR

- 异常

使用 EXCP or EXCEPTION

- 失败

使用 FAIL or FAILED