/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser;

import com.github.javaparser.GeneratedJavaParser;
import com.github.javaparser.JavaToken;
import com.github.javaparser.ParseException;
import com.github.javaparser.Token;
import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.ArrayCreationLevel;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ArrayCreationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ArrayType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.UnknownType;
import com.github.javaparser.utils.Pair;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

class GeneratedJavaParserSupport {
    GeneratedJavaParserSupport() {
    }

    static <X extends Node> NodeList<X> emptyList() {
        return new NodeList();
    }

    static <T extends Node> NodeList<T> add(NodeList<T> list, T obj) {
        if (list == null) {
            list = new NodeList();
        }
        list.add((Object)obj);
        return list;
    }

    static <T extends Node> NodeList<T> addWhenNotNull(NodeList<T> list, T obj) {
        if (obj == null) {
            return list;
        }
        return GeneratedJavaParserSupport.add(list, obj);
    }

    static <T extends Node> NodeList<T> prepend(NodeList<T> list, T obj) {
        if (list == null) {
            list = new NodeList();
        }
        list.add(0, (Object)obj);
        return list;
    }

    static <T> List<T> add(List<T> list, T obj) {
        if (list == null) {
            list = new LinkedList<T>();
        }
        list.add(obj);
        return list;
    }

    static void addModifier(GeneratedJavaParser generatedJavaParser, EnumSet<Modifier> modifiers, Modifier mod) {
        if (modifiers.contains((Object)mod)) {
            generatedJavaParser.addProblem("Duplicated modifier");
        }
        modifiers.add(mod);
    }

    static TokenRange range(GeneratedJavaParser generatedJavaParser, JavaToken begin, JavaToken end) {
        if (generatedJavaParser.storeTokens) {
            return new TokenRange(begin, end);
        }
        return null;
    }

    static TokenRange range(GeneratedJavaParser generatedJavaParser, Node begin, Node end) {
        if (generatedJavaParser.storeTokens) {
            return new TokenRange(begin.getTokenRange().get().getBegin(), end.getTokenRange().get().getEnd());
        }
        return null;
    }

    private static void propagateRangeGrowthOnRight(GeneratedJavaParser generatedJavaParser, Node node, Node endNode) {
        if (generatedJavaParser.storeTokens) {
            node.getParentNode().ifPresent(nodeParent -> {
                boolean isChildOnTheRightBorderOfParent = node.getTokenRange().get().getEnd().equals(nodeParent.getTokenRange().get().getEnd());
                if (isChildOnTheRightBorderOfParent) {
                    GeneratedJavaParserSupport.propagateRangeGrowthOnRight(generatedJavaParser, nodeParent, endNode);
                }
            });
            node.setTokenRange(GeneratedJavaParserSupport.range(generatedJavaParser, node, endNode));
        }
    }

    static Expression generateLambda(GeneratedJavaParser generatedJavaParser, Expression ret, Statement lambdaBody) {
        if (ret instanceof EnclosedExpr) {
            Expression inner = ((EnclosedExpr)ret).getInner();
            SimpleName id = ((NameExpr)inner).getName();
            NodeList<Parameter> params = GeneratedJavaParserSupport.add(new NodeList(), new Parameter(ret.getTokenRange().orElse(null), EnumSet.noneOf(Modifier.class), new NodeList<AnnotationExpr>(), new UnknownType(), false, new NodeList<AnnotationExpr>(), id));
            ret = new LambdaExpr(GeneratedJavaParserSupport.range(generatedJavaParser, ret, lambdaBody), params, lambdaBody, true);
        } else if (ret instanceof NameExpr) {
            SimpleName id = ((NameExpr)ret).getName();
            NodeList<Parameter> params = GeneratedJavaParserSupport.add(new NodeList(), new Parameter(ret.getTokenRange().orElse(null), EnumSet.noneOf(Modifier.class), new NodeList<AnnotationExpr>(), new UnknownType(), false, new NodeList<AnnotationExpr>(), id));
            ret = new LambdaExpr(GeneratedJavaParserSupport.range(generatedJavaParser, ret, lambdaBody), params, lambdaBody, false);
        } else if (ret instanceof LambdaExpr) {
            ((LambdaExpr)ret).setBody(lambdaBody);
            GeneratedJavaParserSupport.propagateRangeGrowthOnRight(generatedJavaParser, ret, lambdaBody);
        } else if (ret instanceof CastExpr) {
            CastExpr castExpr = (CastExpr)ret;
            Expression inner = GeneratedJavaParserSupport.generateLambda(generatedJavaParser, castExpr.getExpression(), lambdaBody);
            castExpr.setExpression(inner);
        } else {
            generatedJavaParser.addProblem("Failed to parse lambda expression! Please create an issue at https://github.com/javaparser/javaparser/issues");
        }
        return ret;
    }

    static ArrayCreationExpr juggleArrayCreation(TokenRange range, List<TokenRange> levelRanges, Type type, NodeList<Expression> dimensions, List<NodeList<AnnotationExpr>> arrayAnnotations, ArrayInitializerExpr arrayInitializerExpr) {
        NodeList<ArrayCreationLevel> levels = new NodeList<ArrayCreationLevel>();
        for (int i = 0; i < arrayAnnotations.size(); ++i) {
            levels.add(new ArrayCreationLevel(levelRanges.get(i), (Expression)dimensions.get(i), arrayAnnotations.get(i)));
        }
        return new ArrayCreationExpr(range, type, levels, arrayInitializerExpr);
    }

    static Type juggleArrayType(Type partialType, List<ArrayType.ArrayBracketPair> additionalBrackets) {
        Pair<Type, List<ArrayType.ArrayBracketPair>> partialParts = ArrayType.unwrapArrayTypes(partialType);
        Type elementType = (Type)partialParts.a;
        List leftMostBrackets = (List)partialParts.b;
        return ArrayType.wrapInArrayTypes(elementType, leftMostBrackets, additionalBrackets).clone();
    }

    static TokenRange tokenRange(Token token) {
        JavaToken javaToken = ((GeneratedJavaParser.CustomToken)token).javaToken;
        return new TokenRange(javaToken, javaToken);
    }

    static JavaToken nodeListBegin(NodeList<?> l) {
        if (l.isEmpty()) {
            return JavaToken.INVALID;
        }
        return ((Node)l.get(0)).getTokenRange().get().getBegin();
    }

    static String makeMessageForParseException(ParseException exception) {
        StringBuilder sb = new StringBuilder("Parse error. Found ");
        StringBuilder expected = new StringBuilder();
        int maxExpectedTokenSequenceLength = 0;
        TreeSet<String> sortedOptions = new TreeSet<String>();
        for (int i = 0; i < exception.expectedTokenSequences.length; ++i) {
            if (maxExpectedTokenSequenceLength < exception.expectedTokenSequences[i].length) {
                maxExpectedTokenSequenceLength = exception.expectedTokenSequences[i].length;
            }
            for (int j = 0; j < exception.expectedTokenSequences[i].length; ++j) {
                sortedOptions.add(exception.tokenImage[exception.expectedTokenSequences[i][j]]);
            }
        }
        for (String option : sortedOptions) {
            expected.append(" ").append(option);
        }
        sb.append("");
        Token token = exception.currentToken.next;
        for (int i = 0; i < maxExpectedTokenSequenceLength; ++i) {
            String tokenText = token.image;
            String escapedTokenText = ParseException.add_escapes(tokenText);
            if (i != 0) {
                sb.append(" ");
            }
            if (token.kind == 0) {
                sb.append(exception.tokenImage[0]);
                break;
            }
            String image = exception.tokenImage[token.kind];
            escapedTokenText = "\"" + escapedTokenText + "\"";
            if (image.equals(escapedTokenText)) {
                sb.append(image);
            } else {
                sb.append(" ").append(escapedTokenText).append(" ").append(image);
            }
            token = token.next;
        }
        if (exception.expectedTokenSequences.length != 0) {
            int numExpectedTokens = exception.expectedTokenSequences.length;
            sb.append(", expected").append(numExpectedTokens == 1 ? "" : " one of ").append(expected.toString());
        }
        return sb.toString();
    }
}

