/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client;

import com.github.mjeanroy.junit.servers.client.Cookies;
import com.github.mjeanroy.junit.servers.commons.ToStringBuilder;
import java.util.Objects;

public class Cookie {
    private final String name;
    private final String value;
    private final String domain;
    private final String path;
    private final Long expires;
    private final Long maxAge;
    private final boolean secure;
    private final boolean httpOnly;

    @Deprecated
    public static Cookie read(String rawValue) {
        return Cookies.read(rawValue);
    }

    @Deprecated
    public static Cookie cookie(String name, String value) {
        return Cookies.cookie(name, value);
    }

    @Deprecated
    public static Cookie cookie(String name, String value, String domain, String path, Long expires, Long maxAge, boolean secure, boolean httpOnly) {
        return Cookies.cookie(name, value, domain, path, expires, maxAge, secure, httpOnly);
    }

    @Deprecated
    public static Cookie secureCookie(String name, String value, String domain, String path, Long expires, Long maxAge) {
        return Cookies.secureCookie(name, value, domain, path, expires, maxAge);
    }

    @Deprecated
    public static Cookie sessionCookie(String name, String value, String domain, String path) {
        return Cookies.sessionCookie(name, value, domain, path);
    }

    private Cookie(String name, String value, String domain, String path, boolean secure, boolean httpOnly, Long expires, Long maxAge) {
        this.name = name;
        this.value = value;
        this.domain = domain;
        this.path = path;
        this.expires = expires;
        this.maxAge = maxAge;
        this.secure = secure;
        this.httpOnly = httpOnly;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPath() {
        return this.path;
    }

    public Long getExpires() {
        return this.expires;
    }

    public Long getMaxAge() {
        return this.maxAge;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Cookie) {
            Cookie c = (Cookie)o;
            return Objects.equals(this.name, c.name) && Objects.equals(this.value, c.value) && Objects.equals(this.domain, c.domain) && Objects.equals(this.path, c.path) && Objects.equals(this.expires, c.expires) && Objects.equals(this.maxAge, c.maxAge) && this.secure == c.secure && this.httpOnly == c.httpOnly;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.domain, this.path, this.expires, this.maxAge, this.secure, this.httpOnly);
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("name", this.name).append("value", this.value).append("domain", this.domain).append("path", this.path).append("expires", this.expires).append("maxAge", this.maxAge).append("secure", this.secure).append("httpOnly", this.httpOnly).build();
    }

    public static class Builder {
        private final String name;
        private final String value;
        private String domain;
        private String path;
        private Long maxAge;
        private Long expires;
        private boolean secure;
        private boolean httpOnly;

        public Builder(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public Builder httpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
            return this;
        }

        public Builder maxAge(long maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public Builder expires(long expires) {
            this.expires = expires;
            return this;
        }

        public Cookie build() {
            return new Cookie(this.name, this.value, this.domain, this.path, this.secure, this.httpOnly, this.expires, this.maxAge);
        }
    }
}

