/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client;

import com.github.mjeanroy.junit.servers.client.HttpClient;
import com.github.mjeanroy.junit.servers.client.HttpClientConfiguration;
import com.github.mjeanroy.junit.servers.client.impl.apache.ApacheHttpClient;
import com.github.mjeanroy.junit.servers.client.impl.async.AsyncHttpClient;
import com.github.mjeanroy.junit.servers.client.impl.ning.NingAsyncHttpClient;
import com.github.mjeanroy.junit.servers.client.impl.okhttp3.OkHttpClient;
import com.github.mjeanroy.junit.servers.commons.ClassUtils;
import com.github.mjeanroy.junit.servers.servers.AbstractConfiguration;
import com.github.mjeanroy.junit.servers.servers.EmbeddedServer;

public enum HttpClientStrategy {
    OK_HTTP3("OkHttp"){

        @Override
        public boolean support() {
            return SUPPORT_OK_HTTP3_CLIENT;
        }

        @Override
        HttpClient instantiate(EmbeddedServer<? extends AbstractConfiguration> server) {
            return OkHttpClient.defaultOkHttpClient(server);
        }

        @Override
        HttpClient instantiate(HttpClientConfiguration configuration, EmbeddedServer<? extends AbstractConfiguration> server) {
            return OkHttpClient.newOkHttpClient(configuration, server);
        }
    }
    ,
    ASYNC_HTTP_CLIENT("AsyncHttpClient"){

        @Override
        public boolean support() {
            return SUPPORT_JAVA_8 && SUPPORT_ASYNC_HTTP_CLIENT;
        }

        @Override
        HttpClient instantiate(EmbeddedServer<? extends AbstractConfiguration> server) {
            return AsyncHttpClient.defaultAsyncHttpClient(server);
        }

        @Override
        HttpClient instantiate(HttpClientConfiguration configuration, EmbeddedServer<? extends AbstractConfiguration> server) {
            return AsyncHttpClient.newAsyncHttpClient(configuration, server);
        }
    }
    ,
    NING_ASYNC_HTTP_CLIENT("(Ning) AsyncHttpClient"){

        @Override
        public boolean support() {
            return SUPPORT_NING_ASYNC_HTTP_CLIENT;
        }

        @Override
        HttpClient instantiate(EmbeddedServer<? extends AbstractConfiguration> server) {
            return NingAsyncHttpClient.defaultAsyncHttpClient(server);
        }

        @Override
        HttpClient instantiate(HttpClientConfiguration configuration, EmbeddedServer<? extends AbstractConfiguration> server) {
            return NingAsyncHttpClient.newAsyncHttpClient(configuration, server);
        }
    }
    ,
    APACHE_HTTP_CLIENT("Apache HttpComponent"){

        @Override
        public boolean support() {
            return SUPPORT_APACHE_HTTP_CLIENT;
        }

        @Override
        HttpClient instantiate(EmbeddedServer<? extends AbstractConfiguration> server) {
            return ApacheHttpClient.defaultApacheHttpClient(server);
        }

        @Override
        HttpClient instantiate(HttpClientConfiguration configuration, EmbeddedServer<? extends AbstractConfiguration> server) {
            return ApacheHttpClient.newApacheHttpClient(configuration, server);
        }
    }
    ,
    AUTO("OkHttp OR AsyncHttpClient OR Apache HttpComponent"){

        @Override
        public boolean support() {
            for (HttpClientStrategy strategy : HttpClientStrategy.values()) {
                if (strategy == this || !strategy.support()) continue;
                return true;
            }
            return false;
        }

        @Override
        HttpClient instantiate(EmbeddedServer<? extends AbstractConfiguration> server) {
            for (HttpClientStrategy strategy : HttpClientStrategy.values()) {
                if (!strategy.support()) continue;
                return strategy.instantiate(server);
            }
            throw new UnsupportedOperationException("Http client implementation cannot be found, please add OkHttp, AsyncHttpClient or ApacheHttpClient to your classpath");
        }

        @Override
        HttpClient instantiate(HttpClientConfiguration configuration, EmbeddedServer<? extends AbstractConfiguration> server) {
            for (HttpClientStrategy strategy : HttpClientStrategy.values()) {
                if (!strategy.support()) continue;
                return strategy.instantiate(configuration, server);
            }
            throw new UnsupportedOperationException("Http client implementation cannot be found, please add OkHttp, AsyncHttpClient or ApacheHttpClient to your classpath");
        }
    };

    private static final String COMPLETABLE_FUTURE_CLASS = "java.util.concurrent.CompletableFuture";
    private static final boolean SUPPORT_JAVA_8;
    private static final String ASYNC_HTTP_CLIENT_CLASS = "org.asynchttpclient.DefaultAsyncHttpClient";
    private static final boolean SUPPORT_ASYNC_HTTP_CLIENT;
    private static final String NING_ASYNC_HTTP_CLIENT_CLASS = "com.ning.http.client.AsyncHttpClient";
    private static final boolean SUPPORT_NING_ASYNC_HTTP_CLIENT;
    private static final String APACHE_HTTP_CLIENT_CLASS = "org.apache.http.impl.client.CloseableHttpClient";
    private static final boolean SUPPORT_APACHE_HTTP_CLIENT;
    private static final String OK_HTTP3_CLIENT_CLASS = "okhttp3.OkHttpClient";
    private static final boolean SUPPORT_OK_HTTP3_CLIENT;
    private final String library;

    private HttpClientStrategy(String library) {
        this.library = library;
    }

    public HttpClient build(EmbeddedServer<? extends AbstractConfiguration> server) {
        this.checkSupport();
        return this.instantiate(server);
    }

    public HttpClient build(HttpClientConfiguration configuration, EmbeddedServer<? extends AbstractConfiguration> server) {
        this.checkSupport();
        return this.instantiate(configuration, server);
    }

    void checkSupport() {
        if (!this.support()) {
            throw new UnsupportedOperationException("HTTP Client cannot be created because it is not supported by the runtime environment, please import " + this.library);
        }
    }

    public abstract boolean support();

    abstract HttpClient instantiate(EmbeddedServer<? extends AbstractConfiguration> var1);

    abstract HttpClient instantiate(HttpClientConfiguration var1, EmbeddedServer<? extends AbstractConfiguration> var2);

    static {
        SUPPORT_JAVA_8 = ClassUtils.isPresent(COMPLETABLE_FUTURE_CLASS);
        SUPPORT_ASYNC_HTTP_CLIENT = SUPPORT_JAVA_8 && ClassUtils.isPresent(ASYNC_HTTP_CLIENT_CLASS);
        SUPPORT_NING_ASYNC_HTTP_CLIENT = ClassUtils.isPresent(NING_ASYNC_HTTP_CLIENT_CLASS);
        SUPPORT_APACHE_HTTP_CLIENT = ClassUtils.isPresent(APACHE_HTTP_CLIENT_CLASS);
        SUPPORT_OK_HTTP3_CLIENT = ClassUtils.isPresent(OK_HTTP3_CLIENT_CLASS);
    }
}

