/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client.impl;

import com.github.mjeanroy.junit.servers.client.Cookie;
import com.github.mjeanroy.junit.servers.client.HttpClient;
import com.github.mjeanroy.junit.servers.client.HttpClientConfiguration;
import com.github.mjeanroy.junit.servers.client.HttpHeader;
import com.github.mjeanroy.junit.servers.client.HttpMethod;
import com.github.mjeanroy.junit.servers.client.HttpRequest;
import com.github.mjeanroy.junit.servers.client.HttpUrl;
import com.github.mjeanroy.junit.servers.commons.Preconditions;
import com.github.mjeanroy.junit.servers.commons.Strings;
import com.github.mjeanroy.junit.servers.commons.UrlUtils;
import com.github.mjeanroy.junit.servers.servers.EmbeddedServer;

public abstract class AbstractHttpClient
implements HttpClient {
    private final HttpClientConfiguration configuration;
    private final EmbeddedServer<?> server;

    protected AbstractHttpClient(HttpClientConfiguration configuration, EmbeddedServer<?> server) {
        this.configuration = Preconditions.notNull(configuration, "configuration");
        this.server = Preconditions.notNull(server, "server");
    }

    @Override
    public HttpClientConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public HttpRequest prepareDelete(String endpoint) {
        return this.prepareRequest(HttpMethod.DELETE, endpoint);
    }

    @Override
    public HttpRequest prepareGet(String endpoint) {
        return this.prepareRequest(HttpMethod.GET, endpoint);
    }

    @Override
    public HttpRequest preparePost(String endpoint) {
        return this.prepareRequest(HttpMethod.POST, endpoint);
    }

    @Override
    public HttpRequest preparePut(String url) {
        return this.prepareRequest(HttpMethod.PUT, url);
    }

    @Override
    public HttpRequest preparePatch(String endpoint) {
        return this.prepareRequest(HttpMethod.PATCH, endpoint);
    }

    @Override
    public HttpRequest prepareHead(String endpoint) {
        return this.prepareRequest(HttpMethod.HEAD, endpoint);
    }

    @Override
    public HttpRequest prepareRequest(HttpMethod httpMethod, String endpoint) {
        HttpUrl requestEndpoint;
        Preconditions.notNull(endpoint, "endpoint");
        if (this.isDestroyed()) {
            throw new IllegalStateException("Cannot create request from a destroyed client");
        }
        if (UrlUtils.startsWithHttpScheme(endpoint)) {
            requestEndpoint = HttpUrl.parse(endpoint);
        } else {
            String serverPath = this.server.getPath();
            requestEndpoint = new HttpUrl.Builder().withScheme(this.server.getScheme()).withHost(this.server.getHost()).withPort(this.server.getPort()).withPath(UrlUtils.concatenatePath(serverPath, Strings.removePrefix(endpoint, serverPath))).build();
        }
        HttpRequest rq = this.buildRequest(httpMethod, requestEndpoint);
        for (HttpHeader header : this.configuration.getDefaultHeaders().values()) {
            rq = rq.addHeader(header);
        }
        for (Cookie cookie : this.configuration.getDefaultCookies()) {
            rq = rq.addCookie(cookie);
        }
        return rq;
    }

    protected abstract HttpRequest buildRequest(HttpMethod var1, HttpUrl var2);

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isDestroyed()) {
            this.destroy();
        }
    }
}

