/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.commons;

import java.util.Map;

public final class ToStringBuilder {
    private static final String SEPARATOR = ", ";
    private static final String OPEN_ARRAY = "[";
    private static final String CLOSE_ARRAY = "]";
    private static final String FIELD_VALUE_SEPARATOR = ": ";
    private static final String START_OBJ = "{";
    private static final String END_OBJ = "}";
    private final StringBuilder sb;
    private boolean first;

    private ToStringBuilder(String klassName) {
        this.sb = new StringBuilder(klassName).append(START_OBJ);
        this.first = true;
    }

    public static ToStringBuilder create(Class<?> klass) {
        return new ToStringBuilder(klass.getSimpleName());
    }

    public ToStringBuilder append(String name, String value) {
        return this.appendValue(name, value);
    }

    public ToStringBuilder append(String name, Integer value) {
        return this.appendValue(name, value);
    }

    public ToStringBuilder append(String name, Long value) {
        return this.appendValue(name, value);
    }

    public ToStringBuilder append(String name, Boolean value) {
        return this.appendValue(name, value);
    }

    public ToStringBuilder append(String name, Map<?, ?> map) {
        StringBuilder sb = new StringBuilder(START_OBJ);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            sb.append(entry.getKey()).append(FIELD_VALUE_SEPARATOR).append(ToStringBuilder.formatValue(entry.getValue()));
        }
        sb.append(END_OBJ);
        return this.appendFormattedValue(name, sb.toString());
    }

    public ToStringBuilder append(String name, Object value) {
        return this.appendValue(name, value);
    }

    public <T> ToStringBuilder append(String name, Iterable<T> values) {
        StringBuilder pending = new StringBuilder().append(OPEN_ARRAY);
        boolean firstItem = true;
        for (T value : values) {
            if (!firstItem) {
                pending.append(SEPARATOR);
            }
            pending.append(ToStringBuilder.formatValue(value));
            firstItem = false;
        }
        return this.appendFormattedValue(name, pending.append(CLOSE_ARRAY).toString());
    }

    private ToStringBuilder appendValue(String name, Object value) {
        return this.appendFormattedValue(name, ToStringBuilder.formatValue(value));
    }

    private ToStringBuilder appendFormattedValue(String name, Object value) {
        if (!this.first) {
            this.sb.append(SEPARATOR);
        }
        this.sb.append(name).append(FIELD_VALUE_SEPARATOR).append(value);
        this.first = false;
        return this;
    }

    public String build() {
        return this.sb.append(END_OBJ).toString();
    }

    private static String formatValue(Object value) {
        if (value == null) {
            return null;
        }
        return value instanceof CharSequence ? "\"" + value + "\"" : value.toString();
    }
}

