/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.servers;

import com.github.mjeanroy.junit.servers.commons.Preconditions;
import com.github.mjeanroy.junit.servers.servers.AbstractConfiguration;
import com.github.mjeanroy.junit.servers.servers.Hook;
import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractConfigurationBuilder<T extends AbstractConfigurationBuilder<T, U>, U extends AbstractConfiguration> {
    private String path = "/";
    private String webapp = "src/main/webapp";
    private int port = 0;
    private String classpath = ".";
    private ClassLoader parentClassLoader = null;
    private final Map<String, String> envProperties = new LinkedHashMap<String, String>();
    private final List<Hook> hooks = new ArrayList<Hook>();
    private String overrideDescriptor;

    protected AbstractConfigurationBuilder() {
    }

    protected abstract T self();

    public abstract U build();

    public String getPath() {
        return this.path;
    }

    public String getWebapp() {
        return this.webapp;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public int getPort() {
        return this.port;
    }

    public Map<String, String> getEnvProperties() {
        return this.envProperties;
    }

    public List<Hook> getHooks() {
        return this.hooks;
    }

    @Deprecated
    public ClassLoader getParentClasspath() {
        return this.getParentClassLoader();
    }

    public ClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    public String getOverrideDescriptor() {
        return this.overrideDescriptor;
    }

    public T withPath(String path) {
        this.path = Preconditions.notNull(path, "path");
        return this.self();
    }

    public T withWebapp(String webapp) {
        this.webapp = Preconditions.notNull(webapp, "webapp");
        return this.self();
    }

    public T withWebapp(File webapp) {
        Preconditions.notNull(webapp, "webapp");
        this.webapp = webapp.getAbsolutePath();
        return this.self();
    }

    public T withPort(int port) {
        this.port = Preconditions.positive(port, "port");
        return this.self();
    }

    public T withClasspath(String classpath) {
        this.classpath = classpath;
        return this.self();
    }

    public T withProperty(String name, String value) {
        this.envProperties.put(Preconditions.notBlank(name, "name"), Preconditions.notNull(value, "value"));
        return this.self();
    }

    public T withHook(Hook hook) {
        this.hooks.add(Preconditions.notNull(hook, "hook"));
        return this.self();
    }

    @Deprecated
    public T withParentClasspath(Class<?> cls, FileFilter filter) {
        return this.withParentClassLoader(cls);
    }

    @Deprecated
    public T withParentClasspath(Class<?> cls) {
        Preconditions.notNull(cls, "Base class");
        return this.withParentClassLoader(cls.getClassLoader());
    }

    public T withParentClassLoader(Class<?> cls) {
        Preconditions.notNull(cls, "Base class");
        return this.withParentClassLoader(cls.getClassLoader());
    }

    public T withParentClasspath(URL classpath, URL ... others) {
        HashSet<URL> classpathUrls = new HashSet<URL>();
        classpathUrls.add(classpath);
        Collections.addAll(classpathUrls, others);
        return this.withParentClasspath(classpathUrls);
    }

    public T withParentClasspath(Collection<URL> classpath) {
        int nbUrls = classpath.size();
        if (nbUrls > 0) {
            URL[] urls = classpath.toArray(new URL[nbUrls]);
            URLClassLoader urlClassLoader = new URLClassLoader(urls);
            this.withParentClassLoader(urlClassLoader);
        }
        return this.self();
    }

    private T withParentClassLoader(ClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
        return this.self();
    }

    public T withOverrideDescriptor(String overrideDescriptor) {
        this.overrideDescriptor = overrideDescriptor;
        return this.self();
    }
}

