/*
 * Decompiled with CFR 0.152.
 */
package oshi.jna.platform.windows;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.WinDef;
import java.util.ArrayList;
import java.util.List;
import oshi.jna.platform.windows.Pdh;

public abstract class PdhUtilJNA {
    public static String PdhLookupPerfNameByIndex(String szMachineName, int dwNameIndex) {
        int charToBytes = Boolean.getBoolean("w32.ascii") ? 1 : Native.WCHAR_SIZE;
        WinDef.DWORDByReference pcchNameBufferSize = new WinDef.DWORDByReference(new WinDef.DWORD(0L));
        Pdh.INSTANCE.PdhLookupPerfNameByIndex(null, dwNameIndex, null, pcchNameBufferSize);
        Memory mem = new Memory((long)(pcchNameBufferSize.getValue().intValue() * charToBytes));
        Pdh.INSTANCE.PdhLookupPerfNameByIndex(null, dwNameIndex, (Pointer)mem, pcchNameBufferSize);
        if (charToBytes == 1) {
            return mem.getString(0L);
        }
        return mem.getWideString(0L);
    }

    public static List<String> PdhEnumObjectItemCounters(String szDataSource, String szMachineName, String szObjectName, int dwDetailLevel) {
        int charToBytes = Boolean.getBoolean("w32.ascii") ? 1 : Native.WCHAR_SIZE;
        WinDef.DWORDByReference pcchCounterListLength = new WinDef.DWORDByReference(new WinDef.DWORD(0L));
        WinDef.DWORDByReference pcchInstanceListLength = new WinDef.DWORDByReference(new WinDef.DWORD(0L));
        Pdh.INSTANCE.PdhEnumObjectItems(szDataSource, szMachineName, szObjectName, null, pcchCounterListLength, null, pcchInstanceListLength, dwDetailLevel, 0);
        Memory mszCounterList = new Memory((long)(pcchCounterListLength.getValue().intValue() * charToBytes));
        Memory mszInstanceList = new Memory((long)(pcchInstanceListLength.getValue().intValue() * charToBytes));
        Pdh.INSTANCE.PdhEnumObjectItems(szDataSource, szMachineName, szObjectName, (Pointer)mszCounterList, pcchCounterListLength, (Pointer)mszInstanceList, pcchInstanceListLength, dwDetailLevel, 0);
        ArrayList<String> counters = new ArrayList<String>();
        int offset = 0;
        while ((long)offset < mszCounterList.size()) {
            String s = null;
            s = charToBytes == 1 ? mszCounterList.getString((long)offset) : mszCounterList.getWideString((long)offset);
            if (s.isEmpty()) break;
            counters.add(s);
            offset += (s.length() + 1) * charToBytes;
        }
        return counters;
    }

    public static List<String> PdhEnumObjectItemInstances(String szDataSource, String szMachineName, String szObjectName, int dwDetailLevel) {
        int charToBytes = Boolean.getBoolean("w32.ascii") ? 1 : Native.WCHAR_SIZE;
        WinDef.DWORDByReference pcchCounterListLength = new WinDef.DWORDByReference(new WinDef.DWORD(0L));
        WinDef.DWORDByReference pcchInstanceListLength = new WinDef.DWORDByReference(new WinDef.DWORD(0L));
        Pdh.INSTANCE.PdhEnumObjectItems(szDataSource, szMachineName, szObjectName, null, pcchCounterListLength, null, pcchInstanceListLength, dwDetailLevel, 0);
        Memory mszCounterList = new Memory((long)(pcchCounterListLength.getValue().intValue() * charToBytes));
        Memory mszInstanceList = new Memory((long)(pcchInstanceListLength.getValue().intValue() * charToBytes));
        Pdh.INSTANCE.PdhEnumObjectItems(szDataSource, szMachineName, szObjectName, (Pointer)mszCounterList, pcchCounterListLength, (Pointer)mszInstanceList, pcchInstanceListLength, dwDetailLevel, 0);
        ArrayList<String> instances = new ArrayList<String>();
        int offset = 0;
        while ((long)offset < mszInstanceList.size()) {
            String s = null;
            s = charToBytes == 1 ? mszInstanceList.getString((long)offset) : mszInstanceList.getWideString((long)offset);
            if (s.isEmpty()) break;
            instances.add(s);
            offset += (s.length() + 1) * charToBytes;
        }
        return instances;
    }
}

