/*
 * Decompiled with CFR 0.152.
 */
package oshi;

import com.sun.jna.Platform;
import java.io.Serializable;
import oshi.PlatformEnum;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.platform.linux.LinuxHardwareAbstractionLayer;
import oshi.hardware.platform.mac.MacHardwareAbstractionLayer;
import oshi.hardware.platform.unix.freebsd.FreeBsdHardwareAbstractionLayer;
import oshi.hardware.platform.unix.solaris.SolarisHardwareAbstractionLayer;
import oshi.hardware.platform.windows.WindowsHardwareAbstractionLayer;
import oshi.software.os.OperatingSystem;
import oshi.software.os.linux.LinuxOperatingSystem;
import oshi.software.os.mac.MacOperatingSystem;
import oshi.software.os.unix.freebsd.FreeBsdOperatingSystem;
import oshi.software.os.unix.solaris.SolarisOperatingSystem;
import oshi.software.os.windows.WindowsOperatingSystem;

public class SystemInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private OperatingSystem os = null;
    private HardwareAbstractionLayer hardware = null;
    private static final PlatformEnum currentPlatformEnum = Platform.isWindows() ? PlatformEnum.WINDOWS : (Platform.isLinux() ? PlatformEnum.LINUX : (Platform.isMac() ? PlatformEnum.MACOSX : (Platform.isSolaris() ? PlatformEnum.SOLARIS : (Platform.isFreeBSD() ? PlatformEnum.FREEBSD : PlatformEnum.UNKNOWN))));

    public static PlatformEnum getCurrentPlatformEnum() {
        return currentPlatformEnum;
    }

    public OperatingSystem getOperatingSystem() {
        if (this.os == null) {
            switch (currentPlatformEnum) {
                case WINDOWS: {
                    this.os = new WindowsOperatingSystem();
                    break;
                }
                case LINUX: {
                    this.os = new LinuxOperatingSystem();
                    break;
                }
                case MACOSX: {
                    this.os = new MacOperatingSystem();
                    break;
                }
                case SOLARIS: {
                    this.os = new SolarisOperatingSystem();
                    break;
                }
                case FREEBSD: {
                    this.os = new FreeBsdOperatingSystem();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Operating system not supported: " + Platform.getOSType());
                }
            }
        }
        return this.os;
    }

    public HardwareAbstractionLayer getHardware() {
        if (this.hardware == null) {
            switch (currentPlatformEnum) {
                case WINDOWS: {
                    this.hardware = new WindowsHardwareAbstractionLayer();
                    break;
                }
                case LINUX: {
                    this.hardware = new LinuxHardwareAbstractionLayer();
                    break;
                }
                case MACOSX: {
                    this.hardware = new MacHardwareAbstractionLayer();
                    break;
                }
                case SOLARIS: {
                    this.hardware = new SolarisHardwareAbstractionLayer();
                    break;
                }
                case FREEBSD: {
                    this.hardware = new FreeBsdHardwareAbstractionLayer();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Operating system not supported: " + Platform.getOSType());
                }
            }
        }
        return this.hardware;
    }
}

