/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import org.snaker.engine.SnakerException;
import org.snaker.engine.core.ServiceContext;
import org.snaker.engine.helper.XmlHelper;
import org.snaker.engine.model.NodeModel;
import org.snaker.engine.model.ProcessModel;
import org.snaker.engine.model.TransitionModel;
import org.snaker.engine.parser.NodeParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ModelParser {
    public static ProcessModel parse(byte[] bytes) {
        DocumentBuilder documentBuilder = XmlHelper.createDocumentBuilder();
        if (documentBuilder != null) {
            Document doc = null;
            try {
                doc = documentBuilder.parse(new ByteArrayInputStream(bytes));
                Element processE = doc.getDocumentElement();
                ProcessModel process = new ProcessModel();
                process.setName(processE.getAttribute("name"));
                process.setDisplayName(processE.getAttribute("displayName"));
                process.setExpireTime(processE.getAttribute("expireTime"));
                process.setInstanceUrl(processE.getAttribute("instanceUrl"));
                process.setInstanceNoClass(processE.getAttribute("instanceNoClass"));
                NodeList nodeList = processE.getChildNodes();
                int nodeSize = nodeList.getLength();
                for (int i = 0; i < nodeSize; ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    NodeModel model = ModelParser.parseModel(node);
                    process.getNodes().add(model);
                }
                for (NodeModel nodeModel : process.getNodes()) {
                    for (TransitionModel transition : nodeModel.getOutputs()) {
                        String to = transition.getTo();
                        for (NodeModel node2 : process.getNodes()) {
                            if (!to.equalsIgnoreCase(node2.getName())) continue;
                            node2.getInputs().add(transition);
                            transition.setTarget(node2);
                        }
                    }
                }
                return process;
            }
            catch (SAXException e) {
                e.printStackTrace();
                throw new SnakerException(e);
            }
            catch (IOException e) {
                throw new SnakerException(e);
            }
        }
        throw new SnakerException("documentBuilder is null");
    }

    private static NodeModel parseModel(Node node) {
        String nodeName = node.getNodeName();
        Element element = (Element)node;
        NodeParser nodeParser = null;
        try {
            nodeParser = ServiceContext.getContext().findByName(nodeName, NodeParser.class);
            nodeParser.parse(element);
            return nodeParser.getModel();
        }
        catch (RuntimeException e) {
            throw new SnakerException(e);
        }
    }
}

