/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.handlers.impl;

import java.util.List;
import org.snaker.engine.IQueryService;
import org.snaker.engine.access.QueryFilter;
import org.snaker.engine.core.Execution;
import org.snaker.engine.entity.Order;
import org.snaker.engine.entity.Task;
import org.snaker.engine.handlers.IHandler;
import org.snaker.engine.model.ProcessModel;
import org.snaker.engine.model.SubProcessModel;
import org.snaker.engine.model.TaskModel;

public abstract class AbstractMergeHandler
implements IHandler {
    public void handle(Execution execution) {
        List<Task> tasks;
        QueryFilter filter;
        IQueryService queryService = execution.getEngine().query();
        Order order = execution.getOrder();
        ProcessModel model = execution.getModel();
        String[] activeNodes = this.findActiveNodes();
        boolean isSubProcessMerged = false;
        boolean isTaskMerged = false;
        if (model.containsNodeNames(SubProcessModel.class, activeNodes)) {
            filter = new QueryFilter().setParentId(order.getId()).setExcludedIds(new String[]{execution.getChildOrderId()});
            List<Order> orders = queryService.getActiveOrders(filter);
            if (orders == null || orders.isEmpty()) {
                isSubProcessMerged = true;
            }
        } else {
            isSubProcessMerged = true;
        }
        if (isSubProcessMerged && model.containsNodeNames(TaskModel.class, activeNodes) && ((tasks = queryService.getActiveTasks(filter = new QueryFilter().setOrderId(order.getId()).setExcludedIds(new String[]{execution.getTask().getId()}).setNames(activeNodes))) == null || tasks.isEmpty())) {
            isTaskMerged = true;
        }
        execution.setMerged(isSubProcessMerged && isTaskMerged);
    }

    protected abstract String[] findActiveNodes();
}

