/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.scheduling.quartz;

import java.util.List;
import java.util.Map;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snaker.engine.entity.Process;
import org.snaker.engine.entity.Task;
import org.snaker.engine.helper.StringHelper;
import org.snaker.engine.model.NodeModel;
import org.snaker.engine.model.TaskModel;
import org.snaker.engine.scheduling.JobCallback;
import org.snaker.engine.scheduling.quartz.AbstractJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutorJob
extends AbstractJob {
    private static final Logger log = LoggerFactory.getLogger(ExecutorJob.class);

    @Override
    public void exec(Process process, String orderId, String taskId, NodeModel nodeModel, Map<String, Object> data) throws JobExecutionException {
        log.info("ExecutorJob execute taskId:{}", (Object)taskId);
        if (nodeModel == null || !(nodeModel instanceof TaskModel)) {
            log.debug("\u8282\u70b9\u6a21\u578b\u4e3a\u7a7a\uff0c\u6216\u4e0d\u662f\u4efb\u52a1\u6a21\u578b\uff0c\u5219\u4e0d\u6ee1\u8db3\u6267\u884c\u6761\u4ef6");
            return;
        }
        TaskModel tm = (TaskModel)nodeModel;
        List tasks = null;
        if (StringHelper.isNotEmpty((String)tm.getAutoExecute()) && tm.getAutoExecute().equalsIgnoreCase("Y")) {
            tasks = this.engine.executeTask(taskId, "snaker.auto", data);
            this.schedule().delete("reminder." + taskId);
        }
        this.callback(tm.getCallbackObject(), taskId, tasks);
    }

    private void callback(JobCallback jobCallback, String taskId, List<Task> tasks) {
        if (jobCallback == null) {
            return;
        }
        jobCallback.callback(taskId, tasks);
    }
}

