/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.spring;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snaker.engine.Context;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringContext
implements Context {
    private static final Logger log = LoggerFactory.getLogger(SpringContext.class);
    private ApplicationContext applicationContext;
    private DefaultListableBeanFactory beanFactory;

    public SpringContext(ApplicationContext ctx) {
        this.applicationContext = ctx;
        this.beanFactory = (DefaultListableBeanFactory)ctx.getAutowireCapableBeanFactory();
    }

    public <T> T find(Class<T> clazz) {
        String[] names = this.applicationContext.getBeanNamesForType(clazz);
        if (names.length > 1 && log.isWarnEnabled()) {
            log.warn("\u91cd\u590d\u5b9a\u4e49\u7c7b\u578b:" + clazz);
        }
        if (names.length >= 1) {
            return (T)this.applicationContext.getBean(names[0]);
        }
        return null;
    }

    public <T> List<T> findList(Class<T> clazz) {
        String[] names = this.applicationContext.getBeanNamesForType(clazz);
        ArrayList<Object> beans = new ArrayList<Object>();
        for (String name : names) {
            beans.add(this.applicationContext.getBean(name));
        }
        return beans;
    }

    public <T> T findByName(String name, Class<T> clazz) {
        return (T)this.applicationContext.getBean(name, clazz);
    }

    public void put(String name, Object object) {
        log.warn("spring\u4e0d\u652f\u6301\u5411applicationContext\u4e2d\u76f4\u63a5\u6dfb\u52a0\u5bf9\u8c61");
    }

    public void put(String name, Class<?> clazz) {
        RootBeanDefinition definition = new RootBeanDefinition(clazz);
        this.beanFactory.registerBeanDefinition(name, (BeanDefinition)definition);
    }

    public boolean exist(String name) {
        return this.applicationContext.containsBean(name);
    }
}

